/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.interfaces.IDimensionManager;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;

public class DimensionManager
implements IDimensionManager {
    IVoxelMap master;
    public ArrayList<DimensionContainer> dimensions;
    private ArrayList<class_5321<class_1937>> vanillaWorlds = new ArrayList();

    public DimensionManager(IVoxelMap master) {
        this.master = master;
        this.dimensions = new ArrayList();
        this.vanillaWorlds.add((class_5321<class_1937>)class_1937.field_25179);
        this.vanillaWorlds.add((class_5321<class_1937>)class_1937.field_25180);
        this.vanillaWorlds.add((class_5321<class_1937>)class_1937.field_25181);
    }

    @Override
    public ArrayList<DimensionContainer> getDimensions() {
        return this.dimensions;
    }

    @Override
    public void populateDimensions(class_1937 world) {
        this.dimensions.clear();
        class_2378 dimensionTypeRegistry = class_310.method_1551().method_1562().method_29091().method_30530(class_2378.field_25095);
        for (class_5321<class_1937> vanillaWorldKey : this.vanillaWorlds) {
            class_5321 typeKey = class_5321.method_29179((class_5321)class_2378.field_25095, (class_2960)vanillaWorldKey.method_29177());
            class_2874 dimensionType = (class_2874)dimensionTypeRegistry.method_29107(typeKey);
            DimensionContainer dimensionContainer = new DimensionContainer(dimensionType, vanillaWorldKey.method_29177().method_12832(), vanillaWorldKey.method_29177());
            this.dimensions.add(dimensionContainer);
        }
        this.sort();
    }

    @Override
    public void enteredWorld(class_1937 world) {
        class_2960 resourceLocation = world.method_27983().method_29177();
        DimensionContainer dim = this.getDimensionContainerByResourceLocation(resourceLocation);
        if (dim == null) {
            dim = new DimensionContainer(world.method_8597(), resourceLocation.method_12832(), resourceLocation);
            this.dimensions.add(dim);
            this.sort();
        }
        if (dim.type == null) {
            try {
                dim.type = world.method_8597();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void sort() {
        final Collator collator = I18nUtils.getLocaleAwareCollator();
        Collections.sort(this.dimensions, new Comparator<DimensionContainer>(){

            @Override
            public int compare(DimensionContainer dim1, DimensionContainer dim2) {
                if (dim1.resourceLocation.equals((Object)class_1937.field_25179.method_29177())) {
                    return -1;
                }
                if (dim1.resourceLocation.equals((Object)class_1937.field_25180.method_29177()) && !dim2.resourceLocation.equals((Object)class_1937.field_25179.method_29177())) {
                    return -1;
                }
                if (dim1.resourceLocation.equals((Object)class_1937.field_25181.method_29177()) && !dim2.resourceLocation.equals((Object)class_1937.field_25179.method_29177()) && !dim2.resourceLocation.equals((Object)class_1937.field_25180.method_29177())) {
                    return -1;
                }
                return collator.compare(dim1.name, dim2.name);
            }
        });
    }

    @Override
    public DimensionContainer getDimensionContainerByWorld(class_1937 world) {
        class_2960 resourceLocation = world.method_27983().method_29177();
        DimensionContainer dim = this.getDimensionContainerByResourceLocation(resourceLocation);
        if (dim == null) {
            dim = new DimensionContainer(world.method_8597(), resourceLocation.method_12832(), resourceLocation);
            this.dimensions.add(dim);
            this.sort();
        }
        return dim;
    }

    @Override
    public DimensionContainer getDimensionContainerByIdentifier(String ident) {
        DimensionContainer dim = null;
        class_2960 resourceLocation = new class_2960(ident);
        dim = this.getDimensionContainerByResourceLocation(resourceLocation);
        if (dim == null) {
            dim = new DimensionContainer(null, resourceLocation.method_12832(), resourceLocation);
            this.dimensions.add(dim);
            this.sort();
        }
        return dim;
    }

    @Override
    public DimensionContainer getDimensionContainerByResourceLocation(class_2960 resourceLocation) {
        for (DimensionContainer dim : this.dimensions) {
            if (!resourceLocation.equals((Object)dim.resourceLocation)) continue;
            return dim;
        }
        return null;
    }
}

