/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila;

import java.util.List;
import java.util.function.BiFunction;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IDrawableText;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.config.WailaConfig;
import mcp.mobius.waila.gui.screen.HomeConfigScreen;
import mcp.mobius.waila.hud.ClientTickHandler;
import mcp.mobius.waila.hud.component.DrawableComponent;
import mcp.mobius.waila.impl.Impl;
import mcp.mobius.waila.util.CommonUtil;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_437;

public abstract class WailaClient {
    public static class_304 openConfig;
    public static class_304 showOverlay;
    public static class_304 toggleLiquid;
    public static class_304 showRecipeInput;
    public static class_304 showRecipeOutput;
    public static Runnable onShowRecipeInput;
    public static Runnable onShowRecipeOutput;
    protected static BiFunction<String, Integer, class_304> keyBindingBuilder;

    protected static void init() {
        openConfig = keyBindingBuilder.apply("config", 320);
        showOverlay = keyBindingBuilder.apply("show_overlay", 321);
        toggleLiquid = keyBindingBuilder.apply("toggle_liquid", 322);
        showRecipeInput = keyBindingBuilder.apply("show_recipe_input", 323);
        showRecipeOutput = keyBindingBuilder.apply("show_recipe_output", 324);
    }

    protected static void onJoinServer() {
        if (!Waila.packet.isServerAvailable()) {
            CommonUtil.LOGGER.warn("WTHIT is not found on the server, all syncable config will reset to their default value.");
            PluginConfig.INSTANCE.getSyncableConfigs().forEach(config -> config.setValue(config.getDefaultValue()));
        }
    }

    protected static void onClientTick() {
        class_310 client = class_310.method_1551();
        WailaConfig config = Waila.config.get();
        ClientTickHandler.tick();
        while (openConfig.method_1436()) {
            client.method_1507((class_437)new HomeConfigScreen(null));
        }
        while (showOverlay.method_1436()) {
            if (config.getGeneral().getDisplayMode() != IWailaConfig.General.DisplayMode.TOGGLE) continue;
            config.getGeneral().setDisplayTooltip(!config.getGeneral().isDisplayTooltip());
        }
        while (toggleLiquid.method_1436()) {
            PluginConfig.INSTANCE.set(WailaConstants.CONFIG_SHOW_FLUID, PluginConfig.INSTANCE.getBoolean(WailaConstants.CONFIG_SHOW_FLUID));
        }
        while (showRecipeInput.method_1436() && onShowRecipeInput != null) {
            onShowRecipeInput.run();
        }
        while (showRecipeOutput.method_1436() && onShowRecipeOutput != null) {
            onShowRecipeOutput.run();
        }
    }

    protected static void onItemTooltip(class_1799 stack, List<class_2561> tooltip) {
        if (PluginConfig.INSTANCE.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            tooltip.add((class_2561)new class_2585(IWailaConfig.get().getFormatting().formatModName(IModInfo.get(stack).getName())));
        }
    }

    static {
        Impl.reg(IDrawableText.class, DrawableComponent::new);
    }
}

