/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.hud;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.config.WailaConfig;
import mcp.mobius.waila.hud.component.DrawableComponent;
import mcp.mobius.waila.hud.component.PairComponent;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.class_1041;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class TooltipRenderer {
    private static final List<class_2561> LINES = new ObjectArrayList();
    private static final Object2IntOpenHashMap<class_2561> LINE_HEIGHT = new Object2IntOpenHashMap();
    private static final Supplier<Rectangle> RENDER_RECT = Suppliers.memoize(Rectangle::new);
    private static final Supplier<Rectangle> RECT = Suppliers.memoize(Rectangle::new);
    private static final String COLON = ": ";
    public static Consumer<List<class_2561>> onCreate;
    public static Function<Rectangle, Rectangle> onPreRender;
    public static Consumer<Rectangle> onPostRender;
    static boolean shouldRender;
    private static class_1799 stack;
    private static int topOffset;
    private static int colonOffset;
    private static int colonWidth;
    private static boolean started;

    public static void beginBuild() {
        LINES.clear();
        LINE_HEIGHT.clear();
        stack = class_1799.field_8037;
        topOffset = 0;
        colonOffset = 0;
        colonWidth = class_310.method_1551().field_1772.method_1727(COLON);
        started = true;
    }

    public static void addLines(List<class_2561> lines) {
        lines.forEach(TooltipRenderer::addLine);
    }

    public static void addLine(class_2561 line) {
        Preconditions.checkState((boolean)started);
        LINES.add(line);
        class_2561 class_25612 = line;
        if (class_25612 instanceof PairComponent) {
            PairComponent pair = (PairComponent)class_25612;
            colonOffset = Math.max(colonOffset, class_310.method_1551().field_1772.method_27525((class_5348)pair.key));
        }
    }

    public static class_1799 getStack() {
        return stack;
    }

    public static void setStack(class_1799 stack) {
        Preconditions.checkState((boolean)started);
        TooltipRenderer.stack = PluginConfig.INSTANCE.getBoolean(WailaConstants.CONFIG_SHOW_ITEM) ? stack : class_1799.field_8037;
    }

    public static void endBuild() {
        Preconditions.checkState((boolean)started);
        onCreate.accept(LINES);
        class_310 client = class_310.method_1551();
        class_1041 window = client.method_22683();
        float scale = Waila.config.get().getOverlay().getScale();
        WailaConfig.Overlay.Position pos = Waila.config.get().getOverlay().getPosition();
        int w = 0;
        int h = 0;
        for (class_2561 line : LINES) {
            int lineH;
            int lineW;
            if (line instanceof DrawableComponent) {
                Dimension size = ((DrawableComponent)line).getSize();
                lineW = size.width;
                lineH = size.height;
            } else {
                int n;
                class_2561 class_25612 = line;
                if (class_25612 instanceof PairComponent) {
                    PairComponent pair = (PairComponent)class_25612;
                    n = colonOffset + colonWidth + client.field_1772.method_27525((class_5348)pair.value);
                } else {
                    n = client.field_1772.method_27525((class_5348)line);
                }
                lineW = n;
                Objects.requireNonNull(client.field_1772);
                lineH = 9 + 1;
            }
            w = Math.max(w, lineW);
            h += lineH;
            LINE_HEIGHT.put((Object)line, lineH);
        }
        topOffset = 0;
        if (!stack.method_7960()) {
            if (h < 16) {
                topOffset = (16 - h) / 2;
            }
            w = Math.max(w, 16) + 20;
            h = Math.max(h, 16);
        }
        w += 10;
        h += 8;
        int windowW = (int)((float)window.method_4486() / scale);
        int windowH = (int)((float)window.method_4502() / scale);
        IWailaConfig.Overlay.Position.Align.X anchorX = pos.getAnchor().getX();
        IWailaConfig.Overlay.Position.Align.Y anchorY = pos.getAnchor().getY();
        IWailaConfig.Overlay.Position.Align.X alignX = pos.getAlign().getX();
        IWailaConfig.Overlay.Position.Align.Y alignY = pos.getAlign().getY();
        double x = (double)windowW * anchorX.multiplier - (double)w * alignX.multiplier + (double)pos.getX();
        double y = (double)windowH * anchorY.multiplier - (double)h * alignY.multiplier + (double)pos.getY();
        if (!pos.isBossBarsOverlap() && anchorX == IWailaConfig.Overlay.Position.Align.X.CENTER && anchorY == IWailaConfig.Overlay.Position.Align.Y.TOP) {
            y += (double)Math.min(client.field_1705.method_1740().field_2060.size() * 19, window.method_4502() / 3 + 2);
        }
        RECT.get().setRect(x, y, w, h);
        started = false;
    }

    public static void render(class_4587 matrices, float delta) {
        if (!shouldRender) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_3695 profiler = client.method_16011();
        WailaConfig config = Waila.config.get();
        profiler.method_15396("Waila Overlay");
        RenderSystem.getModelViewStack().method_22903();
        float scale = config.getOverlay().getScale();
        RenderSystem.getModelViewStack().method_22905(scale, scale, 1.0f);
        DisplayUtil.enable2DRender();
        Rectangle rect = RENDER_RECT.get();
        rect.setRect(RECT.get());
        rect = onPreRender.apply(rect);
        if (rect == null) {
            RenderSystem.enableDepthTest();
            RenderSystem.getModelViewStack().method_22909();
            profiler.method_15407();
            return;
        }
        int x = rect.x;
        int y = rect.y;
        int w = rect.width;
        int h = rect.height;
        WailaConfig.Overlay.Color color = config.getOverlay().getColor();
        int bg = color.getBackgroundColor();
        int gradStart = color.getGradientStart();
        int gradEnd = color.getGradientEnd();
        matrices.method_22903();
        matrices.method_22905(scale, scale, 1.0f);
        DisplayUtil.drawGradientRect(matrices, x + 1, y, w - 1, 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + h, w - 1, 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + 1, w - 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x, y + 1, 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + w, y + 1, 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + 2, 1, h - 3, gradStart, gradEnd);
        DisplayUtil.drawGradientRect(matrices, x + w - 1, y + 2, 1, h - 3, gradStart, gradEnd);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + 1, w - 1, 1, gradStart, gradStart);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + h - 1, w - 1, 1, gradEnd, gradEnd);
        RenderSystem.enableBlend();
        int textX = x + (stack.method_7960() ? 6 : 26);
        int textY = y + 6 + topOffset;
        int fontColor = color.getFontColor();
        for (class_2561 line : LINES) {
            class_2561 class_25612 = line;
            if (class_25612 instanceof DrawableComponent) {
                DrawableComponent drawable = (DrawableComponent)class_25612;
                drawable.render(matrices, textX, textY, delta);
            } else {
                class_25612 = line;
                if (class_25612 instanceof PairComponent) {
                    PairComponent pair = (PairComponent)class_25612;
                    client.field_1772.method_30881(matrices, pair.key, (float)textX, (float)textY, fontColor);
                    client.field_1772.method_1720(matrices, COLON, (float)(textX + colonOffset), (float)textY, fontColor);
                    client.field_1772.method_30881(matrices, pair.value, (float)(textX + colonOffset + colonWidth), (float)textY, fontColor);
                } else {
                    client.field_1772.method_30881(matrices, line, (float)textX, (float)textY, color.getFontColor());
                }
            }
            textY += LINE_HEIGHT.getInt((Object)line);
        }
        RenderSystem.disableBlend();
        matrices.method_22909();
        onPostRender.accept(rect);
        if (!stack.method_7960()) {
            DisplayUtil.renderStack(x + 5, y + h / 2 - 8, stack, "");
        }
        RenderSystem.enableDepthTest();
        RenderSystem.getModelViewStack().method_22909();
        RenderSystem.applyModelViewMatrix();
        class_310.method_1551().method_16011().method_15407();
    }

    static {
        shouldRender = false;
        stack = class_1799.field_8037;
        started = false;
    }
}

