/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import com.google.gson.Gson;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.config.BlacklistConfig;
import mcp.mobius.waila.config.ConfigEntry;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.data.DataAccessor;
import mcp.mobius.waila.debug.DumpGenerator;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.CommonUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;

public class PacketExecutor {
    private static final Gson GSON = new Gson();

    public static void generateClientDump() {
        Path path = CommonUtil.gameDir.resolve(".waila/WailaClientDump.md");
        if (DumpGenerator.generate(path)) {
            class_310.method_1551().field_1724.method_7353((class_2561)new class_2588("command.waila.client_dump_success", new Object[]{path}), false);
        }
    }

    public static void receiveData(class_2487 tag) {
        DataAccessor.INSTANCE.setServerData(tag);
    }

    public static void sendConfig(Map<class_2960, Object> map) {
        for (ConfigEntry<Object> config : PluginConfig.INSTANCE.getSyncableConfigs()) {
            Object object;
            class_2960 id = config.getId();
            Object defaultValue = config.getDefaultValue();
            Object object2 = defaultValue;
            if (object2 instanceof Enum) {
                Enum e = (Enum)object2;
                object = Enum.valueOf(e.getDeclaringClass(), (String)map.getOrDefault(id, e.name()));
            } else {
                object = map.getOrDefault(id, defaultValue);
            }
            Object syncedValue = object;
            config.setValue(syncedValue);
        }
        CommonUtil.LOGGER.info("Received config from the server: {}", (Object)GSON.toJson(map));
    }

    public static void sendBlacklist(int[][] rawIds) {
        BlacklistConfig blacklist = Waila.blacklistConfig.get();
        PacketExecutor.setBlackList(rawIds[0], blacklist.blocks, class_2378.field_11146);
        PacketExecutor.setBlackList(rawIds[1], blacklist.blockEntityTypes, class_2378.field_11137);
        PacketExecutor.setBlackList(rawIds[2], blacklist.entityTypes, class_2378.field_11145);
    }

    public static void requestEntity(class_3222 player, int entityId, Consumer<class_2487> consumer) {
        Registrar registrar = Registrar.INSTANCE;
        class_1937 world = player.field_6002;
        class_1297 entity = world.method_8469(entityId);
        if (entity == null) {
            return;
        }
        class_2487 tag = new class_2487();
        registrar.entityData.get(entity).forEach(provider -> provider.appendServerData(tag, player, world, entity));
        tag.method_10569("WailaEntityID", entity.method_5628());
        consumer.accept(tag);
    }

    public static void requestBlockEntity(class_3222 player, class_2338 pos, Consumer<class_2487> consumer) {
        Registrar registrar = Registrar.INSTANCE;
        class_1937 world = player.field_6002;
        if (!world.method_22340(pos)) {
            return;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity == null) {
            return;
        }
        class_2680 state = world.method_8320(pos);
        class_2487 tag = new class_2487();
        registrar.blockData.get(blockEntity).forEach(provider -> provider.appendServerData(tag, player, world, blockEntity));
        registrar.blockData.get(state.method_26204()).forEach(provider -> provider.appendServerData(tag, player, world, blockEntity));
        tag.method_10569("x", pos.method_10263());
        tag.method_10569("y", pos.method_10264());
        tag.method_10569("z", pos.method_10260());
        tag.method_10582("id", class_2378.field_11137.method_10221((Object)blockEntity.method_11017()).toString());
        consumer.accept(tag);
    }

    private static <T> void setBlackList(int[] ids, Set<T> set, class_2378<T> registry) {
        for (int id : ids) {
            set.add(registry.method_10200(id));
        }
    }
}

