/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.registry;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class Register<T> {
    private final Map<Class<?>, List<Entry<T>>> map = new Object2ObjectOpenHashMap();
    private final Map<Class<?>, List<T>> cache = new Object2ObjectOpenHashMap();
    private final List<Entry<?>> sorter = new ObjectArrayList();
    private final int order;

    private Register(int order) {
        this.order = order;
    }

    public static <T> Register<T> create() {
        return new Register<T>(1);
    }

    public static <T> Register<T> createReversed() {
        return new Register<T>(-1);
    }

    public void add(Class<?> key, T value, int priority) {
        this.map.computeIfAbsent(key, k -> new ObjectArrayList()).add(new Entry<T>(value, priority));
    }

    public List<T> get(Object obj) {
        if (obj == null) {
            return ObjectLists.emptyList();
        }
        Class<?> clazz = obj.getClass();
        if (clazz == Object.class) {
            return ObjectLists.emptyList();
        }
        if (this.cache.containsKey(clazz)) {
            return this.cache.get(clazz);
        }
        this.sorter.clear();
        this.map.forEach((k, v) -> {
            if (k.isInstance(obj)) {
                this.sorter.addAll((Collection<Entry<?>>)v);
            }
        });
        this.sorter.sort(Comparator.comparingInt(e -> e.priority * this.order));
        ObjectArrayList list = new ObjectArrayList();
        for (Entry<?> entry : this.sorter) {
            list.add(entry.value);
        }
        if (list.isEmpty()) {
            list = ObjectLists.emptyList();
        }
        this.cache.put(clazz, (List<T>)list);
        return list;
    }

    public Map<Class<?>, List<Entry<T>>> getMap() {
        return this.map;
    }

    public record Entry<T>(T value, int priority) {
    }
}

