/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.scheduler.tasks;

import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.scheduler.tasks.TaskPasteSchematicSetblock;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.util.IntBoundingBox;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.class_1923;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class TaskPasteSchematicSetblockToMcfunction
extends TaskPasteSchematicSetblock {
    protected final String fileNameBase;
    protected BufferedWriter writer;
    protected int fileIndex = 1;
    protected int commandsInCurrentFile;

    public TaskPasteSchematicSetblockToMcfunction(SchematicPlacement placement, boolean changedBlocksOnly) {
        super(placement, changedBlocksOnly);
        String date = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date(System.currentTimeMillis()));
        this.fileNameBase = "paste_commands_" + date + "_";
        this.openNextOutputFile();
    }

    @Override
    protected boolean processBox(class_1923 pos, IntBoundingBox box, WorldSchematic worldSchematic, class_638 worldClient, class_746 player) {
        if (this.commandsInCurrentFile > 64000) {
            this.openNextOutputFile();
            this.commandsInCurrentFile = 0;
        }
        return super.processBox(pos, box, worldSchematic, worldClient, player);
    }

    @Override
    protected void sendCommandToServer(String command, class_746 player) {
        if (this.writer != null) {
            try {
                this.writer.write(command);
                this.writer.newLine();
                ++this.commandsInCurrentFile;
            }
            catch (IOException e) {
                this.finished = true;
            }
        }
    }

    @Override
    public void stop() {
        this.closeCurrentFile();
        super.stop();
    }

    protected void openNextOutputFile() {
        this.closeCurrentFile();
        try {
            String fileName = this.fileNameBase + String.format("%02d", this.fileIndex) + ".mcfunction";
            File file = new File(DataManager.getCurrentConfigDirectory(), fileName);
            this.writer = new BufferedWriter(new FileWriter(file));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ++this.fileIndex;
    }

    protected void closeCurrentFile() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

