/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;

public class EntityUtils {
    public static final Predicate<class_1297> NOT_PLAYER = entity -> !(entity instanceof class_1657);

    public static boolean isCreativeMode(class_1657 player) {
        return player.method_31549().field_7477;
    }

    public static boolean hasToolItem(class_1309 entity) {
        class_1799 toolItem = DataManager.getToolItem();
        if (toolItem.method_7960()) {
            return entity.method_6047().method_7960();
        }
        return EntityUtils.isHoldingItem(entity, toolItem);
    }

    public static boolean isHoldingItem(class_1309 entity, class_1799 stackReference) {
        return !EntityUtils.getHeldItemOfType(entity, stackReference).method_7960();
    }

    public static class_1799 getHeldItemOfType(class_1309 entity, class_1799 stackReference) {
        class_1799 stack = entity.method_6047();
        if (!stack.method_7960() && EntityUtils.areStacksEqualIgnoreDurability(stack, stackReference)) {
            return stack;
        }
        stack = entity.method_6079();
        if (!stack.method_7960() && EntityUtils.areStacksEqualIgnoreDurability(stack, stackReference)) {
            return stack;
        }
        return class_1799.field_8037;
    }

    @Nullable
    public static class_1268 getUsedHandForItem(class_1657 player, class_1799 stack) {
        class_1268 hand = null;
        if (InventoryUtils.areStacksEqual((class_1799)player.method_6047(), (class_1799)stack)) {
            hand = class_1268.field_5808;
        } else if (player.method_6047().method_7960() && InventoryUtils.areStacksEqual((class_1799)player.method_6079(), (class_1799)stack)) {
            hand = class_1268.field_5810;
        }
        return hand;
    }

    public static boolean areStacksEqualIgnoreDurability(class_1799 stack1, class_1799 stack2) {
        return class_1799.method_7984((class_1799)stack1, (class_1799)stack2) && class_1799.method_7975((class_1799)stack1, (class_1799)stack2);
    }

    public static class_2350 getHorizontalLookingDirection(class_1297 entity) {
        return class_2350.method_10150((double)entity.method_36454());
    }

    public static class_2350 getVerticalLookingDirection(class_1297 entity) {
        return entity.method_36455() > 0.0f ? class_2350.field_11033 : class_2350.field_11036;
    }

    public static class_2350 getClosestLookingDirection(class_1297 entity) {
        if (entity.method_36455() > 60.0f) {
            return class_2350.field_11033;
        }
        if (-entity.method_36455() > 60.0f) {
            return class_2350.field_11036;
        }
        return EntityUtils.getHorizontalLookingDirection(entity);
    }

    @Nullable
    public static <T extends class_1297> T findEntityByUUID(List<T> list, UUID uuid) {
        if (uuid == null) {
            return null;
        }
        for (class_1297 entity : list) {
            if (!entity.method_5667().equals(uuid)) continue;
            return (T)entity;
        }
        return null;
    }

    @Nullable
    public static String getEntityId(class_1297 entity) {
        class_1299 entitytype = entity.method_5864();
        class_2960 resourcelocation = class_1299.method_5890((class_1299)entitytype);
        return entitytype.method_5893() && resourcelocation != null ? resourcelocation.toString() : null;
    }

    @Nullable
    private static class_1297 createEntityFromNBTSingle(class_2487 nbt, class_1937 world) {
        try {
            Optional optional = class_1299.method_5892((class_2487)nbt, (class_1937)world);
            if (optional.isPresent()) {
                class_1297 entity = (class_1297)optional.get();
                entity.method_5826(UUID.randomUUID());
                return entity;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public static class_1297 createEntityAndPassengersFromNBT(class_2487 nbt, class_1937 world) {
        class_1297 entity = EntityUtils.createEntityFromNBTSingle(nbt, world);
        if (entity == null) {
            return null;
        }
        if (nbt.method_10573("Passengers", 9)) {
            class_2499 taglist = nbt.method_10554("Passengers", 10);
            for (int i = 0; i < taglist.size(); ++i) {
                class_1297 passenger = EntityUtils.createEntityAndPassengersFromNBT(taglist.method_10602(i), world);
                if (passenger == null) continue;
                passenger.method_5873(entity, true);
            }
        }
        return entity;
    }

    public static void spawnEntityAndPassengersInWorld(class_1297 entity, class_1937 world) {
        if (world.method_8649(entity) && entity.method_5782()) {
            for (class_1297 passenger : entity.method_5685()) {
                passenger.method_5808(entity.method_23317(), entity.method_23318() + entity.method_5621() + passenger.method_5678(), entity.method_23321(), passenger.method_36454(), passenger.method_36455());
                EntityUtils.setEntityRotations(passenger, passenger.method_36454(), passenger.method_36455());
                EntityUtils.spawnEntityAndPassengersInWorld(passenger, world);
            }
        }
    }

    public static void setEntityRotations(class_1297 entity, float yaw, float pitch) {
        entity.method_36456(yaw);
        entity.field_5982 = yaw;
        entity.method_36457(pitch);
        entity.field_6004 = pitch;
        if (entity instanceof class_1309) {
            class_1309 livingBase = (class_1309)entity;
            livingBase.field_6241 = yaw;
            livingBase.field_6283 = yaw;
            livingBase.field_6259 = yaw;
            livingBase.field_6220 = yaw;
        }
    }

    public static List<class_1297> getEntitiesWithinSubRegion(class_1937 world, class_2338 origin, class_2338 regionPos, class_2338 regionSize, SchematicPlacement schematicPlacement, SubRegionPlacement placement) {
        class_2338 regionPosRelTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        class_2338 posEndAbs = PositionUtils.getTransformedPlacementPosition(regionSize.method_10069(-1, -1, -1), schematicPlacement, placement).method_10081((class_2382)regionPosRelTransformed).method_10081((class_2382)origin);
        class_2338 regionPosAbs = regionPosRelTransformed.method_10081((class_2382)origin);
        class_238 bb = PositionUtils.createEnclosingAABB(regionPosAbs, posEndAbs);
        return world.method_8333(null, bb, NOT_PLAYER);
    }

    public static boolean shouldPickBlock(class_1657 player) {
        return Configs.Generic.PICK_BLOCK_ENABLED.getBooleanValue() && (!Configs.Generic.TOOL_ITEM_ENABLED.getBooleanValue() || !EntityUtils.hasToolItem((class_1309)player)) && Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue();
    }
}

