/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Map;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.plugin.core.WailaCore;
import mcp.mobius.waila.registry.TooltipRegistrar;

public abstract class PluginLoader {
    public static final Map<String, IWailaPlugin> PLUGINS = new Object2ObjectOpenHashMap();

    protected abstract void gatherPlugins();

    public void initialize() {
        PLUGINS.clear();
        this.gatherPlugins();
        ArrayList sorted = Lists.newArrayList(PLUGINS.values());
        sorted.sort((o1, o2) -> {
            if (o1.getClass() == WailaCore.class) {
                return -1;
            }
            if (PluginLoader.isWailaClass(o1) && PluginLoader.isWailaClass(o2)) {
                return 0;
            }
            if (PluginLoader.isWailaClass(o1)) {
                return -1;
            }
            return o1.getClass().getCanonicalName().compareToIgnoreCase(o2.getClass().getCanonicalName());
        });
        sorted.forEach(p -> {
            Waila.LOGGER.info("Registering plugin at {}", (Object)p.getClass().getCanonicalName());
            p.register(TooltipRegistrar.INSTANCE);
        });
        TooltipRegistrar.INSTANCE.lock();
        PluginConfig.INSTANCE.reload();
    }

    protected static void createPlugin(String id, String initializer) {
        try {
            IWailaPlugin plugin = (IWailaPlugin)Class.forName(initializer).getConstructor(new Class[0]).newInstance(new Object[0]);
            PLUGINS.put(id, plugin);
            Waila.LOGGER.info("Discovered plugin {} at {}", (Object)id, (Object)plugin.getClass().getCanonicalName());
        }
        catch (Exception e) {
            Waila.LOGGER.error("Error creating instance of plugin {}", (Object)id);
        }
    }

    private static boolean isWailaClass(Object object) {
        return object.getClass().getCanonicalName().startsWith("mcp/mobius/waila");
    }
}

