/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.hud;

import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.data.DataAccessor;
import mcp.mobius.waila.debug.ExceptionHandler;
import mcp.mobius.waila.registry.TooltipRegistrar;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_638;

public class HudProviderHandler {
    public static void gatherBlock(DataAccessor accessor, List<class_2561> tooltip, TooltipPosition position) {
        TooltipRegistrar registrar = TooltipRegistrar.INSTANCE;
        class_2248 block = accessor.getBlock();
        class_2586 blockEntity = accessor.getBlockEntity();
        int rate = Waila.config.get().getGeneral().getRateLimit();
        if (blockEntity != null && accessor.isTimeElapsed(rate) && Waila.config.get().getGeneral().shouldDisplayTooltip()) {
            accessor.resetTimer();
            if (!registrar.blockData.get(block).isEmpty() || !registrar.blockData.get(blockEntity).isEmpty()) {
                Waila.packet.requestBlock(blockEntity);
            }
        }
        HudProviderHandler.handleBlock(accessor, tooltip, block, position);
        HudProviderHandler.handleBlock(accessor, tooltip, blockEntity, position);
    }

    private static void handleBlock(DataAccessor accessor, List<class_2561> tooltip, Object obj, TooltipPosition position) {
        TooltipRegistrar registrar = TooltipRegistrar.INSTANCE;
        List<IBlockComponentProvider> providers = registrar.blockComponent.get((Object)position).get(obj);
        for (IBlockComponentProvider provider : providers) {
            try {
                switch (position) {
                    case HEAD: {
                        provider.appendHead(tooltip, accessor, PluginConfig.INSTANCE);
                        break;
                    }
                    case BODY: {
                        provider.appendBody(tooltip, accessor, PluginConfig.INSTANCE);
                        break;
                    }
                    case TAIL: {
                        provider.appendTail(tooltip, accessor, PluginConfig.INSTANCE);
                    }
                }
            }
            catch (Throwable e) {
                ExceptionHandler.handleErr(e, provider.getClass().toString(), tooltip);
            }
        }
    }

    public static void gatherEntity(class_1297 entity, DataAccessor accessor, List<class_2561> tooltip, TooltipPosition position) {
        TooltipRegistrar registrar = TooltipRegistrar.INSTANCE;
        class_1297 trueEntity = accessor.getEntity();
        int rate = Waila.config.get().getGeneral().getRateLimit();
        if (trueEntity != null && accessor.isTimeElapsed(rate)) {
            accessor.resetTimer();
            if (!registrar.entityData.get(trueEntity).isEmpty()) {
                Waila.packet.requestEntity(trueEntity);
            }
        }
        List<IEntityComponentProvider> providers = registrar.entityComponent.get((Object)position).get(entity);
        for (IEntityComponentProvider provider : providers) {
            try {
                switch (position) {
                    case HEAD: {
                        provider.appendHead(tooltip, accessor, PluginConfig.INSTANCE);
                        break;
                    }
                    case BODY: {
                        provider.appendBody(tooltip, accessor, PluginConfig.INSTANCE);
                        break;
                    }
                    case TAIL: {
                        provider.appendTail(tooltip, accessor, PluginConfig.INSTANCE);
                    }
                }
            }
            catch (Throwable e) {
                ExceptionHandler.handleErr(e, provider.getClass().toString(), tooltip);
            }
        }
    }

    public static class_1799 getDisplayItem(class_239 target) {
        TooltipRegistrar registrar = TooltipRegistrar.INSTANCE;
        DataAccessor data = DataAccessor.INSTANCE;
        PluginConfig config = PluginConfig.INSTANCE;
        if (target.method_17783() == class_239.class_240.field_1331) {
            List<IEntityComponentProvider> providers = registrar.entityItem.get(data.getEntity());
            for (IEntityComponentProvider provider : providers) {
                class_1799 providerStack = provider.getDisplayItem(data, config);
                if (providerStack.method_7960()) continue;
                return providerStack;
            }
        } else {
            class_1799 class_17992;
            class_638 world = class_310.method_1551().field_1687;
            class_2338 pos = ((class_3965)target).method_17777();
            class_2680 state = data.getBlockState();
            if (state.method_26215()) {
                return class_1799.field_8037;
            }
            List<IBlockComponentProvider> providers = registrar.blockItem.get(state.method_26204());
            for (IBlockComponentProvider iBlockComponentProvider : providers) {
                class_1799 providerStack = iBlockComponentProvider.getDisplayItem(data, config);
                if (providerStack.method_7960()) continue;
                return providerStack;
            }
            class_2586 blockEntity = data.getBlockEntity();
            if (blockEntity != null) {
                providers = registrar.blockItem.get(blockEntity);
                for (IBlockComponentProvider provider : providers) {
                    class_1799 providerStack = provider.getDisplayItem(data, config);
                    if (providerStack.method_7960()) continue;
                    return providerStack;
                }
            }
            if (!(class_17992 = state.method_26204().method_9574((class_1922)world, pos, state)).method_7960()) {
                return class_17992;
            }
            if (state.method_26204().method_8389() != class_1802.field_8162) {
                return new class_1799((class_1935)state.method_26204());
            }
        }
        return class_1799.field_8037;
    }

    public static class_1297 getOverrideEntity(class_239 target) {
        if (target == null || target.method_17783() != class_239.class_240.field_1331) {
            return null;
        }
        TooltipRegistrar registrar = TooltipRegistrar.INSTANCE;
        class_1297 entity = ((class_3966)target).method_17782();
        List<IEntityComponentProvider> overrideProviders = registrar.entityOverride.get(entity);
        for (IEntityComponentProvider provider : overrideProviders) {
            class_1297 override = provider.getOverride(DataAccessor.INSTANCE, PluginConfig.INSTANCE);
            if (override == null) continue;
            return override;
        }
        return entity;
    }

    public static class_2680 getOverrideBlock(class_239 target) {
        TooltipRegistrar registrar = TooltipRegistrar.INSTANCE;
        class_638 world = class_310.method_1551().field_1687;
        class_2338 pos = ((class_3965)target).method_17777();
        class_2680 state = world.method_8320(pos);
        List<IBlockComponentProvider> providers = registrar.blockOverride.get(state.method_26204());
        for (IBlockComponentProvider provider : providers) {
            class_2680 override = provider.getOverride(DataAccessor.INSTANCE, PluginConfig.INSTANCE);
            if (override == null) continue;
            return override;
        }
        class_2586 blockEntity = world.method_8321(pos);
        providers = registrar.blockOverride.get(blockEntity);
        for (IBlockComponentProvider provider : providers) {
            class_2680 override = provider.getOverride(DataAccessor.INSTANCE, PluginConfig.INSTANCE);
            if (override == null) continue;
            return override;
        }
        return state;
    }
}

