/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import mcp.mobius.waila.debug.ExceptionHandler;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_757;

public final class DisplayUtil
extends class_332 {
    private static final DisplayUtil DH = new DisplayUtil();
    private static final String[] NUM_SUFFIXES = new String[]{"", "k", "m", "b", "t"};
    private static final int MAX_LENGTH = 4;
    private static final class_310 CLIENT = class_310.method_1551();
    private static final DecimalFormat SHORT_HAND = new DecimalFormat("##0E0");

    public static void bindTexture(class_2960 texture) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
    }

    public static void renderStack(int x, int y, class_1799 stack) {
        DisplayUtil.renderStack(x, y, stack, stack.method_7947() > 1 ? DisplayUtil.shortHandNumber(stack.method_7947()) : "");
    }

    public static void renderStack(int x, int y, class_1799 stack, String countText) {
        DisplayUtil.enable3DRender();
        try {
            CLIENT.method_1480().method_4010(stack, x, y);
            CLIENT.method_1480().method_4022(DisplayUtil.CLIENT.field_1772, stack, x, y, countText);
        }
        catch (Exception e) {
            String stackStr = stack != null ? stack.toString() : "NullStack";
            ExceptionHandler.handleErr(e, "renderStack | " + stackStr, null);
        }
        DisplayUtil.enable2DRender();
    }

    private static String shortHandNumber(Number number) {
        Object shorthand = SHORT_HAND.format(number);
        shorthand = ((String)shorthand).replaceAll("E[0-9]", NUM_SUFFIXES[Character.getNumericValue(((String)shorthand).charAt(((String)shorthand).length() - 1)) / 3]);
        while (((String)shorthand).length() > 4 || ((String)shorthand).matches("[0-9]+\\.[a-z]")) {
            shorthand = ((String)shorthand).substring(0, ((String)shorthand).length() - 2) + ((String)shorthand).substring(((String)shorthand).length() - 1);
        }
        return shorthand;
    }

    public static void enable3DRender() {
        class_308.method_24211();
        RenderSystem.enableDepthTest();
    }

    public static void enable2DRender() {
        class_308.method_24210();
        RenderSystem.disableDepthTest();
    }

    public static void drawGradientRect(class_4587 matrices, int x, int y, int w, int h, int startColor, int endColor) {
        DH.method_25296(matrices, x, y, x + w, y + h, startColor, endColor);
    }

    public static void drawTexturedModalRect(class_4587 matrices, int x, int y, int textureX, int textureY, int width, int height, int tw, int th) {
        DisplayUtil.method_25293((class_4587)matrices, (int)x, (int)y, (int)width, (int)height, (float)textureX, (float)textureY, (int)tw, (int)th, (int)256, (int)256);
    }
}

