/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.config;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import mcp.mobius.waila.config.Theme;
import net.minecraft.class_2960;

public class WailaConfig {
    private int configVersion = 0;
    private final General general = new General();
    private final Overlay overlay = new Overlay();
    private final Formatting formatting = new Formatting();

    public int getConfigVersion() {
        return this.configVersion;
    }

    public void setConfigVersion(int configVersion) {
        this.configVersion = configVersion;
    }

    public General getGeneral() {
        return this.general;
    }

    public Overlay getOverlay() {
        return this.overlay;
    }

    public Formatting getFormatting() {
        return this.formatting;
    }

    public static class General {
        private boolean displayTooltip = true;
        private boolean shiftForDetails = false;
        private DisplayMode displayMode = DisplayMode.TOGGLE;
        private boolean hideFromPlayerList = true;
        private boolean hideFromDebug = true;
        private boolean enableTextToSpeech = false;
        private int rateLimit = 250;
        private int maxHealthForRender = 40;
        private int maxHeartsPerLine = 10;

        public void setDisplayTooltip(boolean displayTooltip) {
            this.displayTooltip = displayTooltip;
        }

        public void setShiftForDetails(boolean shiftForDetails) {
            this.shiftForDetails = shiftForDetails;
        }

        public void setDisplayMode(DisplayMode displayMode) {
            this.displayMode = displayMode;
        }

        public void setHideFromPlayerList(boolean hideFromPlayerList) {
            this.hideFromPlayerList = hideFromPlayerList;
        }

        public void setHideFromDebug(boolean hideFromDebug) {
            this.hideFromDebug = hideFromDebug;
        }

        public void setEnableTextToSpeech(boolean enableTextToSpeech) {
            this.enableTextToSpeech = enableTextToSpeech;
        }

        public void setRateLimit(int rateLimit) {
            this.rateLimit = rateLimit;
        }

        public void setMaxHealthForRender(int maxHealthForRender) {
            this.maxHealthForRender = maxHealthForRender;
        }

        public void setMaxHeartsPerLine(int maxHeartsPerLine) {
            this.maxHeartsPerLine = maxHeartsPerLine;
        }

        public boolean shouldDisplayTooltip() {
            return this.displayTooltip;
        }

        public boolean shouldShiftForDetails() {
            return this.shiftForDetails;
        }

        public DisplayMode getDisplayMode() {
            return this.displayMode;
        }

        public boolean shouldHideFromPlayerList() {
            return this.hideFromPlayerList;
        }

        public boolean shouldHideFromDebug() {
            return this.hideFromDebug;
        }

        public boolean shouldEnableTextToSpeech() {
            return this.enableTextToSpeech;
        }

        public int getRateLimit() {
            this.rateLimit = Math.max(this.rateLimit, 250);
            return this.rateLimit;
        }

        public int getMaxHealthForRender() {
            return this.maxHealthForRender;
        }

        public int getMaxHeartsPerLine() {
            return this.maxHeartsPerLine;
        }

        public static enum DisplayMode {
            HOLD_KEY,
            TOGGLE;

        }
    }

    public static class Overlay {
        private final Position position = new Position();
        private float scale = 1.0f;
        private final Color color = new Color();

        public void setScale(float scale) {
            this.scale = scale;
        }

        public Position getPosition() {
            return this.position;
        }

        public float getScale() {
            return this.scale;
        }

        public Color getColor() {
            return this.color;
        }

        public static class Position {
            private int x = 0;
            private int y = 0;
            private X alignX = X.CENTER;
            private Y alignY = Y.TOP;
            private X anchorX = X.CENTER;
            private Y anchorY = Y.TOP;

            public void setX(int x) {
                this.x = x;
            }

            public void setY(int y) {
                this.y = y;
            }

            public void setAlignX(X alignX) {
                this.alignX = alignX;
            }

            public void setAlignY(Y alignY) {
                this.alignY = alignY;
            }

            public void setAnchorX(X anchorX) {
                this.anchorX = anchorX;
            }

            public void setAnchorY(Y anchorY) {
                this.anchorY = anchorY;
            }

            public int getX() {
                return this.x;
            }

            public int getY() {
                return this.y;
            }

            public X getAlignX() {
                return this.alignX;
            }

            public Y getAlignY() {
                return this.alignY;
            }

            public X getAnchorX() {
                return this.anchorX;
            }

            public Y getAnchorY() {
                return this.anchorY;
            }

            public static enum X {
                LEFT(0.0),
                CENTER(0.5),
                RIGHT(1.0);

                public final double multiplier;

                private X(double multiplier) {
                    this.multiplier = multiplier;
                }
            }

            public static enum Y {
                TOP(0.0),
                MIDDLE(0.5),
                BOTTOM(1.0);

                public final double multiplier;

                private Y(double multiplier) {
                    this.multiplier = multiplier;
                }
            }
        }

        public static class Color {
            private int alpha = 80;
            private Map<class_2960, Theme> themes = Maps.newHashMap();
            private class_2960 activeTheme = Theme.VANILLA.getId();

            public Color() {
                this.themes.put(Theme.VANILLA.getId(), Theme.VANILLA);
                this.themes.put(Theme.DARK.getId(), Theme.DARK);
            }

            public int getAlpha() {
                return this.alpha == 100 ? 255 : (this.alpha == 0 ? 0x1000000 : (int)((float)this.alpha / 100.0f * 256.0f) << 24);
            }

            public int getRawAlpha() {
                return this.alpha;
            }

            public Theme getTheme() {
                return this.themes.getOrDefault(this.activeTheme, Theme.VANILLA);
            }

            public Collection<Theme> getThemes() {
                return this.themes.values();
            }

            public void setAlpha(int alpha) {
                this.alpha = alpha;
            }

            public int getBackgroundColor() {
                return this.getAlpha() + this.getTheme().getBackgroundColor();
            }

            public int getGradientStart() {
                return this.getAlpha() + this.getTheme().getGradientStart();
            }

            public int getGradientEnd() {
                return this.getAlpha() + this.getTheme().getGradientEnd();
            }

            public int getFontColor() {
                return this.getTheme().getFontColor();
            }

            public void applyTheme(class_2960 id) {
                this.activeTheme = this.themes.containsKey(id) ? id : this.activeTheme;
            }

            public static class Adapter
            implements JsonSerializer<Color>,
            JsonDeserializer<Color> {
                public Color deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                    JsonObject json = element.getAsJsonObject();
                    Color color = new Color();
                    color.alpha = json.getAsJsonPrimitive("alpha").getAsInt();
                    color.activeTheme = new class_2960(json.getAsJsonPrimitive("activeTheme").getAsString());
                    color.themes = Maps.newHashMap();
                    json.getAsJsonArray("themes").forEach(e -> {
                        Theme theme = (Theme)context.deserialize(e, Theme.class);
                        color.themes.put(theme.getId(), theme);
                    });
                    return color;
                }

                public JsonElement serialize(Color src, Type typeOfSrc, JsonSerializationContext context) {
                    JsonObject json = new JsonObject();
                    json.addProperty("alpha", (Number)src.alpha);
                    json.add("themes", context.serialize(src.themes.values()));
                    json.addProperty("activeTheme", src.activeTheme.toString());
                    return json;
                }
            }
        }
    }

    public static class Formatting {
        private String modName = "\u00a79\u00a7o%s";
        private String blockName = "\u00a7f%s";
        private String fluidName = "\u00a7f%s";
        private String entityName = "\u00a7f%s";
        private String registryName = "\u00a78%s";

        public void setModName(String modName) {
            this.modName = modName;
        }

        public void setBlockName(String blockName) {
            this.blockName = blockName;
        }

        public void setFluidName(String fluidName) {
            this.fluidName = fluidName;
        }

        public void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        public void setRegistryName(String registryName) {
            this.registryName = registryName;
        }

        public String getModName() {
            return this.modName;
        }

        public String getBlockName() {
            return this.blockName;
        }

        public String getFluidName() {
            return this.fluidName;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public String getRegistryName() {
            return this.registryName;
        }
    }
}

