/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.registry;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltipRenderer;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.config.ConfigEntry;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.registry.TooltipRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_2586;
import net.minecraft.class_2960;

public enum TooltipRegistrar implements IRegistrar
{
    INSTANCE;

    public final TooltipRegistry<IBlockComponentProvider> blockOverride = new TooltipRegistry();
    public final TooltipRegistry<IBlockComponentProvider> blockItem = new TooltipRegistry();
    public final TooltipRegistry<IServerDataProvider<class_2586>> blockData = new TooltipRegistry();
    public final Map<TooltipPosition, TooltipRegistry<IBlockComponentProvider>> blockComponent = (Map)class_156.method_654(new EnumMap(TooltipPosition.class), map -> {
        for (TooltipPosition key : TooltipPosition.values()) {
            map.put(key, new TooltipRegistry());
        }
    });
    public final TooltipRegistry<IEntityComponentProvider> entityOverride = new TooltipRegistry();
    public final TooltipRegistry<IEntityComponentProvider> entityItem = new TooltipRegistry();
    public final TooltipRegistry<IServerDataProvider<class_1297>> entityData = new TooltipRegistry();
    public final Map<TooltipPosition, TooltipRegistry<IEntityComponentProvider>> entityComponent = (Map)class_156.method_654(new EnumMap(TooltipPosition.class), map -> {
        for (TooltipPosition key : TooltipPosition.values()) {
            map.put(key, new TooltipRegistry());
        }
    });
    public final Map<class_2960, ITooltipRenderer> renderer = new Object2ObjectOpenHashMap();
    private boolean locked = false;

    @Override
    public void addConfig(class_2960 key, boolean defaultValue) {
        if (Waila.clientSide) {
            this.assertLock();
            PluginConfig.INSTANCE.addConfig(new ConfigEntry(key, defaultValue, false));
        }
    }

    @Override
    public void addSyncedConfig(class_2960 key, boolean defaultValue) {
        this.assertLock();
        PluginConfig.INSTANCE.addConfig(new ConfigEntry(key, defaultValue, true));
    }

    @Override
    public <T> void addOverride(IBlockComponentProvider provider, Class<T> clazz, int priority) {
        if (Waila.clientSide) {
            this.assertLock();
            this.assertPriority(priority);
            this.blockOverride.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addDisplayItem(IBlockComponentProvider provider, Class<T> clazz, int priority) {
        if (Waila.clientSide) {
            this.assertLock();
            this.assertPriority(priority);
            this.blockItem.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addComponent(IBlockComponentProvider provider, TooltipPosition position, Class<T> clazz, int priority) {
        if (Waila.clientSide) {
            this.assertLock();
            this.assertPriority(priority);
            this.blockComponent.get((Object)position).add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addBlockData(IServerDataProvider<class_2586> provider, Class<T> clazz) {
        this.assertLock();
        this.blockData.add(clazz, provider, 0);
    }

    @Override
    public <T> void addOverride(IEntityComponentProvider provider, Class<T> clazz, int priority) {
        if (Waila.clientSide) {
            this.assertLock();
            this.assertPriority(priority);
            this.entityOverride.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addDisplayItem(IEntityComponentProvider provider, Class<T> clazz, int priority) {
        if (Waila.clientSide) {
            this.assertLock();
            this.assertPriority(priority);
            this.entityItem.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addComponent(IEntityComponentProvider provider, TooltipPosition position, Class<T> clazz, int priority) {
        if (Waila.clientSide) {
            this.assertLock();
            this.assertPriority(priority);
            this.entityComponent.get((Object)position).add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addEntityData(IServerDataProvider<class_1297> provider, Class<T> clazz) {
        this.assertLock();
        this.entityData.add(clazz, provider, 0);
    }

    @Override
    public void addRenderer(class_2960 id, ITooltipRenderer renderer) {
        if (Waila.clientSide) {
            this.renderer.put(id, renderer);
        }
    }

    public void lock() {
        this.locked = true;
    }

    private void assertLock() {
        Preconditions.checkState((!this.locked ? 1 : 0) != 0, (Object)"Tried to register new component after the registrar is locked");
    }

    private void assertPriority(int priority) {
        Preconditions.checkArgument((priority >= 0 ? 1 : 0) != 0, (Object)"Priority must be equals or more than 0");
    }
}

