// https://cadiboo.github.io/tutorials/1.14.4/forge/99.99-coremod/

function initializeCoreMod() {

    /*Class/Interface*/
    Opcodes = Java.type("org.objectweb.asm.Opcodes");
    /*Class*/
    ASMAPI = Java.type("net.minecraftforge.coremod.api.ASMAPI");

    /*Class*/
    InsnList = Java.type("org.objectweb.asm.tree.InsnList");
    /*Class*/
    LabelNode = Java.type("org.objectweb.asm.tree.LabelNode");

    /*Class*/
    FieldNode = Java.type("org.objectweb.asm.tree.FieldNode");
    /*Class*/
    MethodNode = Java.type("org.objectweb.asm.tree.MethodNode");

    /*Class*/
    AbstractInsnNode = Java.type("org.objectweb.asm.tree.AbstractInsnNode");
    /*Class*/
    InsnNode = Java.type("org.objectweb.asm.tree.InsnNode");
    /*Class*/
    VarInsnNode = Java.type("org.objectweb.asm.tree.VarInsnNode");
    /*Class*/
    FieldInsnNode = Java.type("org.objectweb.asm.tree.FieldInsnNode");
    /*Class*/
    MethodInsnNode = Java.type("org.objectweb.asm.tree.MethodInsnNode");
    /*Class*/
    JumpInsnNode = Java.type("org.objectweb.asm.tree.JumpInsnNode");
    /*Class*/
    TypeInsnNode = Java.type("org.objectweb.asm.tree.TypeInsnNode");

    var targetMethodName = ASMAPI.mapMethod("m_93028_");
    var targetClass = "net.minecraft.client.gui.Gui";
    var targetMethodSrg = "m_93028_";
    var targetMethodDesc = "(Lcom/mojang/blaze3d/vertex/PoseStack;)V";


    return {
        'Gui.renderEffects': {
            'target': {
                'type': 'METHOD',
                'class': targetClass,
                'methodName': targetMethodName,
                'methodDesc': targetMethodDesc
            },
            "transformer": function (methodNode) {
                var instList = new InsnList();

                instList.add(new LabelNode());
                instList.add(new FieldInsnNode(Opcodes.GETSTATIC, "journeymap/client/ui/UIManager", "INSTANCE", "Ljourneymap/client/ui/UIManager;"));
                instList.add(new MethodInsnNode(Opcodes.INVOKEVIRTUAL, "journeymap/client/ui/UIManager", "getMiniMap", "()Ljourneymap/client/ui/minimap/MiniMap;", false));
                instList.add(new MethodInsnNode(Opcodes.INVOKEVIRTUAL, "journeymap/client/ui/minimap/MiniMap", "getDisplayVars", "()Ljourneymap/client/ui/minimap/DisplayVars;", false));
                instList.add(new MethodInsnNode(Opcodes.INVOKEVIRTUAL, "journeymap/client/ui/minimap/DisplayVars", "getPotionEffectsLocation", "()I", false));
                instList.add(new VarInsnNode(Opcodes.ISTORE, 11));

                // we want to add it to the end of the method, find the 18th label and insert.
                var instructions = methodNode.instructions;
                var labels = 0;

                // var labelToInsert = hasOptifine(instructions) ? 18 : 17; // fix for optifine later
                var labelToInsert = 18;
                for (var i = 0; i < instructions.size(); ++i) {
                    // print(instructions.get(i) +" : "+instructions.get(i).getType() +" : "+ instructions.get(i).owner +" : "+ instructions.get(i).name+" : "+ instructions.get(i).desc)
                    if (AbstractInsnNode.LABEL === instructions.get(i).getType()) {
                        labels++;
                        // print(labels);
                        if (labels === labelToInsert) {
                            // instructions.insert(instructions.get(i), instList);
                            break;
                        }
                    }
                }

                return methodNode;
            }
        }
    }

    function hasOptifine(instructions) {

        for (var i = 0; i < instructions.size(); ++i) {
            var instructionOwner = instructions.get(i).owner;
            if ('net/optifine/reflect/Reflector' == instructionOwner) {
                // print('Found Optifine')
                return true;
            }
        }
        // print('Did not find Optifine')
        return false;
    }
    // L16
    // LINENUMBER 453 L16
    // ALOAD 8
    // INVOKEVIRTUAL net/minecraft/world/effect/MobEffectInstance.showIcon ()Z
    // IFEQ L17
    // L18
    // LINENUMBER 454 L18
    // ALOAD 0
    // GETFIELD net/minecraft/client/gui/Gui.screenWidth : I
    // ISTORE 11
    // L19
    // LINENUMBER 455 L19
    // ICONST_1
    // ISTORE 12
    // L20
}