/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.stacks;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.storage.AEKeyFilter;
import appeng.core.AELog;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public final class AEItemKey
extends AEKey {
    private final class_1792 item;
    @Nullable
    private final class_2487 tag;
    private final int hashCode;

    private AEItemKey(class_1792 item, @Nullable class_2487 tag) {
        this.item = item;
        this.tag = tag;
        this.hashCode = Objects.hash(item, tag);
    }

    @Nullable
    public static AEItemKey of(ItemVariant variant) {
        if (variant.isBlank()) {
            return null;
        }
        return AEItemKey.of((class_1935)variant.getItem(), variant.getNbt());
    }

    @Nullable
    public static AEItemKey of(class_1799 stack) {
        if (stack.method_7960()) {
            return null;
        }
        return AEItemKey.of((class_1935)stack.method_7909(), stack.method_7969());
    }

    public static boolean matches(AEKey what, class_1799 itemStack) {
        AEItemKey itemKey;
        return what instanceof AEItemKey && (itemKey = (AEItemKey)what).matches(itemStack);
    }

    public static boolean is(AEKey what) {
        return what instanceof AEItemKey;
    }

    public static AEKeyFilter filter() {
        return AEItemKey::is;
    }

    @Override
    public AEKeyType getType() {
        return AEKeyType.items();
    }

    @Override
    public AEItemKey dropSecondary() {
        return AEItemKey.of((class_1935)this.item, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AEItemKey aeItemKey = (AEItemKey)o;
        return this.hashCode == aeItemKey.hashCode && this.item == aeItemKey.item && Objects.equals(this.tag, aeItemKey.tag);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static AEItemKey of(class_1935 item) {
        return AEItemKey.of(item, null);
    }

    public static AEItemKey of(class_1935 item, @Nullable class_2487 tag) {
        return new AEItemKey(item.method_8389(), tag != null ? tag.method_10553() : null);
    }

    public boolean matches(class_1799 stack) {
        return !stack.method_7960() && stack.method_31574(this.item) && Objects.equals(stack.method_7969(), this.tag);
    }

    public class_1799 toStack() {
        return this.toStack(1);
    }

    public class_1799 toStack(int count) {
        if (count <= 0) {
            return class_1799.field_8037;
        }
        class_1799 result = new class_1799((class_1935)this.item);
        result.method_7980(this.copyTag());
        result.method_7939(count);
        return result;
    }

    @Nullable
    public class_2487 copyTag() {
        return this.tag != null ? this.tag.method_10553() : null;
    }

    public class_1792 getItem() {
        return this.item;
    }

    @Nullable
    public static AEItemKey fromTag(class_2487 tag) {
        try {
            class_1792 item = (class_1792)class_2378.field_11142.method_17966(new class_2960(tag.method_10558("id"))).orElseThrow(() -> new IllegalArgumentException("Unknown item id."));
            class_2487 extraTag = tag.method_10545("tag") ? tag.method_10562("tag") : null;
            return AEItemKey.of((class_1935)item, extraTag);
        }
        catch (Exception e) {
            AELog.debug("Tried to load an invalid item key from NBT: %s", tag, e);
            return null;
        }
    }

    @Override
    public class_2487 toTag() {
        class_2487 result = new class_2487();
        result.method_10582("id", class_2378.field_11142.method_10221((Object)this.item).toString());
        if (this.tag != null) {
            result.method_10566("tag", (class_2520)this.tag.method_10553());
        }
        return result;
    }

    @Override
    public Object getPrimaryKey() {
        return this.item;
    }

    @Override
    public int getFuzzySearchValue() {
        return this.tag == null ? 0 : this.tag.method_10550("Damage");
    }

    @Override
    public int getFuzzySearchMaxValue() {
        return this.item.method_7841();
    }

    @Override
    public String getModId() {
        return class_2378.field_11142.method_10221((Object)this.item).method_12836();
    }

    public ItemVariant toVariant() {
        return ItemVariant.of((class_1935)this.item, (class_2487)this.tag);
    }

    @Nullable
    public class_2487 getTag() {
        return this.tag;
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    @Override
    public class_1799 wrapForDisplayOrFilter() {
        return this.toStack();
    }

    @Override
    public class_1799 wrap(int amount) {
        return this.toStack(amount);
    }

    @Override
    public class_2561 getDisplayName() {
        return this.toStack().method_7964();
    }

    public boolean isDamaged() {
        return this.tag != null && this.tag.method_10550("Damage") > 0;
    }

    @Override
    public void writeToPacket(class_2540 data) {
        data.method_10804(class_1792.method_7880((class_1792)this.item));
        class_2487 compoundTag = null;
        if (this.item.method_7846() || this.item.method_7887()) {
            compoundTag = this.tag;
        }
        data.method_10794(compoundTag);
    }

    public static AEItemKey fromPacket(class_2540 data) {
        int i = data.method_10816();
        class_1792 item = class_1792.method_7875((int)i);
        class_2487 tag = data.method_10798();
        return new AEItemKey(item, tag);
    }

    public String toString() {
        class_2960 id = class_2378.field_11142.method_10221((Object)this.item);
        String idString = id != class_2378.field_11142.method_10137() ? id.toString() : this.item.getClass().getName() + "(unregistered)";
        return this.tag == null ? idString : idString + " (+tag)";
    }
}

