/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.stacks;

import appeng.api.stacks.AEFluidKeys;
import appeng.api.stacks.AEItemKeys;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyTypesInternal;
import appeng.api.stacks.AmountFormat;
import appeng.api.storage.AEKeyFilter;
import appeng.util.ReadableNumberConverter;
import com.google.common.base.Preconditions;
import java.text.NumberFormat;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public abstract class AEKeyType {
    private final class_2960 id;
    private final Class<? extends AEKey> keyClass;
    private final AEKeyFilter filter;
    private final class_2561 description;

    public AEKeyType(class_2960 id, Class<? extends AEKey> keyClass, class_2561 description) {
        Preconditions.checkArgument((!keyClass.equals(AEKey.class) ? 1 : 0) != 0, (Object)"Can't register a key type for AEKey itself");
        this.id = id;
        this.keyClass = keyClass;
        this.filter = what -> what.getType() == this;
        this.description = description;
    }

    public static AEKeyType items() {
        return AEItemKeys.INSTANCE;
    }

    @Nullable
    public static AEKeyType fromRawId(int id) {
        Preconditions.checkArgument((id >= 0 && id <= 127 ? 1 : 0) != 0, (String)"id out of range: %d", (int)id);
        return (AEKeyType)AEKeyTypesInternal.getRegistry().method_10200(id);
    }

    public static AEKeyType fluids() {
        return AEFluidKeys.INSTANCE;
    }

    public final class_2960 getId() {
        return this.id;
    }

    public final Class<? extends AEKey> getKeyClass() {
        return this.keyClass;
    }

    public final byte getRawId() {
        int id = AEKeyTypesInternal.getRegistry().method_10206((Object)this);
        if (id < 0 || id > 127) {
            throw new IllegalStateException("Key type " + this + " has an invalid numeric id: " + id);
        }
        return (byte)id;
    }

    public int getAmountPerOperation() {
        return 1;
    }

    public int getAmountPerByte() {
        return 8;
    }

    @Nullable
    public abstract AEKey readFromPacket(class_2540 var1);

    @Nullable
    public abstract AEKey loadKeyFromTag(class_2487 var1);

    @Nullable
    public final AEKey tryCast(AEKey key) {
        return this.keyClass.isInstance(key) ? this.keyClass.cast(key) : null;
    }

    public final boolean contains(AEKey key) {
        return this.keyClass.isInstance(key);
    }

    public boolean supportsFuzzyRangeSearch() {
        return false;
    }

    public final AEKeyFilter filter() {
        return this.filter;
    }

    public String toString() {
        return this.id.toString();
    }

    public class_2561 getDescription() {
        return this.description;
    }

    @Nullable
    public String getUnitSymbol() {
        return null;
    }

    public int getAmountPerUnit() {
        return 1;
    }

    public final String formatAmount(long amount, AmountFormat format) {
        return switch (format) {
            default -> throw new IncompatibleClassChangeError();
            case AmountFormat.FULL -> this.formatFullAmount(amount);
            case AmountFormat.PREVIEW_REGULAR -> this.formatShortAmount(amount, 4);
            case AmountFormat.PREVIEW_LARGE_FONT -> this.formatShortAmount(amount, 3);
        };
    }

    private String formatFullAmount(long amount) {
        StringBuilder result = new StringBuilder();
        if (this.getAmountPerUnit() > 1) {
            double units = (double)amount / (double)this.getAmountPerUnit();
            result.append(NumberFormat.getNumberInstance().format(units));
        } else {
            result.append(NumberFormat.getNumberInstance().format(amount));
        }
        String unit = this.getUnitSymbol();
        if (unit != null) {
            result.append(' ').append(unit);
        }
        return result.toString();
    }

    private String formatShortAmount(long amount, int maxWidth) {
        if (this.getAmountPerUnit() > 1) {
            double units = (double)amount / (double)this.getAmountPerUnit();
            return ReadableNumberConverter.format(units, maxWidth);
        }
        return ReadableNumberConverter.format(amount, maxWidth);
    }
}

