/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.stacks;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.items.misc.WrappedGenericStack;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;

public record GenericStack(AEKey what, long amount) {
    public GenericStack {
        Objects.requireNonNull(what, "what");
    }

    @Nullable
    public static GenericStack readBuffer(class_2540 buffer) {
        if (!buffer.readBoolean()) {
            return null;
        }
        AEKey what = AEKey.readKey(buffer);
        if (what == null) {
            return null;
        }
        return new GenericStack(what, buffer.method_10792());
    }

    public static void writeBuffer(@Nullable GenericStack stack, class_2540 buffer) {
        if (stack == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            AEKey.writeKey(buffer, stack.what);
            buffer.method_10791(stack.amount);
        }
    }

    @Nullable
    public static GenericStack readTag(class_2487 tag) {
        if (tag.method_33133()) {
            return null;
        }
        AEKey key = AEKey.fromTagGeneric(tag);
        if (key == null) {
            return null;
        }
        return new GenericStack(key, tag.method_10537("#"));
    }

    public static class_2487 writeTag(@Nullable GenericStack stack) {
        if (stack == null) {
            return new class_2487();
        }
        class_2487 tag = stack.what.toTagGeneric();
        tag.method_10544("#", stack.amount);
        return tag;
    }

    @Nullable
    public static GenericStack fromItemStack(class_1799 stack) {
        GenericStack genericStack = GenericStack.unwrapItemStack(stack);
        if (genericStack != null) {
            return genericStack;
        }
        AEItemKey key = AEItemKey.of(stack);
        if (key == null) {
            return null;
        }
        return new GenericStack(key, stack.method_7947());
    }

    public static long getStackSizeOrZero(@Nullable GenericStack stack) {
        return stack == null ? 0L : stack.amount;
    }

    public static class_1799 wrapInItemStack(@Nullable GenericStack stack) {
        if (stack != null) {
            return GenericStack.wrapInItemStack(stack.what(), stack.amount());
        }
        return class_1799.field_8037;
    }

    public static class_1799 wrapInItemStack(AEKey what, long amount) {
        return WrappedGenericStack.wrap(what, amount);
    }

    public static boolean isWrapped(class_1799 stack) {
        return stack.method_7909() instanceof WrappedGenericStack;
    }

    public static GenericStack unwrapItemStack(class_1799 stack) {
        WrappedGenericStack item;
        AEKey what;
        class_1792 class_17922;
        if (!stack.method_7960() && (class_17922 = stack.method_7909()) instanceof WrappedGenericStack && (what = (item = (WrappedGenericStack)class_17922).unwrapWhat(stack)) != null) {
            long amount = item.unwrapAmount(stack);
            return new GenericStack(what, amount);
        }
        return null;
    }

    public static GenericStack sum(GenericStack left, GenericStack right) {
        if (!left.what.equals(right.what)) {
            throw new IllegalArgumentException("Cannot sum generic stacks of " + left.what + " and " + right.what);
        }
        return new GenericStack(left.what, left.amount + right.amount);
    }
}

