/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.misc;

import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.features.IPlayerRegistry;
import appeng.api.features.Locatables;
import appeng.api.implementations.blockentities.IColorableBlockEntity;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.events.GridSecurityChange;
import appeng.api.networking.security.ISecurityProvider;
import appeng.api.stacks.AEItemKey;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.MEStorage;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.IConfigManager;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.items.tools.BiometricCardItem;
import appeng.me.storage.SecurityStationInventory;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.implementations.SecurityStationMenu;
import appeng.menu.locator.MenuLocators;
import appeng.util.ConfigManager;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import com.mojang.authlib.GameProfile;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class SecurityStationBlockEntity
extends AENetworkBlockEntity
implements ITerminalHost,
InternalInventoryHost,
ISecurityProvider,
IColorableBlockEntity {
    private static int difference = 0;
    private final AppEngInternalInventory configSlot = new AppEngInternalInventory(this, 1);
    private final IConfigManager cm = new ConfigManager();
    private final SecurityStationInventory inventory = new SecurityStationInventory(this);
    private long securityKey;
    private AEColor paintedColor = AEColor.TRANSPARENT;
    private boolean isActive = false;

    public SecurityStationBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setFlags(GridFlags.REQUIRE_CHANNEL).setIdlePowerUsage(2.0).addService(ISecurityProvider.class, this);
        this.securityKey = System.currentTimeMillis() * 10L + (long)(++difference);
        if (difference > 10) {
            difference = 0;
        }
        this.cm.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        this.cm.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        this.cm.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
    }

    @Override
    public void addAdditionalDrops(class_1937 level, class_2338 pos, List<class_1799> drops) {
        if (!this.getConfigSlot().isEmpty()) {
            drops.add(this.getConfigSlot().getStackInSlot(0));
        }
        for (AEItemKey key : this.inventory.getStoredItems()) {
            drops.add(key.toStack());
        }
    }

    @Override
    protected boolean readFromStream(class_2540 data) {
        boolean c = super.readFromStream(data);
        boolean wasActive = this.isActive;
        this.isActive = data.readBoolean();
        AEColor oldPaintedColor = this.paintedColor;
        this.paintedColor = AEColor.values()[data.readByte()];
        return oldPaintedColor != this.paintedColor || wasActive != this.isActive || c;
    }

    @Override
    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.writeBoolean(this.getMainNode().isActive());
        data.writeByte(this.paintedColor.ordinal());
    }

    @Override
    public void method_11007(class_2487 data) {
        super.method_11007(data);
        this.cm.writeToNBT(data);
        data.method_10567("paintedColor", (byte)this.paintedColor.ordinal());
        data.method_10544("securityKey", this.securityKey);
        this.getConfigSlot().writeToNBT(data, "config");
        class_2499 storedItems = new class_2499();
        for (AEItemKey key : this.inventory.getStoredItems()) {
            storedItems.add((Object)key.toTag());
        }
        data.method_10566("cards", (class_2520)storedItems);
    }

    @Override
    public void loadTag(class_2487 data) {
        super.loadTag(data);
        this.cm.readFromNBT(data);
        if (data.method_10545("paintedColor")) {
            this.paintedColor = AEColor.values()[data.method_10571("paintedColor")];
        }
        this.securityKey = data.method_10537("securityKey");
        this.getConfigSlot().readFromNBT(data, "config");
        class_2499 cards = data.method_10554("cards", 10);
        for (class_2520 keyTag : cards) {
            AEItemKey key = AEItemKey.fromTag((class_2487)keyTag);
            if (key == null) continue;
            this.inventory.getStoredItems().add(key);
        }
    }

    public void inventoryChanged() {
        this.saveChanges();
        this.getMainNode().ifPresent(grid -> grid.postEvent(new GridSecurityChange()));
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        this.markForUpdate();
    }

    @Override
    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.SMART;
    }

    @Override
    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        Locatables.securityStations().unregister(this.method_10997(), this.securityKey);
        this.isActive = false;
    }

    @Override
    public void onReady() {
        super.onReady();
        if (!this.isClientSide()) {
            this.isActive = true;
            Locatables.securityStations().register(this.method_10997(), this.securityKey, this);
        }
    }

    @Override
    public void method_11012() {
        super.method_11012();
        Locatables.securityStations().unregister(this.method_10997(), this.securityKey);
        this.isActive = false;
    }

    public boolean isActive() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            return this.isPowered();
        }
        return this.isActive;
    }

    @Override
    public MEStorage getInventory() {
        return this.inventory;
    }

    public boolean isPowered() {
        return this.getMainNode().isActive();
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.cm;
    }

    @Override
    public long getSecurityKey() {
        return this.securityKey;
    }

    @Override
    public void readPermissions(Map<Integer, EnumSet<SecurityPermissions>> playerPerms) {
        IPlayerRegistry pr = IPlayerRegistry.getMapping(this.method_10997());
        if (pr == null) {
            return;
        }
        for (AEItemKey key : this.inventory.getStoredItems()) {
            class_1792 class_17922 = key.getItem();
            if (!(class_17922 instanceof BiometricCardItem)) continue;
            BiometricCardItem bc = (BiometricCardItem)class_17922;
            int playerId = -1;
            GameProfile profile = bc.getProfile(key);
            if (profile != null) {
                playerId = pr.getPlayerId(profile);
            }
            EnumSet<SecurityPermissions> permissions = bc.getPermissions(key.getTag());
            playerPerms.put(playerId, permissions);
        }
        playerPerms.put(this.getMainNode().getNode().getOwningPlayerId(), EnumSet.allOf(SecurityPermissions.class));
    }

    @Override
    public boolean isSecurityEnabled() {
        return this.isActive && this.getMainNode().isActive();
    }

    @Override
    public int getOwner() {
        return this.getMainNode().getNode().getOwningPlayerId();
    }

    @Override
    public AEColor getColor() {
        return this.paintedColor;
    }

    @Override
    public boolean recolourBlock(class_2350 side, AEColor newPaintedColor, class_1657 who) {
        if (this.paintedColor == newPaintedColor) {
            return false;
        }
        this.paintedColor = newPaintedColor;
        this.saveChanges();
        this.markForUpdate();
        return true;
    }

    public AppEngInternalInventory getConfigSlot() {
        return this.configSlot;
    }

    @Override
    public void returnToMainMenu(class_1657 player, ISubMenu subMenu) {
        this.openMenu(player);
    }

    @Override
    public class_1799 getMainMenuIcon() {
        return new class_1799((class_1935)this.getItemFromBlockEntity());
    }

    public void openMenu(class_1657 p) {
        MenuOpener.open(SecurityStationMenu.TYPE, p, MenuLocators.forBlockEntity(this));
    }
}

