/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.networking;

import appeng.api.networking.IGridNode;
import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalBlockPos;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.client.render.cablebus.CableBusRenderState;
import appeng.core.AppEng;
import appeng.helpers.AEMultiBlockEntity;
import appeng.hooks.ticking.TickHandler;
import appeng.parts.CableBusContainer;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class CableBusBlockEntity
extends AEBaseBlockEntity
implements AEMultiBlockEntity {
    private CableBusContainer cb = new CableBusContainer(this);
    private int oldLV = -1;

    public CableBusBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
    }

    @Override
    public void loadTag(class_2487 data) {
        super.loadTag(data);
        this.getCableBus().readFromNBT(data);
    }

    @Override
    public void method_11007(class_2487 data) {
        super.method_11007(data);
        this.getCableBus().writeToNBT(data);
    }

    @Override
    protected boolean readFromStream(class_2540 data) {
        boolean c = super.readFromStream(data);
        boolean ret = this.getCableBus().readFromStream(data);
        int newLV = this.getCableBus().getLightValue();
        if (newLV != this.oldLV) {
            this.oldLV = newLV;
            this.field_11863.method_22336().method_15513(this.field_11867);
            ret = true;
        }
        this.updateBlockEntitySettings();
        return ret || c;
    }

    @Override
    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        this.getCableBus().writeToStream(data);
    }

    protected void updateBlockEntitySettings() {
    }

    public void method_11012() {
        super.method_11012();
        this.getCableBus().removeFromWorld();
    }

    public void method_10996() {
        super.method_10996();
        TickHandler.instance().addInit(this);
    }

    @Override
    public IGridNode getGridNode(class_2350 dir) {
        return this.getCableBus().getGridNode(dir);
    }

    @Override
    public AECableType getCableConnectionType(class_2350 side) {
        return this.getCableBus().getCableConnectionType(side);
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return this.getCableBus().getCableConnectionLength(cable);
    }

    @Override
    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.getCableBus().removeFromWorld();
    }

    @Override
    public void markForUpdate() {
        if (this.field_11863 == null) {
            return;
        }
        int newLV = this.getCableBus().getLightValue();
        if (newLV != this.oldLV) {
            this.oldLV = newLV;
            this.field_11863.method_22336().method_15513(this.field_11867);
        }
        super.markForUpdate();
    }

    @Override
    public boolean canBeRotated() {
        return false;
    }

    @Override
    public void addAdditionalDrops(class_1937 level, class_2338 pos, List<class_1799> drops) {
        this.getCableBus().addAdditionalDrops(drops);
    }

    @Override
    public void onReady() {
        super.onReady();
        if (this.getCableBus().isEmpty()) {
            if (this.field_11863.method_8321(this.field_11867) == this) {
                this.field_11863.method_22352(this.field_11867, true);
            }
        } else {
            this.getCableBus().addToWorld();
        }
    }

    @Override
    public IFacadeContainer getFacadeContainer() {
        return this.getCableBus().getFacadeContainer();
    }

    @Override
    @javax.annotation.Nullable
    public IPart getPart(@javax.annotation.Nullable class_2350 side) {
        return this.cb.getPart(side);
    }

    @Override
    public boolean canAddPart(class_1799 is, class_2350 side) {
        return this.getCableBus().canAddPart(is, side);
    }

    @Override
    @javax.annotation.Nullable
    public <T extends IPart> T addPart(IPartItem<T> partItem, class_2350 side, @Nullable class_1657 player) {
        return this.cb.addPart(partItem, side, player);
    }

    @Override
    @Nullable
    public <T extends IPart> T replacePart(IPartItem<T> partItem, @Nullable class_2350 side, class_1657 owner, class_1268 hand) {
        return this.cb.replacePart(partItem, side, owner, hand);
    }

    @Override
    public void removePart(@javax.annotation.Nullable class_2350 side) {
        this.getCableBus().removePart(side);
    }

    @Override
    public DimensionalBlockPos getLocation() {
        return new DimensionalBlockPos(this);
    }

    @Override
    public AEColor getColor() {
        return this.getCableBus().getColor();
    }

    @Override
    public void clearContainer() {
        this.setCableBus(new CableBusContainer(this));
    }

    @Override
    public boolean isBlocked(class_2350 side) {
        return false;
    }

    @Override
    public SelectedPart selectPartLocal(class_243 pos) {
        return this.getCableBus().selectPartLocal(pos);
    }

    @Override
    public void markForSave() {
        this.saveChanges();
    }

    @Override
    public void partChanged() {
        this.notifyNeighbors();
    }

    @Override
    public boolean hasRedstone() {
        return this.getCableBus().hasRedstone();
    }

    @Override
    public boolean isEmpty() {
        return this.getCableBus().isEmpty();
    }

    @Override
    public void cleanup() {
        this.method_10997().method_8650(this.field_11867, false);
    }

    @Override
    public void notifyNeighbors() {
        if (this.field_11863 != null && this.field_11863.method_22340(this.field_11867) && !CableBusContainer.isLoading()) {
            Platform.notifyBlocksOfNeighbors(this.field_11863, this.field_11867);
        }
    }

    @Override
    public boolean isInWorld() {
        return this.getCableBus().isInWorld();
    }

    @Override
    public boolean recolourBlock(class_2350 side, AEColor colour, class_1657 who) {
        return this.getCableBus().recolourBlock(side, colour, who);
    }

    public CableBusContainer getCableBus() {
        return this.cb;
    }

    private void setCableBus(CableBusContainer cb) {
        this.cb = cb;
    }

    @Override
    public CableBusRenderState getRenderAttachmentData() {
        if (this.field_11863 == null) {
            return null;
        }
        CableBusRenderState renderState = this.cb.getRenderState();
        renderState.setLevel((class_1920)this.field_11863);
        renderState.setPos(this.method_11016());
        return renderState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public class_1269 disassembleWithWrench(class_1657 player, class_1937 level, class_3965 hitResult) {
        if (!level.field_9236) {
            SelectedPart sp;
            ArrayList<class_1799> is = new ArrayList<class_1799>();
            AppEng.instance().setPartInteractionPlayer(player);
            try {
                sp = this.cb.selectPartWorld(hitResult.method_17784());
            }
            finally {
                AppEng.instance().setPartInteractionPlayer(null);
            }
            if (sp.part != null) {
                sp.part.addPartDrop(is, true);
                sp.part.addAdditionalDrops(is, true);
                this.cb.removePart(sp.side);
            }
            class_2338 pos = this.method_11016();
            if (sp.facade != null) {
                is.add(sp.facade.getItemStack());
                this.cb.getFacadeContainer().removeFacade(this.cb, sp.side);
                Platform.notifyBlocksOfNeighbors(level, pos);
            }
            if (!is.isEmpty()) {
                Platform.spawnDrops(level, pos, is);
            }
        }
        return class_1269.method_29236((boolean)level.method_8608());
    }
}

