/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.networking;

import appeng.api.config.Actionable;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.events.GridControllerChange;
import appeng.api.networking.events.GridPowerStorageStateChanged;
import appeng.api.networking.pathing.ControllerState;
import appeng.api.util.AECableType;
import appeng.block.networking.ControllerBlock;
import appeng.blockentity.grid.AENetworkPowerBlockEntity;
import appeng.util.Platform;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class ControllerBlockEntity
extends AENetworkPowerBlockEntity {
    public ControllerBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        this.setInternalMaxPower(8000.0);
        this.setInternalPublicPowerStorage(true);
        this.getMainNode().setIdlePowerUsage(3.0);
        this.getMainNode().setFlags(GridFlags.CANNOT_CARRY, GridFlags.DENSE_CAPACITY);
    }

    @Override
    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.DENSE_SMART;
    }

    @Override
    public void onReady() {
        super.onReady();
        this.updateState();
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        this.updateState();
    }

    public void updateState() {
        if (!this.getMainNode().isReady()) {
            return;
        }
        ControllerBlock.ControllerBlockState metaState = ControllerBlock.ControllerBlockState.offline;
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null) {
            if (grid.getEnergyService().isNetworkPowered()) {
                metaState = ControllerBlock.ControllerBlockState.online;
                if (grid.getPathingService().getControllerState() == ControllerState.CONTROLLER_CONFLICT) {
                    metaState = ControllerBlock.ControllerBlockState.conflicted;
                }
            }
        } else {
            metaState = ControllerBlock.ControllerBlockState.offline;
        }
        if (this.checkController(this.field_11867) && this.field_11863.method_8320(this.field_11867).method_11654(ControllerBlock.CONTROLLER_STATE) != metaState) {
            this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657(ControllerBlock.CONTROLLER_STATE, (Comparable)((Object)metaState)));
        }
    }

    @Override
    protected double getFunnelPowerDemand(double maxReceived) {
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null) {
            return grid.getEnergyService().getEnergyDemand(maxReceived);
        }
        return super.getFunnelPowerDemand(maxReceived);
    }

    @Override
    protected double funnelPowerIntoStorage(double power, Actionable mode) {
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null) {
            return grid.getEnergyService().injectPower(power, mode);
        }
        return super.funnelPowerIntoStorage(power, mode);
    }

    @Override
    protected void PowerEvent(GridPowerStorageStateChanged.PowerEventType x) {
        this.getMainNode().ifPresent(grid -> grid.postEvent(new GridPowerStorageStateChanged(this, x)));
    }

    @Override
    public InternalInventory getInternalInventory() {
        return InternalInventory.empty();
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
    }

    private boolean checkController(class_2338 pos) {
        return Platform.getTickingBlockEntity(this.method_10997(), pos) instanceof ControllerBlockEntity;
    }

    @Override
    public boolean canBeRotated() {
        return false;
    }

    static {
        GridHelper.addNodeOwnerEventHandler(GridControllerChange.class, ControllerBlockEntity.class, ControllerBlockEntity::updateState);
    }
}

