/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.storage;

import appeng.api.implementations.blockentities.IChestOrDrive;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNodeListener;
import appeng.api.storage.IStorageMounts;
import appeng.api.storage.IStorageProvider;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.StorageCell;
import appeng.api.util.AECableType;
import appeng.blockentity.grid.AENetworkInvBlockEntity;
import appeng.blockentity.inventory.AppEngCellInventory;
import appeng.client.render.model.DriveModelData;
import appeng.core.definitions.AEBlocks;
import appeng.helpers.IPriorityHost;
import appeng.me.storage.DriveWatcher;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.implementations.DriveMenu;
import appeng.menu.locator.MenuLocators;
import appeng.util.inv.filter.IAEItemFilter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class DriveBlockEntity
extends AENetworkInvBlockEntity
implements IChestOrDrive,
IPriorityHost,
IStorageProvider {
    private static final int SLOT_COUNT = 10;
    private static final int BIT_POWER_MASK = Integer.MIN_VALUE;
    private static final int BIT_STATE_MASK = 0x3FFFFFFF;
    private static final int BIT_CELL_STATE_MASK = 7;
    private static final int BIT_CELL_STATE_BITS = 3;
    private final AppEngCellInventory inv = new AppEngCellInventory(this, 10);
    private final DriveWatcher[] invBySlot = new DriveWatcher[10];
    private boolean isCached = false;
    private int priority = 0;
    private boolean wasActive = false;
    private final class_1792[] cellItems = new class_1792[10];
    private int state = 0;

    public DriveBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().addService(IStorageProvider.class, this).setFlags(GridFlags.REQUIRE_CHANNEL);
        this.inv.setFilter(new CellValidInventoryFilter());
    }

    @Override
    public void setOrientation(class_2350 inForward, class_2350 inUp) {
        super.setOrientation(inForward, inUp);
        this.getMainNode().setExposedOnSides(EnumSet.complementOf(EnumSet.of(inForward)));
    }

    @Override
    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        this.state = this.calculateCurrentVisualState();
        data.writeInt(this.state);
        this.writeCellItemIds(data);
    }

    private void writeCellItemIds(class_2540 data) {
        ArrayList<class_2960> cellItemIds = new ArrayList<class_2960>(this.getCellCount());
        byte[] bm = new byte[this.getCellCount()];
        for (int x = 0; x < this.getCellCount(); ++x) {
            class_1792 item = this.getCellItem(x);
            if (item == null || Objects.equals(class_2378.field_11142.method_10221((Object)item), class_2378.field_11142.method_10137())) continue;
            class_2960 itemId = class_2378.field_11142.method_10221((Object)item);
            int idx = cellItemIds.indexOf(itemId);
            if (idx == -1) {
                cellItemIds.add(itemId);
                bm[x] = (byte)cellItemIds.size();
                continue;
            }
            bm[x] = (byte)(1 + idx);
        }
        data.writeByte(cellItemIds.size());
        for (class_2960 itemId : cellItemIds) {
            data.method_10812(itemId);
        }
        for (int i = 0; i < this.getCellCount(); ++i) {
            data.writeByte((int)bm[i]);
        }
    }

    @Override
    protected boolean readFromStream(class_2540 data) {
        boolean c = super.readFromStream(data);
        int oldState = this.state;
        this.state = data.readInt();
        return (this.state & 0x3FFFFFFF) != (oldState & 0x3FFFFFFF) || (c |= this.readCellItemIDs(data));
    }

    private boolean readCellItemIDs(class_2540 data) {
        int uniqueStrCount = data.readByte();
        String[] uniqueStrs = new String[uniqueStrCount];
        for (int i = 0; i < uniqueStrCount; ++i) {
            uniqueStrs[i] = data.method_19772();
        }
        boolean changed = false;
        for (int i = 0; i < this.getCellCount(); ++i) {
            byte idx = data.readByte();
            class_1792 item = null;
            if (idx > 0) {
                idx = (byte)(idx - 1);
                String itemId = uniqueStrs[idx];
                item = (class_1792)class_2378.field_11142.method_10223(new class_2960(itemId));
            }
            if (this.cellItems[i] == item) continue;
            changed = true;
            this.cellItems[i] = item;
        }
        return changed;
    }

    @Override
    public int getCellCount() {
        return 10;
    }

    @Override
    @Nullable
    public class_1792 getCellItem(int slot) {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return this.cellItems[slot];
        }
        class_1799 stackInSlot = this.inv.getStackInSlot(slot);
        if (!stackInSlot.method_7960()) {
            return stackInSlot.method_7909();
        }
        return null;
    }

    @Override
    public CellState getCellStatus(int slot) {
        if (this.isClientSide()) {
            int cellState = this.state >> slot * 3 & 7;
            return CellState.values()[cellState];
        }
        DriveWatcher handler = this.invBySlot[slot];
        if (handler == null) {
            return CellState.ABSENT;
        }
        return handler.getStatus();
    }

    @Override
    public boolean isPowered() {
        if (this.isClientSide()) {
            return (this.state & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        }
        return this.getMainNode().isActive();
    }

    @Override
    public boolean isCellBlinking(int slot) {
        return false;
    }

    @Override
    public void loadTag(class_2487 data) {
        super.loadTag(data);
        this.isCached = false;
        this.priority = data.method_10550("priority");
    }

    @Override
    public void method_11007(class_2487 data) {
        super.method_11007(data);
        data.method_10569("priority", this.priority);
    }

    private void updateVisualStateIfNeeded() {
        int newState = this.calculateCurrentVisualState();
        if (newState != this.state) {
            this.state = newState;
            this.markForUpdate();
        }
    }

    private int calculateCurrentVisualState() {
        this.updateState();
        int newState = 0;
        if (this.getMainNode().isActive()) {
            newState |= Integer.MIN_VALUE;
        }
        for (int x = 0; x < this.getCellCount(); ++x) {
            newState |= this.getCellStatus(x).ordinal() << 3 * x;
        }
        return newState;
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        boolean currentActive = this.getMainNode().isActive();
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            IStorageProvider.requestUpdate(this.getMainNode());
            this.updateVisualStateIfNeeded();
        }
    }

    @Override
    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.SMART;
    }

    @Override
    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        if (this.isCached) {
            this.isCached = false;
            this.updateState();
        }
        IStorageProvider.requestUpdate(this.getMainNode());
        this.markForUpdate();
    }

    private void updateState() {
        if (!this.isCached) {
            double power = 2.0;
            for (int slot = 0; slot < this.inv.size(); ++slot) {
                power += this.updateStateForSlot(slot);
            }
            this.getMainNode().setIdlePowerUsage(power);
            this.isCached = true;
        }
    }

    private double updateStateForSlot(int slot) {
        StorageCell cell;
        this.invBySlot[slot] = null;
        this.inv.setHandler(slot, null);
        class_1799 is = this.inv.getStackInSlot(slot);
        if (!is.method_7960() && (cell = StorageCells.getCellInventory(is, this::onCellContentChanged)) != null) {
            DriveWatcher driveWatcher;
            this.inv.setHandler(slot, cell);
            this.invBySlot[slot] = driveWatcher = new DriveWatcher(cell, () -> this.blinkCell(slot));
            return cell.getIdleDrain();
        }
        return 0.0;
    }

    @Override
    public void onReady() {
        super.onReady();
        this.updateState();
    }

    @Override
    public void mountInventories(IStorageMounts storageMounts) {
        if (this.getMainNode().isActive()) {
            this.updateState();
            for (DriveWatcher inventory : this.invBySlot) {
                if (inventory == null) continue;
                storageMounts.mount(inventory, this.priority);
            }
        }
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.saveChanges();
        this.isCached = false;
        this.updateState();
        IStorageProvider.requestUpdate(this.getMainNode());
    }

    private void blinkCell(int slot) {
        this.updateVisualStateIfNeeded();
    }

    private void onCellContentChanged() {
        this.field_11863.method_8524(this.field_11867);
    }

    @Override
    public DriveModelData getRenderAttachmentData() {
        class_1792[] cells = new class_1792[this.getCellCount()];
        for (int i = 0; i < this.getCellCount(); ++i) {
            cells[i] = this.getCellItem(i);
        }
        return new DriveModelData(this.getUp(), this.getForward(), cells);
    }

    public void openMenu(class_1657 player) {
        MenuOpener.open(DriveMenu.TYPE, player, MenuLocators.forBlockEntity(this));
    }

    @Override
    public void returnToMainMenu(class_1657 player, ISubMenu subMenu) {
        this.openMenu(player);
    }

    @Override
    public class_1799 getMainMenuIcon() {
        return AEBlocks.DRIVE.stack();
    }

    private static class CellValidInventoryFilter
    implements IAEItemFilter {
        private CellValidInventoryFilter() {
        }

        @Override
        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return true;
        }

        @Override
        public boolean allowInsert(InternalInventory inv, int slot, class_1799 stack) {
            return !stack.method_7960() && StorageCells.isCellHandled(stack);
        }
    }
}

