/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui;

import appeng.api.client.AEStackRendering;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.GenericStack;
import appeng.client.Point;
import appeng.client.gui.Icon;
import appeng.client.gui.TextOverride;
import appeng.client.gui.Tooltip;
import appeng.client.gui.WidgetContainer;
import appeng.client.gui.layout.SlotGridLayout;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.style.SlotPosition;
import appeng.client.gui.style.Text;
import appeng.client.gui.style.TextAlignment;
import appeng.client.gui.style.WidgetStyle;
import appeng.client.gui.widgets.ITickingWidget;
import appeng.client.gui.widgets.ITooltip;
import appeng.client.gui.widgets.VerticalButtonBar;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.Tooltips;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.core.sync.packets.SwapSlotsPacket;
import appeng.helpers.InventoryAction;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantic;
import appeng.menu.SlotSemantics;
import appeng.menu.me.interaction.EmptyingAction;
import appeng.menu.me.interaction.StackInteractions;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.CraftingTermSlot;
import appeng.menu.slot.DisabledSlot;
import appeng.menu.slot.FakeSlot;
import appeng.menu.slot.IOptionalSlot;
import appeng.menu.slot.ResizableSlot;
import appeng.util.ConfigMenuInventory;
import com.google.common.base.Stopwatch;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_341;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_768;

public abstract class AEBaseScreen<T extends AEBaseMenu>
extends class_465<T> {
    private static final Point HIDDEN_SLOT_POS = new Point(-9999, -9999);
    public static final String TEXT_ID_DIALOG_TITLE = "dialog_title";
    private final VerticalButtonBar verticalToolbar;
    private final Set<class_1735> drag_click = new HashSet<class_1735>();
    private boolean disableShiftClick = false;
    private Stopwatch dbl_clickTimer = Stopwatch.createStarted();
    private class_1799 dbl_whichItem = class_1799.field_8037;
    private class_1735 bl_clicked;
    private boolean handlingRightClick;
    private final Map<String, TextOverride> textOverrides = new HashMap<String, TextOverride>();
    private final Set<SlotSemantic> hiddenSlots = new HashSet<SlotSemantic>();
    protected final WidgetContainer widgets;
    protected final ScreenStyle style;
    private static final class_2583 TOOLTIP_HEADER = class_2583.field_24360.method_27706(class_124.field_1068);
    private static final class_2583 TOOLTIP_BODY = class_2583.field_24360.method_27706(class_124.field_1080);

    public AEBaseScreen(T menu, class_1661 playerInventory, class_2561 title, ScreenStyle style) {
        super(menu, playerInventory, title);
        this.field_22788 = class_310.method_1551().method_1480();
        this.field_22793 = class_310.method_1551().field_1772;
        this.style = Objects.requireNonNull(style, "style");
        this.widgets = new WidgetContainer(style);
        this.verticalToolbar = new VerticalButtonBar();
        this.widgets.add("verticalToolbar", this.verticalToolbar);
        if (style.getBackground() != null) {
            this.field_2792 = style.getBackground().getSrcWidth();
            this.field_2779 = style.getBackground().getSrcHeight();
        }
    }

    @OverridingMethodsMustInvokeSuper
    protected void method_25426() {
        super.method_25426();
        this.positionSlots(this.style);
        this.widgets.populateScreen(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        }, this.getBounds(true), this);
    }

    private void positionSlots(ScreenStyle style) {
        for (Map.Entry<String, SlotPosition> entry : style.getSlots().entrySet()) {
            SlotSemantic semantic = SlotSemantics.getOrThrow(entry.getKey());
            if (this.hiddenSlots.contains(semantic)) continue;
            List<class_1735> slots = ((AEBaseMenu)this.field_2797).getSlots(semantic);
            for (int i = 0; i < slots.size(); ++i) {
                class_1735 slot = slots.get(i);
                if (slot instanceof ResizableSlot) {
                    ResizableSlot resizableSlot = (ResizableSlot)slot;
                    WidgetStyle widgetStyle = style.getWidget(resizableSlot.getStyleId());
                    Point pos = widgetStyle.resolve(this.getBounds(false));
                    slot.field_7873 = pos.getX();
                    slot.field_7872 = pos.getY();
                    resizableSlot.setWidth(widgetStyle.getWidth());
                    resizableSlot.setHeight(widgetStyle.getHeight());
                    continue;
                }
                Point pos = this.getSlotPosition(entry.getValue(), i);
                slot.field_7873 = pos.getX();
                slot.field_7872 = pos.getY();
            }
        }
    }

    private Point getSlotPosition(SlotPosition position, int semanticIndex) {
        Point pos = position.resolve(this.getBounds(false));
        SlotGridLayout grid = position.getGrid();
        if (grid != null) {
            pos = grid.getPosition(pos.getX(), pos.getY(), semanticIndex);
        }
        return pos;
    }

    private class_768 getBounds(boolean absolute) {
        if (absolute) {
            return new class_768(this.field_2776, this.field_2800, this.field_2792, this.field_2779);
        }
        return new class_768(0, 0, this.field_2792, this.field_2779);
    }

    private List<class_1735> getInventorySlots() {
        return ((AEBaseMenu)this.field_2797).field_7761;
    }

    @OverridingMethodsMustInvokeSuper
    protected void updateBeforeRender() {
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        this.updateBeforeRender();
        this.widgets.updateBeforeRender();
        super.method_25420(poseStack);
        super.method_25394(poseStack, mouseX, mouseY, partialTicks);
        this.renderTooltips(poseStack, mouseX, mouseY);
        if (AEConfig.instance().isShowDebugGuiOverlays()) {
            List<class_768> exclusionZones = this.getExclusionZones();
            for (class_768 rectangle2d : exclusionZones) {
                this.fillRect(poseStack, rectangle2d, 0x7F00FF00);
            }
            this.method_25292(poseStack, this.field_2776, this.field_2776 + this.field_2792 - 1, this.field_2800, -1);
            this.method_25292(poseStack, this.field_2776, this.field_2776 + this.field_2792 - 1, this.field_2800 + this.field_2779 - 1, -1);
            this.method_25301(poseStack, this.field_2776, this.field_2800, this.field_2800 + this.field_2779, -1);
            this.method_25301(poseStack, this.field_2776 + this.field_2792 - 1, this.field_2800, this.field_2800 + this.field_2779 - 1, -1);
        }
    }

    protected EmptyingAction getEmptyingAction(class_1735 slot, class_1799 carried) {
        class_1799 wrappedStack;
        AppEngSlot appEngSlot;
        block6: {
            block5: {
                if (!(slot instanceof AppEngSlot)) break block5;
                appEngSlot = (AppEngSlot)slot;
                if (!carried.method_7960()) break block6;
            }
            return null;
        }
        InternalInventory internalInventory = appEngSlot.getInventory();
        if (!(internalInventory instanceof ConfigMenuInventory)) {
            return null;
        }
        ConfigMenuInventory configInv = (ConfigMenuInventory)internalInventory;
        EmptyingAction emptyingAction = StackInteractions.getEmptyingAction(carried);
        if (emptyingAction != null && configInv.isItemValid(slot.field_7875, wrappedStack = GenericStack.wrapInItemStack(new GenericStack(emptyingAction.what(), 1L)))) {
            return emptyingAction;
        }
        return null;
    }

    private boolean renderEmptyingTooltip(class_4587 poseStack, int mouseX, int mouseY) {
        EmptyingAction emptyingAction = this.getEmptyingAction(this.field_2787, ((AEBaseMenu)this.field_2797).method_34255());
        if (emptyingAction != null) {
            this.drawTooltip(poseStack, mouseX, mouseY, Tooltips.getEmptyingTooltip(ButtonToolTips.SetAction, ((AEBaseMenu)this.field_2797).method_34255(), emptyingAction));
            return true;
        }
        return false;
    }

    private void renderTooltips(class_4587 poseStack, int mouseX, int mouseY) {
        Object appEngSlot;
        List<class_2561> customTooltip;
        if (this.renderEmptyingTooltip(poseStack, mouseX, mouseY)) {
            return;
        }
        class_1735 class_17352 = this.field_2787;
        if (class_17352 instanceof AppEngSlot && (customTooltip = ((AppEngSlot)((Object)(appEngSlot = (AppEngSlot)class_17352))).getCustomTooltip(this::method_25408, ((AEBaseMenu)this.field_2797).method_34255())) != null) {
            this.drawTooltip(poseStack, mouseX, mouseY, customTooltip);
        }
        this.method_2380(poseStack, mouseX, mouseY);
        if (this.field_2787 != null && this.field_2787.method_7681()) {
            return;
        }
        for (class_4068 c : this.field_33816) {
            Tooltip tooltip;
            class_768 area;
            ITooltip tooltipWidget;
            if (!(c instanceof ITooltip) || !(tooltipWidget = (ITooltip)c).isTooltipAreaVisible() || mouseX < (area = tooltipWidget.getTooltipArea()).method_3321() || mouseY < area.method_3322() || mouseX >= area.method_3321() + area.method_3319() || mouseY >= area.method_3322() + area.method_3320() || (tooltip = new Tooltip(tooltipWidget.getTooltipMessage())).getContent().isEmpty()) continue;
            this.drawTooltipWithHeader(poseStack, tooltip, mouseX, mouseY);
        }
        Tooltip tooltip = this.widgets.getTooltip(mouseX - this.field_2776, mouseY - this.field_2800);
        if (tooltip != null) {
            this.drawTooltipWithHeader(poseStack, tooltip, mouseX, mouseY);
        }
    }

    private void drawTooltipWithHeader(class_4587 poseStack, Tooltip tooltip, int mouseX, int mouseY) {
        this.drawTooltipWithHeader(poseStack, mouseX, mouseY, tooltip.getContent());
    }

    public void drawTooltip(class_4587 poseStack, int x, int y, List<class_2561> lines) {
        if (lines.isEmpty()) {
            return;
        }
        int maxWidth = this.field_22789 / 2 - 40;
        ArrayList styledLines = new ArrayList(lines.size());
        for (class_2561 line : lines) {
            styledLines.addAll(class_341.method_1850((class_5348)line, (int)maxWidth, (class_327)this.field_22793));
        }
        this.method_25417(poseStack, styledLines, x, y);
    }

    public void drawTooltipWithHeader(class_4587 poseStack, int x, int y, List<class_2561> lines) {
        if (lines.isEmpty()) {
            return;
        }
        ArrayList<class_2561> formattedLines = new ArrayList<class_2561>(lines.size());
        for (int i = 0; i < lines.size(); ++i) {
            class_2583 style = i == 0 ? TOOLTIP_HEADER : TOOLTIP_BODY;
            formattedLines.add((class_2561)lines.get(i).method_27661().method_27694(s -> style));
        }
        this.drawTooltip(poseStack, x, y, formattedLines);
    }

    protected final void method_2388(class_4587 poseStack, int x, int y) {
        int ox = this.field_2776;
        int oy = this.field_2800;
        this.widgets.drawForegroundLayer(poseStack, this.method_25305(), this.getBounds(false), new Point(x - ox, y - oy));
        this.drawFG(poseStack, ox, oy, x, y);
        if (this.style != null) {
            for (Map.Entry<String, Text> entry : this.style.getText().entrySet()) {
                TextOverride override = this.textOverrides.get(entry.getKey());
                this.drawText(poseStack, entry.getValue(), override);
            }
        }
    }

    private void drawText(class_4587 poseStack, Text text, @Nullable TextOverride override) {
        if (override != null && override.isHidden()) {
            return;
        }
        int color = this.style.getColor(text.getColor()).toARGB();
        class_2561 content = text.getText();
        if (override != null && override.getContent() != null) {
            content = override.getContent().method_27661().method_27696(content.method_10866());
        }
        Point pos = text.getPosition().resolve(this.getBounds(false));
        float scale = text.getScale();
        if (text.getAlign() == TextAlignment.CENTER) {
            int textWidth = Math.round((float)this.field_22793.method_27525((class_5348)content) * scale);
            pos = pos.move(-textWidth / 2, 0);
        } else if (text.getAlign() == TextAlignment.RIGHT) {
            int textWidth = Math.round((float)this.field_22793.method_27525((class_5348)content) * scale);
            pos = pos.move(-textWidth, 0);
        }
        if (text.getScale() == 1.0f) {
            this.field_22793.method_30883(poseStack, content, (float)pos.getX(), (float)pos.getY(), color);
        } else {
            poseStack.method_22903();
            poseStack.method_22904((double)pos.getX(), (double)pos.getY(), 0.0);
            poseStack.method_22905(text.getScale(), text.getScale(), 1.0f);
            this.field_22793.method_30883(poseStack, content, 0.0f, 0.0f, color);
            poseStack.method_22909();
        }
    }

    public void drawFG(class_4587 poseStack, int offsetX, int offsetY, int mouseX, int mouseY) {
    }

    protected final void method_2389(class_4587 poseStack, float f, int x, int y) {
        this.drawBG(poseStack, this.field_2776, this.field_2800, x, y, f);
        this.widgets.drawBackgroundLayer(poseStack, this.method_25305(), this.getBounds(true), new Point(x - this.field_2776, y - this.field_2800));
        for (class_1735 slot : this.getInventorySlots()) {
            if (!(slot instanceof IOptionalSlot)) continue;
            this.drawOptionalSlotBackground(poseStack, (IOptionalSlot)slot, false);
        }
    }

    private void drawOptionalSlotBackground(class_4587 poseStack, IOptionalSlot slot, boolean alwaysDraw) {
        if (alwaysDraw || slot.isRenderDisabled()) {
            float alpha = slot.isSlotEnabled() ? 1.0f : 0.4f;
            Point pos = slot.getBackgroundPos();
            Icon.SLOT_BACKGROUND.getBlitter().dest(this.field_2776 + pos.getX(), this.field_2800 + pos.getY()).color(1.0f, 1.0f, 1.0f, alpha).blit(poseStack, this.method_25305());
        }
    }

    private Point getMousePoint(double x, double y) {
        return new Point((int)Math.round(x - (double)this.field_2776), (int)Math.round(y - (double)this.field_2800));
    }

    public boolean method_25401(double x, double y, double wheelDelta) {
        return wheelDelta != 0.0 && this.widgets.onMouseWheel(this.getMousePoint(x, y), wheelDelta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean method_25402(double xCoord, double yCoord, int btn) {
        this.drag_click.clear();
        if (btn == 1) {
            this.handlingRightClick = true;
            try {
                for (class_364 widget : this.method_25396()) {
                    if (!widget.method_25405(xCoord, yCoord)) continue;
                    boolean bl = super.method_25402(xCoord, yCoord, 0);
                    return bl;
                }
            }
            finally {
                this.handlingRightClick = false;
            }
        }
        if (this.widgets.onMouseDown(this.getMousePoint(xCoord, yCoord), btn)) {
            return true;
        }
        return super.method_25402(xCoord, yCoord, btn);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.widgets.onMouseUp(this.getMousePoint(mouseX, mouseY), button)) {
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        class_1735 slot = this.method_2386(mouseX, mouseY);
        class_1799 itemstack = ((AEBaseMenu)this.method_17577()).method_34255();
        Point mousePos = new Point((int)Math.round(mouseX - (double)this.field_2776), (int)Math.round(mouseY - (double)this.field_2800));
        if (this.widgets.onMouseDrag(mousePos, mouseButton)) {
            return true;
        }
        if (slot instanceof FakeSlot && !itemstack.method_7960()) {
            this.drag_click.add(slot);
            if (this.drag_click.size() > 1) {
                for (class_1735 dr : this.drag_click) {
                    InventoryActionPacket p = new InventoryActionPacket(mouseButton == 0 ? InventoryAction.PICKUP_OR_SET_DOWN : InventoryAction.PLACE_SINGLE, dr.field_7874, 0L);
                    NetworkHandler.instance().sendToServer(p);
                }
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, mouseButton, dragX, dragY);
    }

    protected void method_2383(@Nullable class_1735 slot, int slotIdx, int mouseButton, class_1713 clickType) {
        if (slot instanceof DisabledSlot) {
            return;
        }
        if (this.drag_click.size() <= 1 && mouseButton == 1 && this.getEmptyingAction(slot, ((AEBaseMenu)this.field_2797).method_34255()) != null) {
            InventoryActionPacket p = new InventoryActionPacket(InventoryAction.EMPTY_ITEM, slotIdx, 0L);
            NetworkHandler.instance().sendToServer(p);
            return;
        }
        if (slot instanceof FakeSlot) {
            if (this.drag_click.size() > 1) {
                return;
            }
            InventoryAction action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
            InventoryActionPacket p = new InventoryActionPacket(action, slotIdx, 0L);
            NetworkHandler.instance().sendToServer(p);
            return;
        }
        if (slot instanceof CraftingTermSlot) {
            InventoryAction action = AEBaseScreen.method_25442() ? InventoryAction.CRAFT_SHIFT : (mouseButton == 1 ? InventoryAction.CRAFT_STACK : InventoryAction.CRAFT_ITEM);
            InventoryActionPacket p = new InventoryActionPacket(action, slotIdx, 0L);
            NetworkHandler.instance().sendToServer(p);
            return;
        }
        if (slot != null && class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)32)) {
            int slotNum = slot.field_7874;
            InventoryActionPacket p = new InventoryActionPacket(InventoryAction.MOVE_REGION, slotNum, 0L);
            NetworkHandler.instance().sendToServer(p);
            return;
        }
        if (slot != null && !this.disableShiftClick && AEBaseScreen.method_25442() && mouseButton == 0) {
            this.disableShiftClick = true;
            if (this.dbl_whichItem.method_7960() || this.bl_clicked != slot || this.dbl_clickTimer.elapsed(TimeUnit.MILLISECONDS) > 250L) {
                this.bl_clicked = slot;
                this.dbl_clickTimer = Stopwatch.createStarted();
                this.dbl_whichItem = slot.method_7681() ? slot.method_7677().method_7972() : class_1799.field_8037;
            } else if (!this.dbl_whichItem.method_7960()) {
                List<class_1735> slots = this.getInventorySlots();
                for (class_1735 inventorySlot : slots) {
                    if (inventorySlot == null || !inventorySlot.method_7674((class_1657)this.getPlayer()) || !inventorySlot.method_7681() || !AEBaseScreen.isSameInventory(inventorySlot, slot) || !class_1703.method_7592((class_1735)inventorySlot, (class_1799)this.dbl_whichItem, (boolean)true)) continue;
                    this.method_2383(inventorySlot, inventorySlot.field_7874, 0, class_1713.field_7794);
                }
                this.dbl_whichItem = class_1799.field_8037;
            }
            this.disableShiftClick = false;
        }
        super.method_2383(slot, slotIdx, mouseButton, clickType);
    }

    protected boolean method_2381(double mouseX, double mouseY, int screenX, int screenY, int button) {
        Point mousePos = new Point((int)Math.round(mouseX - (double)screenX), (int)Math.round(mouseY - (double)screenY));
        if (this.widgets.hitTest(mousePos)) {
            return false;
        }
        return super.method_2381(mouseX, mouseY, screenX, screenY, button);
    }

    protected boolean method_2384(int keyCode, int scanCode) {
        return this.checkHotbarKeys(class_3675.method_15985((int)keyCode, (int)scanCode));
    }

    protected class_746 getPlayer() {
        return Objects.requireNonNull(this.getMinecraft().field_1724);
    }

    protected boolean checkHotbarKeys(class_3675.class_306 input) {
        class_1735 theSlot = this.getSlotUnderMouse();
        if (((AEBaseMenu)this.method_17577()).method_34255().method_7960() && theSlot != null) {
            for (int j = 0; j < 9; ++j) {
                if (!this.getMinecraft().field_1690.field_1852[j].method_1417(input.method_1444(), -1)) continue;
                List<class_1735> slots = this.getInventorySlots();
                for (class_1735 s : slots) {
                    if (s.field_7875 != j || s.field_7871 != ((AEBaseMenu)this.field_2797).getPlayerInventory() || s.method_7674(((AEBaseMenu)this.field_2797).getPlayerInventory().field_7546)) continue;
                    return false;
                }
                if (theSlot.method_7675() == 64) {
                    this.method_2383(theSlot, theSlot.field_7874, j, class_1713.field_7791);
                    return true;
                }
                for (class_1735 s : slots) {
                    if (s.field_7875 != j || s.field_7871 != ((AEBaseMenu)this.field_2797).getPlayerInventory()) continue;
                    NetworkHandler.instance().sendToServer(new SwapSlotsPacket(s.field_7874, theSlot.field_7874));
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean method_2387(class_1735 slot, double x, double y) {
        if (slot instanceof ResizableSlot) {
            ResizableSlot resizableSlot = (ResizableSlot)slot;
            int width = resizableSlot.getWidth();
            int height = resizableSlot.getHeight();
            return this.method_2378(slot.field_7873, slot.field_7872, width, height, x, y);
        }
        return super.method_2387(slot, x, y);
    }

    public void drawBG(class_4587 poseStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        if (this.style.getBackground() != null) {
            this.style.getBackground().dest(offsetX, offsetY).blit(poseStack, this.method_25305());
        }
    }

    public void drawItem(int x, int y, class_1799 is) {
        this.field_22788.field_4730 = 100.0f;
        this.field_22788.method_4023(is, x, y);
        this.field_22788.field_4730 = 0.0f;
    }

    protected class_2561 getGuiDisplayName(class_2561 in) {
        return this.field_22785.getString().isEmpty() ? in : this.field_22785;
    }

    public void method_2385(class_4587 poseStack, class_1735 s) {
        if (s instanceof AppEngSlot) {
            AppEngSlot appEngSlot = (AppEngSlot)s;
            try {
                this.renderAppEngSlot(poseStack, appEngSlot);
            }
            catch (Exception err) {
                AELog.warn("[AppEng] AE prevented crash while drawing slot: " + err, new Object[0]);
            }
        } else {
            super.method_2385(poseStack, s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderAppEngSlot(class_4587 poseStack, AppEngSlot s) {
        class_1799 is = s.method_7677();
        if ((s.renderIconWithItem() || is.method_7960()) && s.isSlotEnabled() && s.getIcon() != null) {
            s.getIcon().getBlitter().dest(s.field_7873, s.field_7872).opacity(s.getOpacityOfIcon()).blit(poseStack, this.method_25305());
        }
        if (!s.isValid()) {
            AEBaseScreen.method_25294((class_4587)poseStack, (int)s.field_7873, (int)s.field_7872, (int)(16 + s.field_7873), (int)(16 + s.field_7872), (int)0x66FF6666);
        }
        s.setRendering(true);
        try {
            super.method_2385(poseStack, (class_1735)s);
        }
        finally {
            s.setRendering(false);
        }
    }

    public void bindTexture(String file) {
        class_2960 loc = new class_2960("ae2", "textures/" + file);
        RenderSystem.setShaderTexture((int)0, (class_2960)loc);
    }

    public void method_37432() {
        super.method_37432();
        this.widgets.tick();
        for (class_364 child : this.method_25396()) {
            if (!(child instanceof ITickingWidget)) continue;
            ((ITickingWidget)child).tick();
        }
    }

    public boolean isHandlingRightClick() {
        return this.handlingRightClick;
    }

    protected final <B extends class_4185> B addToLeftToolbar(B button) {
        this.verticalToolbar.add(button);
        return button;
    }

    public List<class_768> getExclusionZones() {
        ArrayList<class_768> result = new ArrayList<class_768>(2);
        this.widgets.addExclusionZones(result, this.getBounds(true));
        return result;
    }

    protected void fillRect(class_4587 poseStack, class_768 rect, int color) {
        AEBaseScreen.method_25294((class_4587)poseStack, (int)rect.method_3321(), (int)rect.method_3322(), (int)(rect.method_3321() + rect.method_3319()), (int)(rect.method_3322() + rect.method_3320()), (int)color);
    }

    private TextOverride getOrCreateTextOverride(String id) {
        return this.textOverrides.computeIfAbsent(id, x -> new TextOverride());
    }

    protected final void setTextHidden(String id, boolean hidden) {
        this.getOrCreateTextOverride(id).setHidden(hidden);
    }

    protected final void setSlotsHidden(SlotSemantic semantic, boolean hidden) {
        if (hidden) {
            if (this.hiddenSlots.add(semantic)) {
                for (class_1735 slot : ((AEBaseMenu)this.field_2797).getSlots(semantic)) {
                    slot.field_7873 = HIDDEN_SLOT_POS.getX();
                    slot.field_7872 = HIDDEN_SLOT_POS.getY();
                }
            }
        } else if (this.hiddenSlots.remove(semantic) && this.style != null) {
            this.positionSlots(this.style);
        }
    }

    protected final void setTextContent(String id, class_2561 content) {
        this.getOrCreateTextOverride(id).setContent(content);
    }

    public ScreenStyle getStyle() {
        return this.style;
    }

    @Nullable
    public GenericStack getStackUnderMouse(double mouseX, double mouseY) {
        if (this.field_2787 != null) {
            class_1799 item = this.field_2787.method_7677();
            return GenericStack.unwrapItemStack(item);
        }
        return null;
    }

    public final int getGuiLeft() {
        return this.field_2776;
    }

    public final int getGuiTop() {
        return this.field_2800;
    }

    public final class_310 getMinecraft() {
        return this.field_22787;
    }

    public final class_1735 getSlotUnderMouse() {
        return this.field_2787;
    }

    public static boolean isSameInventory(class_1735 a, class_1735 b) {
        if (a instanceof AppEngSlot) {
            AppEngSlot appEngSlotA = (AppEngSlot)a;
            if (b instanceof AppEngSlot) {
                AppEngSlot appEngSlotB = (AppEngSlot)b;
                return appEngSlotA.field_7871 == appEngSlotB.field_7871;
            }
        }
        return a.field_7871 == b.field_7871;
    }

    public List<class_2561> method_25408(class_1799 stack) {
        GenericStack unwrapped = GenericStack.unwrapItemStack(stack);
        if (unwrapped != null) {
            return AEStackRendering.getTooltip(unwrapped.what());
        }
        return super.method_25408(stack);
    }

    public void renderCustomSlotHighlight(class_4587 poseStack, int x, int y, int z) {
        int h;
        int w;
        class_1735 class_17352 = this.field_2787;
        if (class_17352 instanceof ResizableSlot) {
            ResizableSlot resizableSlot = (ResizableSlot)class_17352;
            w = resizableSlot.getWidth();
            h = resizableSlot.getHeight();
        } else {
            w = 16;
            h = 16;
        }
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        AEBaseScreen.method_33284((class_4587)poseStack, (int)x, (int)y, (int)(x + w), (int)(y + h), (int)-2130706433, (int)-2130706433, (int)z);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }
}

