/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui;

import appeng.client.Point;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.Icon;
import appeng.client.gui.Tooltip;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.style.TooltipArea;
import appeng.client.gui.style.WidgetStyle;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.BackgroundPanel;
import appeng.client.gui.widgets.IResizableWidget;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.gui.widgets.TabButton;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.SwitchGuisPacket;
import appeng.menu.implementations.PriorityMenu;
import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_768;
import net.minecraft.class_918;

public class WidgetContainer {
    private final ScreenStyle style;
    private final Map<String, class_339> widgets = new LinkedHashMap<String, class_339>();
    private final Map<String, ICompositeWidget> compositeWidgets = new LinkedHashMap<String, ICompositeWidget>();
    private final Map<String, ResolvedTooltipArea> tooltips = new LinkedHashMap<String, ResolvedTooltipArea>();

    public WidgetContainer(ScreenStyle style) {
        this.style = style;
    }

    public void add(String id, class_339 widget) {
        int height;
        Preconditions.checkState((!this.compositeWidgets.containsKey(id) ? 1 : 0) != 0, (String)"%s already used for composite widget", (Object)id);
        WidgetStyle widgetStyle = this.style.getWidget(id);
        int width = widgetStyle.getWidth() != 0 ? widgetStyle.getWidth() : widget.method_25368();
        int n = height = widgetStyle.getHeight() != 0 ? widgetStyle.getHeight() : widget.method_25364();
        if (widget instanceof IResizableWidget) {
            IResizableWidget resizableWidget = (IResizableWidget)widget;
            resizableWidget.resize(width, height);
        } else {
            widget.method_25358(width);
            widget.field_22759 = height;
        }
        if (widget instanceof TabButton) {
            ((TabButton)widget).setHideEdge(widgetStyle.isHideEdge());
        }
        if (this.widgets.put(id, widget) != null) {
            throw new IllegalStateException("Duplicate id: " + id);
        }
    }

    public void add(String id, ICompositeWidget widget) {
        Preconditions.checkState((!this.widgets.containsKey(id) ? 1 : 0) != 0, (String)"%s already used for widget", (Object)id);
        WidgetStyle widgetStyle = this.style.getWidget(id);
        widget.setSize(widgetStyle.getWidth(), widgetStyle.getHeight());
        if (this.compositeWidgets.put(id, widget) != null) {
            throw new IllegalStateException("Duplicate id: " + id);
        }
    }

    public class_4185 addButton(String id, class_2561 text, class_4185.class_4241 action, class_4185.class_5316 tooltip) {
        class_4185 button = new class_4185(0, 0, 0, 0, text, action, tooltip);
        this.add(id, (class_339)button);
        return button;
    }

    public class_4185 addButton(String id, class_2561 text, class_4185.class_4241 action) {
        return this.addButton(id, text, action, class_4185.field_25035);
    }

    public class_4185 addButton(String id, class_2561 text, Runnable action, class_4185.class_5316 tooltip) {
        return this.addButton(id, text, btn -> action.run(), tooltip);
    }

    public class_4185 addButton(String id, class_2561 text, Runnable action) {
        return this.addButton(id, text, action, class_4185.field_25035);
    }

    public Scrollbar addScrollBar(String id) {
        Scrollbar scrollbar = new Scrollbar();
        this.add(id, scrollbar);
        return scrollbar;
    }

    public void addBackgroundPanel(String id) {
        Blitter background = this.style.getImage(id).copy();
        this.add(id, new BackgroundPanel(background));
    }

    void populateScreen(Consumer<class_339> addWidget, class_768 bounds, AEBaseScreen<?> screen) {
        for (Map.Entry<String, class_339> entry : this.widgets.entrySet()) {
            class_339 class_3392 = entry.getValue();
            if (class_3392.method_25370()) {
                class_3392.method_25407(false);
            }
            WidgetStyle widgetStyle = this.style.getWidget(entry.getKey());
            Point pos = widgetStyle.resolve(bounds);
            if (class_3392 instanceof IResizableWidget) {
                IResizableWidget resizableWidget = (IResizableWidget)class_3392;
                resizableWidget.move(pos);
            } else {
                class_3392.field_22760 = pos.getX();
                class_3392.field_22761 = pos.getY();
            }
            addWidget.accept(class_3392);
        }
        class_768 relativeBounds = new class_768(0, 0, bounds.method_3319(), bounds.method_3320());
        for (Map.Entry<String, ICompositeWidget> entry : this.compositeWidgets.entrySet()) {
            ICompositeWidget widget = entry.getValue();
            WidgetStyle widgetStyle = this.style.getWidget(entry.getKey());
            widget.setPosition(widgetStyle.resolve(relativeBounds));
            widget.populateScreen(addWidget, bounds, screen);
        }
        this.tooltips.clear();
        for (Map.Entry<String, Object> entry : this.style.getTooltips().entrySet()) {
            Point pos = ((TooltipArea)entry.getValue()).resolve(relativeBounds);
            class_768 area = new class_768(pos.getX(), pos.getY(), ((TooltipArea)entry.getValue()).getWidth(), ((TooltipArea)entry.getValue()).getHeight());
            this.tooltips.put(entry.getKey(), new ResolvedTooltipArea(area, new Tooltip(((TooltipArea)entry.getValue()).getTooltip())));
        }
    }

    public void tick() {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            widget.tick();
        }
    }

    public void updateBeforeRender() {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            widget.updateBeforeRender();
        }
    }

    public void drawBackgroundLayer(class_4587 poseStack, int zIndex, class_768 bounds, Point mouse) {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            widget.drawBackgroundLayer(poseStack, zIndex, bounds, mouse);
        }
    }

    public void drawForegroundLayer(class_4587 poseStack, int zIndex, class_768 bounds, Point mouse) {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            widget.drawForegroundLayer(poseStack, zIndex, bounds, mouse);
        }
    }

    public boolean onMouseDown(Point mousePos, int btn) {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            if (!widget.wantsAllMouseDownEvents() && !mousePos.isIn(widget.getBounds()) || !widget.onMouseDown(mousePos, btn)) continue;
            return true;
        }
        return false;
    }

    public boolean onMouseUp(Point mousePos, int btn) {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            if (!widget.wantsAllMouseUpEvents() && !mousePos.isIn(widget.getBounds()) || !widget.onMouseUp(mousePos, btn)) continue;
            return true;
        }
        return false;
    }

    public boolean onMouseDrag(Point mousePos, int btn) {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            if (!widget.onMouseDrag(mousePos, btn)) continue;
            return true;
        }
        return false;
    }

    boolean onMouseWheel(Point mousePos, double wheelDelta) {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            if (!widget.wantsAllMouseWheelEvents() && !mousePos.isIn(widget.getBounds()) || !widget.onMouseWheel(mousePos, wheelDelta)) continue;
            return true;
        }
        return false;
    }

    public void addExclusionZones(List<class_768> exclusionZones, class_768 bounds) {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            widget.addExclusionZones(exclusionZones, bounds);
        }
    }

    public void addOpenPriorityButton() {
        class_918 itemRenderer = class_310.method_1551().method_1480();
        this.add("openPriority", (class_339)new TabButton(Icon.WRENCH, (class_2561)GuiText.Priority.text(), itemRenderer, btn -> this.openPriorityGui()));
    }

    private void openPriorityGui() {
        NetworkHandler.instance().sendToServer(SwitchGuisPacket.openSubMenu(PriorityMenu.TYPE));
    }

    public void setTooltipAreaEnabled(String id, boolean enabled) {
        ResolvedTooltipArea tooltip = this.tooltips.get(id);
        Preconditions.checkArgument((tooltip != null ? 1 : 0) != 0, (Object)"No tooltip with id '%s' is defined");
        tooltip.enabled = enabled;
    }

    @Nullable
    public Tooltip getTooltip(int mouseX, int mouseY) {
        for (ICompositeWidget c : this.compositeWidgets.values()) {
            Tooltip tooltip;
            class_768 bounds = c.getBounds();
            if (mouseX < bounds.method_3321() || mouseX >= bounds.method_3321() + bounds.method_3319() || mouseY < bounds.method_3322() || mouseY >= bounds.method_3322() + bounds.method_3320() || (tooltip = c.getTooltip(mouseX, mouseY)) == null) continue;
            return tooltip;
        }
        for (ResolvedTooltipArea tooltipArea : this.tooltips.values()) {
            if (!tooltipArea.enabled || !WidgetContainer.contains(tooltipArea.area, mouseX, mouseY)) continue;
            return tooltipArea.tooltip;
        }
        return null;
    }

    public boolean hitTest(Point mousePos) {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            if (!mousePos.isIn(widget.getBounds())) continue;
            return true;
        }
        return false;
    }

    private static boolean contains(class_768 area, int mouseX, int mouseY) {
        return mouseX >= area.method_3321() && mouseX < area.method_3321() + area.method_3319() && mouseY >= area.method_3322() && mouseY < area.method_3322() + area.method_3320();
    }

    public AETextField addTextField(String id) {
        AETextField searchField = new AETextField(class_310.method_1551().field_1772, 0, 0, 0, 0);
        searchField.method_1858(false);
        searchField.method_1880(25);
        searchField.method_1868(0xFFFFFF);
        searchField.setSelectionColor(-16744448);
        searchField.method_1862(true);
        this.add(id, (class_339)searchField);
        return searchField;
    }

    private static class ResolvedTooltipArea {
        private final class_768 area;
        private final Tooltip tooltip;
        private boolean enabled = true;

        public ResolvedTooltipArea(class_768 area, Tooltip tooltip) {
            this.area = area;
            this.tooltip = tooltip;
        }
    }
}

