/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.crafting;

import appeng.api.stacks.GenericStack;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.NumberEntryType;
import appeng.client.gui.implementations.AESubScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.NumberEntryWidget;
import appeng.core.localization.GuiText;
import appeng.menu.me.crafting.CraftAmountMenu;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_4185;

public class CraftAmountScreen
extends AEBaseScreen<CraftAmountMenu> {
    private final class_4185 next;
    private final NumberEntryWidget amountToCraft;
    private boolean amountInitialized;

    public CraftAmountScreen(CraftAmountMenu menu, class_1661 playerInventory, class_2561 title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        this.next = this.widgets.addButton("next", (class_2561)GuiText.Next.text(), this::confirm);
        AESubScreen.addBackButton(menu, "back", this.widgets);
        this.amountToCraft = new NumberEntryWidget(NumberEntryType.UNITLESS);
        this.amountToCraft.setMinValue(1L);
        this.amountToCraft.setMaxValue(Integer.MAX_VALUE);
        this.amountToCraft.setLongValue(1L);
        this.amountToCraft.setTextFieldStyle(style.getWidget("amountToCraftInput"));
        this.amountToCraft.setHideValidationIcon(true);
        this.amountToCraft.setOnConfirm(this::confirm);
        this.widgets.add("amountToCraft", this.amountToCraft);
    }

    @Override
    protected void updateBeforeRender() {
        GenericStack whatToCraft;
        super.updateBeforeRender();
        if (!this.amountInitialized && (whatToCraft = ((CraftAmountMenu)this.field_2797).getWhatToCraft()) != null) {
            this.amountToCraft.setType(NumberEntryType.of(whatToCraft.what()));
            this.amountToCraft.setLongValue(whatToCraft.amount());
            this.amountInitialized = true;
        }
        this.next.method_25355((class_2561)(CraftAmountScreen.method_25442() ? GuiText.Start.text() : GuiText.Next.text()));
        this.next.field_22763 = this.amountToCraft.getIntValue().orElse(0) > 0;
    }

    private void confirm() {
        int amount = this.amountToCraft.getIntValue().orElse(0);
        if (amount <= 0) {
            return;
        }
        ((CraftAmountMenu)this.field_2797).confirm(amount, CraftAmountScreen.method_25442());
    }
}

