/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.items;

import appeng.api.config.ActionItems;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.me.common.MEStorageScreen;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.TabButton;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PatternSlotPacket;
import appeng.menu.SlotSemantics;
import appeng.menu.me.interaction.EmptyingAction;
import appeng.menu.me.interaction.StackInteractions;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.menu.slot.PatternTermSlot;
import appeng.parts.encoding.EncodingMode;
import java.util.ArrayList;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_4587;

public class PatternEncodingTermScreen<C extends PatternEncodingTermMenu>
extends MEStorageScreen<C> {
    private static final String MODES_TEXTURE = "guis/pattern_modes.png";
    private static final Blitter CRAFTING_MODE_BG = Blitter.texture("guis/pattern_modes.png").src(0, 0, 126, 68);
    private static final Blitter PROCESSING_MODE_BG = Blitter.texture("guis/pattern_modes.png").src(0, 70, 126, 68);
    private final TabButton tabCraftButton;
    private final TabButton tabProcessButton;
    private final ActionButton substitutionsEnabledBtn;
    private final ActionButton substitutionsDisabledBtn;
    private final ActionButton fluidSubstitutionsEnabledBtn;
    private final ActionButton fluidSubstitutionsDisabledBtn;
    private final ActionButton cycleProcessingOutputBtn;

    public PatternEncodingTermScreen(C menu, class_1661 playerInventory, class_2561 title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        ActionButton clearBtn = new ActionButton(ActionItems.CLOSE, act -> menu.clear());
        clearBtn.setHalfSize(true);
        this.widgets.add("clearPattern", (class_339)clearBtn);
        this.substitutionsEnabledBtn = new ActionButton(ActionItems.ENABLE_SUBSTITUTION, act -> ((PatternEncodingTermMenu)this.method_17577()).setSubstitute(false));
        this.substitutionsEnabledBtn.setHalfSize(true);
        this.widgets.add("substitutionsEnabled", (class_339)this.substitutionsEnabledBtn);
        this.substitutionsDisabledBtn = new ActionButton(ActionItems.DISABLE_SUBSTITUTION, act -> ((PatternEncodingTermMenu)this.method_17577()).setSubstitute(true));
        this.substitutionsDisabledBtn.setHalfSize(true);
        this.widgets.add("substitutionsDisabled", (class_339)this.substitutionsDisabledBtn);
        this.fluidSubstitutionsEnabledBtn = new ActionButton(ActionItems.ENABLE_FLUID_SUBSTITUTION, act -> ((PatternEncodingTermMenu)this.method_17577()).setSubstituteFluids(false));
        this.fluidSubstitutionsEnabledBtn.setHalfSize(true);
        this.widgets.add("fluidSubstitutionsEnabled", (class_339)this.fluidSubstitutionsEnabledBtn);
        this.fluidSubstitutionsDisabledBtn = new ActionButton(ActionItems.DISABLE_FLUID_SUBSTITUTION, act -> ((PatternEncodingTermMenu)this.method_17577()).setSubstituteFluids(true));
        this.fluidSubstitutionsDisabledBtn.setHalfSize(true);
        this.widgets.add("fluidSubstitutionsDisabled", (class_339)this.fluidSubstitutionsDisabledBtn);
        this.cycleProcessingOutputBtn = new ActionButton(ActionItems.CYCLE_PROCESSING_OUTPUT, act -> ((PatternEncodingTermMenu)this.method_17577()).cycleProcessingOutput());
        this.cycleProcessingOutputBtn.setHalfSize(true);
        this.widgets.add("cycleProcessingOutput", (class_339)this.cycleProcessingOutputBtn);
        ActionButton encodeBtn = new ActionButton(ActionItems.ENCODE, act -> menu.encode());
        this.widgets.add("encodePattern", (class_339)encodeBtn);
        this.tabCraftButton = new TabButton(new class_1799((class_1935)class_2246.field_9980), (class_2561)GuiText.CraftingPattern.text(), this.field_22788, btn -> ((PatternEncodingTermMenu)this.method_17577()).setMode(EncodingMode.PROCESSING));
        this.widgets.add("craftingPatternMode", (class_339)this.tabCraftButton);
        this.tabProcessButton = new TabButton(new class_1799((class_1935)class_2246.field_10181), (class_2561)GuiText.ProcessingPattern.text(), this.field_22788, btn -> ((PatternEncodingTermMenu)this.method_17577()).setMode(EncodingMode.CRAFTING));
        this.widgets.add("processingPatternMode", (class_339)this.tabProcessButton);
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        EncodingMode mode = ((PatternEncodingTermMenu)this.field_2797).getMode();
        if (mode == EncodingMode.CRAFTING) {
            this.tabCraftButton.field_22764 = true;
            this.tabProcessButton.field_22764 = false;
            if (((PatternEncodingTermMenu)this.field_2797).substitute) {
                this.substitutionsEnabledBtn.field_22764 = true;
                this.substitutionsDisabledBtn.field_22764 = false;
            } else {
                this.substitutionsEnabledBtn.field_22764 = false;
                this.substitutionsDisabledBtn.field_22764 = true;
            }
            if (((PatternEncodingTermMenu)this.field_2797).substituteFluids) {
                this.fluidSubstitutionsEnabledBtn.field_22764 = true;
                this.fluidSubstitutionsDisabledBtn.field_22764 = false;
            } else {
                this.fluidSubstitutionsEnabledBtn.field_22764 = false;
                this.fluidSubstitutionsDisabledBtn.field_22764 = true;
            }
        } else {
            this.tabCraftButton.field_22764 = false;
            this.tabProcessButton.field_22764 = true;
            this.substitutionsEnabledBtn.field_22764 = false;
            this.substitutionsDisabledBtn.field_22764 = false;
            this.fluidSubstitutionsEnabledBtn.field_22764 = false;
            this.fluidSubstitutionsDisabledBtn.field_22764 = false;
        }
        this.cycleProcessingOutputBtn.field_22764 = ((PatternEncodingTermMenu)this.field_2797).canCycleProcessingOutputs();
        this.setSlotsHidden(SlotSemantics.CRAFTING_RESULT, mode != EncodingMode.CRAFTING);
        this.setSlotsHidden(SlotSemantics.PROCESSING_PRIMARY_RESULT, mode != EncodingMode.PROCESSING);
        this.setSlotsHidden(SlotSemantics.PROCESSING_FIRST_OPTIONAL_RESULT, mode != EncodingMode.PROCESSING);
        this.setSlotsHidden(SlotSemantics.PROCESSING_SECOND_OPTIONAL_RESULT, mode != EncodingMode.PROCESSING);
        this.widgets.setTooltipAreaEnabled("processing-primary-output", mode == EncodingMode.PROCESSING);
        this.widgets.setTooltipAreaEnabled("processing-optional-output1", mode == EncodingMode.PROCESSING);
        this.widgets.setTooltipAreaEnabled("processing-optional-output2", mode == EncodingMode.PROCESSING);
    }

    @Override
    public void drawBG(class_4587 poseStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        super.drawBG(poseStack, offsetX, offsetY, mouseX, mouseY, partialTicks);
        EncodingMode mode = ((PatternEncodingTermMenu)this.field_2797).getMode();
        Blitter modeBg = mode == EncodingMode.CRAFTING ? CRAFTING_MODE_BG : PROCESSING_MODE_BG;
        modeBg.dest(this.field_2776 + 9, this.field_2800 + this.field_2779 - 164).blit(poseStack, this.method_25305());
        if (mode == EncodingMode.CRAFTING && ((PatternEncodingTermMenu)this.field_2797).substituteFluids && this.fluidSubstitutionsEnabledBtn.method_25405(mouseX, mouseY)) {
            for (Integer slotIndex : ((PatternEncodingTermMenu)this.field_2797).slotsSupportingFluidSubstitution) {
                this.drawSlotGreenBG(poseStack, ((PatternEncodingTermMenu)this.field_2797).getCraftingGridSlots()[slotIndex]);
            }
        }
    }

    private void drawSlotGreenBG(class_4587 poseStack, class_1735 slot) {
        int x = this.getGuiLeft() + slot.field_7873;
        int y = this.getGuiTop() + slot.field_7872;
        PatternEncodingTermScreen.method_25294((class_4587)poseStack, (int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)0x7F00FF00);
    }

    @Override
    public boolean method_25402(double xCoord, double yCoord, int btn) {
        class_1735 slot;
        if (this.field_22787.field_1690.field_1871.method_1433(btn) && ((PatternEncodingTermMenu)this.field_2797).canModifyAmountForSlot(slot = this.method_2386(xCoord, yCoord))) {
            ((PatternEncodingTermMenu)this.field_2797).showModifyAmountMenu(slot.field_7874);
            return true;
        }
        return super.method_25402(xCoord, yCoord, btn);
    }

    @Override
    protected void method_2383(class_1735 slot, int slotIdx, int mouseButton, class_1713 clickType) {
        if (slot instanceof PatternTermSlot) {
            if (!slot.method_7677().method_7960()) {
                PatternSlotPacket packet = new PatternSlotPacket(((PatternEncodingTermMenu)this.field_2797).getCraftingMatrix(), slot.method_7677(), PatternEncodingTermScreen.method_25442());
                NetworkHandler.instance().sendToServer(packet);
            }
            return;
        }
        super.method_2383(slot, slotIdx, mouseButton, clickType);
    }

    @Override
    protected void method_2380(class_4587 poseStack, int x, int y) {
        if (((PatternEncodingTermMenu)this.field_2797).method_34255().method_7960() && ((PatternEncodingTermMenu)this.field_2797).canModifyAmountForSlot(this.field_2787)) {
            ArrayList<class_2561> itemTooltip = new ArrayList<class_2561>(this.method_25408(this.field_2787.method_7677()));
            GenericStack unwrapped = GenericStack.fromItemStack(this.field_2787.method_7677());
            if (unwrapped != null) {
                itemTooltip.add(Tooltips.getAmountTooltip(ButtonToolTips.Amount, unwrapped));
            }
            itemTooltip.add(Tooltips.getSetAmountTooltip());
            this.drawTooltip(poseStack, x, y, itemTooltip);
        } else {
            super.method_2380(poseStack, x, y);
        }
    }

    @Override
    protected EmptyingAction getEmptyingAction(class_1735 slot, class_1799 carried) {
        EmptyingAction emptyingAction;
        if (((PatternEncodingTermMenu)this.field_2797).isProcessingPatternSlot(slot) && (emptyingAction = StackInteractions.getEmptyingAction(carried)) != null) {
            return emptyingAction;
        }
        return super.getEmptyingAction(slot, carried);
    }
}

