/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.Point;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.NumberEntryType;
import appeng.client.gui.Rects;
import appeng.client.gui.style.WidgetStyle;
import appeng.client.gui.widgets.ConfirmableTextField;
import appeng.client.gui.widgets.ValidationIcon;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_768;

public class NumberEntryWidget
extends class_332
implements ICompositeWidget {
    private static final long[] STEPS = new long[]{1L, 10L, 100L, 1000L};
    private static final class_2561 INVALID_NUMBER = new class_2588("gui.ae2.validation.InvalidNumber");
    private static final String NUMBER_LESS_THAN_MIN_VALUE = "gui.ae2.validation.NumberLessThanMinValue";
    private static final String NUMBER_GREATER_THAN_MAX_VALUE = "gui.ae2.validation.NumberGreaterThanMaxValue";
    private static final class_2561 PLUS = new class_2585("+");
    private static final class_2561 MINUS = new class_2585("-");
    private static final int TEXT_COLOR_ERROR = 16718080;
    private static final int TEXT_COLOR_NORMAL = 0xFFFFFF;
    private final ConfirmableTextField textField;
    private final DecimalFormat decimalFormat;
    private NumberEntryType type;
    private List<class_4185> buttons;
    private long minValue;
    private long maxValue = Long.MAX_VALUE;
    private ValidationIcon validationIcon;
    private Runnable onChange;
    private Runnable onConfirm;
    private boolean hideValidationIcon;
    private class_768 bounds = new class_768(0, 0, 0, 0);
    private class_768 textFieldBounds = Rects.ZERO;

    public NumberEntryWidget(NumberEntryType type) {
        this.type = Objects.requireNonNull(type, "type");
        this.decimalFormat = new DecimalFormat("#.####", new DecimalFormatSymbols());
        this.decimalFormat.setParseBigDecimal(true);
        this.decimalFormat.setNegativePrefix("-");
        class_327 font = class_310.method_1551().field_1772;
        Objects.requireNonNull(font);
        this.textField = new ConfirmableTextField(font, 0, 0, 0, 9);
        this.textField.method_1858(false);
        this.textField.method_1880(16);
        this.textField.method_1868(0xFFFFFF);
        this.textField.method_1862(true);
        this.textField.method_1876(true);
        this.textField.method_1863(text -> {
            this.validate();
            if (this.onChange != null) {
                this.onChange.run();
            }
        });
        this.textField.setOnConfirm(() -> {
            if (this.onConfirm != null && this.getLongValue().isPresent()) {
                this.onConfirm.run();
            }
        });
        this.validate();
    }

    public void setOnConfirm(Runnable callback) {
        this.onConfirm = callback;
    }

    public void setOnChange(Runnable callback) {
        this.onChange = callback;
    }

    public void setActive(boolean active) {
        this.textField.method_1888(active);
        this.buttons.forEach(b -> {
            b.field_22763 = active;
        });
    }

    public void setTextFieldBounds(class_768 bounds) {
        this.textFieldBounds = bounds;
        this.textField.move(Point.fromTopLeft(bounds));
        this.textField.resize(bounds.method_3319(), bounds.method_3320());
    }

    public void setTextFieldStyle(WidgetStyle style) {
        int left = 0;
        if (style.getLeft() != null) {
            left = style.getLeft();
        }
        int top = 0;
        if (style.getTop() != null) {
            top = style.getTop();
        }
        this.setTextFieldBounds(new class_768(left, top, style.getWidth(), style.getHeight()));
    }

    public void setMinValue(long minValue) {
        this.minValue = minValue;
        this.validate();
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = maxValue;
        this.validate();
    }

    @Override
    public void setPosition(Point position) {
        this.bounds = new class_768(position.getX(), position.getY(), this.bounds.method_3319(), this.bounds.method_3320());
    }

    @Override
    public void setSize(int width, int height) {
        this.bounds = new class_768(this.bounds.method_3321(), this.bounds.method_3322(), width, height);
    }

    @Override
    public class_768 getBounds() {
        return this.bounds;
    }

    @Override
    public void populateScreen(Consumer<class_339> addWidget, class_768 bounds, AEBaseScreen<?> screen) {
        int left = bounds.method_3321() + this.bounds.method_3321();
        int top = bounds.method_3322() + this.bounds.method_3322();
        ArrayList<class_4185> buttons = new ArrayList<class_4185>(9);
        buttons.add(new class_4185(left, top, 22, 20, this.makeLabel(PLUS, STEPS[0]), btn -> this.addQty(STEPS[0])));
        buttons.add(new class_4185(left + 28, top, 28, 20, this.makeLabel(PLUS, STEPS[1]), btn -> this.addQty(STEPS[1])));
        buttons.add(new class_4185(left + 62, top, 32, 20, this.makeLabel(PLUS, STEPS[2]), btn -> this.addQty(STEPS[2])));
        buttons.add(new class_4185(left + 100, top, 38, 20, this.makeLabel(PLUS, STEPS[3]), btn -> this.addQty(STEPS[3])));
        buttons.forEach(addWidget);
        class_768 textFieldBounds = Rects.move(this.textFieldBounds, bounds.method_3321(), bounds.method_3322());
        this.textField.move(Point.fromTopLeft(textFieldBounds));
        this.textField.resize(textFieldBounds.method_3319(), textFieldBounds.method_3320());
        screen.method_20085((class_364)this.textField);
        addWidget.accept((class_339)this.textField);
        buttons.add(new class_4185(left, top + 42, 22, 20, this.makeLabel(MINUS, STEPS[0]), btn -> this.addQty(-STEPS[0])));
        buttons.add(new class_4185(left + 28, top + 42, 28, 20, this.makeLabel(MINUS, STEPS[1]), btn -> this.addQty(-STEPS[1])));
        buttons.add(new class_4185(left + 62, top + 42, 32, 20, this.makeLabel(MINUS, STEPS[2]), btn -> this.addQty(-STEPS[2])));
        buttons.add(new class_4185(left + 100, top + 42, 38, 20, this.makeLabel(MINUS, STEPS[3]), btn -> this.addQty(-STEPS[3])));
        if (!this.hideValidationIcon) {
            this.validationIcon = new ValidationIcon();
            this.validationIcon.field_22760 = left + 104;
            this.validationIcon.field_22761 = top + 27;
            buttons.add(this.validationIcon);
        }
        buttons.subList(4, buttons.size()).forEach(addWidget);
        this.buttons = buttons;
        this.validate();
        screen.method_25407(true);
    }

    public OptionalInt getIntValue() {
        OptionalLong value = this.getLongValue();
        if (value.isPresent()) {
            long longValue = value.getAsLong();
            if (longValue > Integer.MAX_VALUE) {
                return OptionalInt.empty();
            }
            return OptionalInt.of((int)longValue);
        }
        return OptionalInt.empty();
    }

    public OptionalLong getLongValue() {
        Optional<BigDecimal> internalValue = this.getValueInternal();
        if (internalValue.isEmpty()) {
            return OptionalLong.empty();
        }
        long externalValue = this.convertToExternalValue(internalValue.get());
        if (externalValue < this.minValue) {
            return OptionalLong.empty();
        }
        if (externalValue > this.maxValue) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(externalValue);
    }

    public void setLongValue(long value) {
        BigDecimal internalValue = this.convertToInternalValue(class_3532.method_24156((long)value, (long)this.minValue, (long)this.maxValue));
        this.textField.method_1852(this.decimalFormat.format(internalValue));
        this.textField.method_1872();
        this.textField.method_1884(0);
        this.validate();
    }

    private void addQty(long delta) {
        BigDecimal currentValue = this.getValueInternal().orElse(BigDecimal.ZERO);
        this.setValueInternal(currentValue.add(BigDecimal.valueOf(delta)));
    }

    private Optional<BigDecimal> getValueInternal() {
        ParsePosition position = new ParsePosition(0);
        String textValue = this.textField.method_1882().trim();
        BigDecimal decimal = (BigDecimal)this.decimalFormat.parse(textValue, position);
        if (position.getErrorIndex() != -1 || position.getIndex() != textValue.length()) {
            return Optional.empty();
        }
        return Optional.ofNullable(decimal);
    }

    private void setValueInternal(BigDecimal value) {
        this.textField.method_1852(this.decimalFormat.format(value));
    }

    private void validate() {
        ArrayList<class_2561> validationErrors = new ArrayList<class_2561>();
        Optional<BigDecimal> possibleValue = this.getValueInternal();
        if (possibleValue.isPresent()) {
            if (this.type.amountPerUnit() == 1 && possibleValue.get().scale() > 0) {
                validationErrors.add((class_2561)new class_2585("Must be whole number"));
            } else {
                long value = this.convertToExternalValue(possibleValue.get());
                if (value < this.minValue) {
                    String formatted = this.decimalFormat.format(this.convertToInternalValue(this.minValue));
                    validationErrors.add((class_2561)new class_2588(NUMBER_LESS_THAN_MIN_VALUE, new Object[]{formatted}));
                } else if (value > this.maxValue) {
                    String formatted = this.decimalFormat.format(this.convertToInternalValue(this.maxValue));
                    validationErrors.add((class_2561)new class_2588(NUMBER_GREATER_THAN_MAX_VALUE, new Object[]{formatted}));
                }
            }
        } else {
            validationErrors.add(INVALID_NUMBER);
        }
        boolean valid = validationErrors.isEmpty();
        this.textField.method_1868(valid ? 0xFFFFFF : 16718080);
        this.textField.setTooltipMessage(validationErrors);
        if (this.validationIcon != null) {
            this.validationIcon.setValid(valid);
            this.validationIcon.setTooltip(validationErrors);
        }
    }

    private class_2561 makeLabel(class_2561 prefix, long amount) {
        return prefix.method_27662().method_27693(this.decimalFormat.format(amount));
    }

    public void setHideValidationIcon(boolean hideValidationIcon) {
        this.hideValidationIcon = hideValidationIcon;
    }

    public NumberEntryType getType() {
        return this.type;
    }

    public void setType(NumberEntryType type) {
        if (this.type == type) {
            return;
        }
        this.type = type;
        if (this.onChange != null) {
            this.onChange.run();
        }
        this.validate();
    }

    private long convertToExternalValue(BigDecimal internalValue) {
        BigDecimal multiplicand = BigDecimal.valueOf(this.type.amountPerUnit());
        BigDecimal value = internalValue.multiply(multiplicand, MathContext.DECIMAL128);
        value = value.setScale(0, RoundingMode.UP);
        return value.longValue();
    }

    private BigDecimal convertToInternalValue(long externalValue) {
        BigDecimal divisor = BigDecimal.valueOf(this.type.amountPerUnit());
        return BigDecimal.valueOf(externalValue).divide(divisor, MathContext.DECIMAL128);
    }

    @Override
    public void drawBackgroundLayer(class_4587 poseStack, int zIndex, class_768 bounds, Point mouse) {
        if (this.type.unit() != null) {
            class_327 font = class_310.method_1551().field_1772;
            String string = this.type.unit();
            float f = bounds.method_3321() + this.textFieldBounds.method_3321() + this.textFieldBounds.method_3319() + 3;
            float f2 = bounds.method_3322() + this.textFieldBounds.method_3322();
            int n = this.textFieldBounds.method_3320();
            Objects.requireNonNull(font);
            font.method_1729(poseStack, string, f, f2 + (float)(n - 9) / 2.0f + 1.0f, class_124.field_1063.method_532().intValue());
        }
    }

    @Override
    public boolean onMouseWheel(Point mousePos, double delta) {
        if (this.textFieldBounds.method_3318(mousePos.getX(), mousePos.getY())) {
            if (delta < 0.0) {
                BigDecimal minValueInternal = this.convertToInternalValue(this.minValue);
                if (this.getValueInternal().orElse(minValueInternal).subtract(BigDecimal.ONE).compareTo(minValueInternal) >= 0) {
                    this.addQty(-1L);
                } else {
                    this.setValueInternal(minValueInternal);
                }
            } else if (delta > 0.0) {
                BigDecimal maxValueInternal = this.convertToInternalValue(this.maxValue);
                if (this.getValueInternal().orElse(maxValueInternal).add(BigDecimal.ONE).compareTo(maxValueInternal) <= 0) {
                    this.addQty(1L);
                } else {
                    this.setValueInternal(maxValueInternal);
                }
            }
            return true;
        }
        return false;
    }
}

