/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.gui.style.Blitter;
import appeng.client.gui.widgets.ITooltip;
import appeng.core.localization.GuiText;
import appeng.menu.interfaces.IProgressProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_339;
import net.minecraft.class_4587;
import net.minecraft.class_6382;
import net.minecraft.class_768;

public class ProgressBar
extends class_339
implements ITooltip {
    private final IProgressProvider source;
    private final Blitter blitter;
    private final Direction layout;
    private final class_768 sourceRect;
    private final class_2561 titleName;
    private class_2561 fullMsg;

    public ProgressBar(IProgressProvider source, Blitter blitter, Direction dir) {
        this(source, blitter, dir, null);
    }

    public ProgressBar(IProgressProvider source, Blitter blitter, Direction dir, class_2561 title) {
        super(0, 0, blitter.getSrcWidth(), blitter.getSrcHeight(), class_2585.field_24366);
        this.source = source;
        this.blitter = blitter.copy();
        this.layout = dir;
        this.titleName = title;
        this.sourceRect = new class_768(blitter.getSrcX(), blitter.getSrcY(), blitter.getSrcWidth(), blitter.getSrcHeight());
    }

    public void method_25359(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.field_22764) {
            int max = this.source.getMaxProgress();
            int current = this.source.getCurrentProgress();
            int srcX = this.sourceRect.method_3321();
            int srcY = this.sourceRect.method_3322();
            int srcW = this.sourceRect.method_3319();
            int srcH = this.sourceRect.method_3320();
            int destX = this.field_22760;
            int destY = this.field_22761;
            if (this.layout == Direction.VERTICAL) {
                int diff = this.field_22759 - (max > 0 ? this.field_22759 * current / max : 0);
                destY += diff;
                srcY += diff;
                srcH -= diff;
            } else {
                int diff = this.field_22758 - (max > 0 ? this.field_22758 * current / max : 0);
                srcX += diff;
                srcW -= diff;
            }
            this.blitter.src(srcX, srcY, srcW, srcH).dest(destX, destY).blit(poseStack, this.method_25305());
        }
    }

    public void setFullMsg(class_2561 msg) {
        this.fullMsg = msg;
    }

    @Override
    public List<class_2561> getTooltipMessage() {
        if (this.fullMsg != null) {
            return Collections.singletonList(this.fullMsg);
        }
        class_2561 result = this.titleName != null ? this.titleName : class_2585.field_24366;
        return Arrays.asList(result, new class_2585(this.source.getCurrentProgress() + " ").method_10852((class_2561)GuiText.Of.text().method_27661().method_27693(" " + this.source.getMaxProgress())));
    }

    @Override
    public class_768 getTooltipArea() {
        return new class_768(this.field_22760 - 2, this.field_22761 - 2, this.field_22758 + 4, this.field_22759 + 4);
    }

    @Override
    public boolean isTooltipAreaVisible() {
        return true;
    }

    public void method_37020(class_6382 output) {
    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }
}

