/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.overlay;

import appeng.api.util.DimensionalBlockPos;
import appeng.client.render.overlay.IOverlayDataSource;
import appeng.client.render.overlay.OverlayRenderer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public class OverlayManager {
    private static final OverlayManager INSTANCE = new OverlayManager();
    private final Map<DimensionalBlockPos, OverlayRenderer> overlayHandlers = new HashMap<DimensionalBlockPos, OverlayRenderer>();

    public static OverlayManager getInstance() {
        return INSTANCE;
    }

    private OverlayManager() {
    }

    public void renderWorldLastEvent(WorldRenderContext context) {
        class_310 minecraft = class_310.method_1551();
        class_4597.class_4598 buffer = minecraft.method_22940().method_23000();
        class_4587 poseStack = context.matrixStack();
        poseStack.method_22903();
        class_243 projectedView = minecraft.field_1773.method_19418().method_19326();
        poseStack.method_22904(-projectedView.field_1352, -projectedView.field_1351, -projectedView.field_1350);
        for (OverlayRenderer handler : this.overlayHandlers.entrySet().stream().filter(e -> ((DimensionalBlockPos)e.getKey()).getLevel() == minecraft.field_1687).map(Map.Entry::getValue).collect(Collectors.toList())) {
            handler.render(poseStack, (class_4597)buffer);
        }
        poseStack.method_22909();
    }

    public OverlayRenderer showArea(IOverlayDataSource source) {
        Objects.requireNonNull(source);
        OverlayRenderer handler = new OverlayRenderer(source);
        this.overlayHandlers.put(source.getOverlaySourceLocation(), handler);
        return handler;
    }

    public boolean isShowing(IOverlayDataSource source) {
        return this.overlayHandlers.containsKey(source.getOverlaySourceLocation());
    }

    public void removeHandlers(IOverlayDataSource source) {
        this.overlayHandlers.remove(source.getOverlaySourceLocation());
    }
}

