/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.network;

import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.sync.BasePacket;
import appeng.core.sync.BasePacketHandler;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.network.NetworkHandlerHolder;
import appeng.core.sync.network.TargetPoint;
import net.fabricmc.fabric.api.network.PacketContext;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.fabricmc.fabric.api.server.PlayerStream;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ServerNetworkHandler
implements NetworkHandler {
    private final ServerSidePacketRegistry registry = ServerSidePacketRegistry.INSTANCE;

    public ServerNetworkHandler() {
        NetworkHandlerHolder.INSTANCE = this;
        this.registry.register(BasePacket.CHANNEL, this::handlePacketFromClient);
    }

    @Override
    public void sendToAll(BasePacket message) {
        MinecraftServer server = AppEng.instance().getCurrentServer();
        if (server != null) {
            class_2596<?> packet = message.toPacket(class_2598.field_11942);
            PlayerStream.all((MinecraftServer)server).forEach(player -> this.registry.sendToPlayer((class_1657)player, packet));
        }
    }

    @Override
    public void sendTo(BasePacket message, class_3222 player) {
        class_2596<?> packet = message.toPacket(class_2598.field_11942);
        this.registry.sendToPlayer((class_1657)player, packet);
    }

    @Override
    public void sendToAllAround(BasePacket message, TargetPoint point) {
        class_2596<?> packet = message.toPacket(class_2598.field_11942);
        PlayerStream.around((class_1937)point.level, (class_243)new class_243(point.x, point.y, point.z), (double)point.radius).forEach(player -> {
            if (player != point.excluded) {
                ServerSidePacketRegistry.INSTANCE.sendToPlayer(player, packet);
            }
        });
    }

    @Override
    public void sendToDimension(BasePacket message, class_1937 world) {
        class_2596<?> packet = message.toPacket(class_2598.field_11942);
        PlayerStream.world((class_1937)world).forEach(player -> ServerSidePacketRegistry.INSTANCE.sendToPlayer(player, packet));
    }

    @Override
    public void sendToServer(BasePacket message) {
        throw new IllegalStateException("Cannot send packets to the server when we're the server!");
    }

    private void handlePacketFromClient(PacketContext packetContext, class_2540 payload) {
        class_1657 player = packetContext.getPlayer();
        if (!(player instanceof class_3222)) {
            AELog.warn("Received a packet for a non-server player entity!", player);
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        int packetType = payload.readInt();
        BasePacket pack = BasePacketHandler.PacketTypes.getPacket(packetType).parsePacket(payload);
        packetContext.getTaskQueue().execute(() -> pack.serverPacketData(null, serverPlayer));
    }
}

