/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import com.google.common.base.Preconditions;
import java.util.Objects;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

class ProcessingPatternEncoding {
    private static final String NBT_INPUTS = "in";
    private static final String NBT_OUTPUTS = "out";

    ProcessingPatternEncoding() {
    }

    public static GenericStack[] getProcessingInputs(class_2487 nbt) {
        return ProcessingPatternEncoding.getMixedList(nbt, NBT_INPUTS, 9);
    }

    public static GenericStack[] getProcessingOutputs(class_2487 nbt) {
        return ProcessingPatternEncoding.getMixedList(nbt, NBT_OUTPUTS, 3);
    }

    public static GenericStack[] getMixedList(class_2487 nbt, String nbtKey, int maxSize) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        class_2499 tag = nbt.method_10554(nbtKey, 10);
        Preconditions.checkArgument((tag.size() <= maxSize ? 1 : 0) != 0, (Object)("Cannot use more than " + maxSize + " ingredients"));
        GenericStack[] result = new GenericStack[tag.size()];
        for (int x = 0; x < tag.size(); ++x) {
            class_2487 entry = tag.method_10602(x);
            if (entry.method_33133()) continue;
            GenericStack stack = GenericStack.readTag(entry);
            if (stack == null) {
                throw new IllegalArgumentException("Pattern references missing stack: " + entry);
            }
            if (stack.what().getType() != AEKeyType.items() && stack.what().getType() != AEKeyType.fluids()) {
                throw new IllegalArgumentException("Only items and fluids are supported in AE2 patterns.");
            }
            result[x] = stack;
        }
        return result;
    }

    public static void encodeProcessingPattern(class_2487 tag, GenericStack[] sparseInputs, GenericStack[] sparseOutputs) {
        tag.method_10566(NBT_INPUTS, (class_2520)ProcessingPatternEncoding.encodeStackList(sparseInputs));
        tag.method_10566(NBT_OUTPUTS, (class_2520)ProcessingPatternEncoding.encodeStackList(sparseOutputs));
    }

    private static class_2499 encodeStackList(GenericStack[] stacks) {
        class_2499 tag = new class_2499();
        boolean foundStack = false;
        for (GenericStack stack : stacks) {
            tag.add((Object)GenericStack.writeTag(stack));
            if (stack == null || stack.amount() <= 0L) continue;
            foundStack = true;
        }
        Preconditions.checkArgument((boolean)foundStack, (Object)"List passed to pattern must contain at least one stack.");
        return tag;
    }
}

