/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers.externalstorage;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.util.IVariantConversion;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1802;
import net.minecraft.class_1935;

public class GenericStackInvStorage<V extends TransferVariant<?>>
implements Storage<V> {
    private final IVariantConversion<V> conversion;
    private final GenericStackInv inv;
    private final AEKeyType channel;
    private final List<View> storageViews;

    public GenericStackInvStorage(IVariantConversion<V> conversion, AEKeyType channel, GenericStackInv inv) {
        this.conversion = conversion;
        this.channel = channel;
        this.inv = inv;
        this.storageViews = new ArrayList<View>(inv.size());
        for (int i = 0; i < inv.size(); ++i) {
            this.storageViews.add(new View(i));
        }
    }

    public long insert(V resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative(resource, (long)maxAmount);
        long totalInserted = 0L;
        for (View view : this.storageViews) {
            if (!view.isResourceBlank() && (totalInserted += view.insert(resource, maxAmount - totalInserted, transaction)) >= maxAmount) break;
        }
        for (View view : this.storageViews) {
            if (view.isResourceBlank() && (totalInserted += view.insert(resource, maxAmount - totalInserted, transaction)) >= maxAmount) break;
        }
        return totalInserted;
    }

    public long extract(V resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative(resource, (long)maxAmount);
        long totalExtracted = 0L;
        for (View view : this.storageViews) {
            totalExtracted += view.extract(resource, maxAmount - totalExtracted, transaction);
        }
        return totalExtracted;
    }

    public Iterator<StorageView<V>> iterator(TransactionContext transaction) {
        return this.storageViews.iterator();
    }

    private class View
    extends SnapshotParticipant<GenericStack>
    implements StorageView<V> {
        private static final GenericStack EMPTY_STACK = new GenericStack(AEItemKey.of((class_1935)class_1802.field_8162), 0L);
        private final int slotIndex;

        private View(int slotIndex) {
            this.slotIndex = slotIndex;
        }

        public long extract(V resource, long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notBlankNotNegative(resource, (long)maxAmount);
            if (!this.getResource().equals(resource)) {
                return 0L;
            }
            long actuallyExtracted = Math.min(this.getAmount(), maxAmount);
            if (actuallyExtracted > 0L) {
                this.updateSnapshots(transaction);
                long amount = this.getAmount() - actuallyExtracted;
                GenericStackInvStorage.this.inv.beginBatch();
                if (amount <= 0L) {
                    GenericStackInvStorage.this.inv.setStack(this.slotIndex, null);
                } else {
                    GenericStackInvStorage.this.inv.setStack(this.slotIndex, new GenericStack(GenericStackInvStorage.this.conversion.getKey(resource), amount));
                }
                GenericStackInvStorage.this.inv.endBatchSuppressed();
            }
            return actuallyExtracted;
        }

        public long insert(V resource, long maxAmount, TransactionContext transaction) {
            long inserted;
            StoragePreconditions.notBlankNotNegative(resource, (long)maxAmount);
            AEKey currentKey = GenericStackInvStorage.this.inv.getKey(this.slotIndex);
            AEKey key = GenericStackInvStorage.this.conversion.getKey(resource);
            if ((currentKey == null || currentKey.equals(key)) && (inserted = Math.min(maxAmount, GenericStackInvStorage.this.inv.getMaxAmount(key) - this.getAmount())) > 0L) {
                this.updateSnapshots(transaction);
                GenericStackInvStorage.this.inv.beginBatch();
                GenericStackInvStorage.this.inv.setStack(this.slotIndex, new GenericStack(key, this.getAmount() + inserted));
                GenericStackInvStorage.this.inv.endBatchSuppressed();
                return inserted;
            }
            return 0L;
        }

        private boolean isSupportedSlot() {
            AEKey key = GenericStackInvStorage.this.inv.getKey(this.slotIndex);
            return key == null || GenericStackInvStorage.this.channel.tryCast(key) != null;
        }

        public boolean isResourceBlank() {
            return this.getResource().isBlank();
        }

        public V getResource() {
            return GenericStackInvStorage.this.conversion.getVariant(GenericStackInvStorage.this.channel.tryCast(GenericStackInvStorage.this.inv.getKey(this.slotIndex)));
        }

        public long getAmount() {
            return this.isSupportedSlot() ? GenericStackInvStorage.this.inv.getAmount(this.slotIndex) : 0L;
        }

        public long getCapacity() {
            return this.isSupportedSlot() ? GenericStackInvStorage.this.inv.getCapacity(GenericStackInvStorage.this.conversion.getKeyType()) : 0L;
        }

        protected GenericStack createSnapshot() {
            GenericStack stack = GenericStackInvStorage.this.inv.getStack(this.slotIndex);
            return stack != null ? stack : EMPTY_STACK;
        }

        protected void readSnapshot(GenericStack snapshot) {
            if (snapshot == EMPTY_STACK) {
                GenericStackInvStorage.this.inv.setStack(this.slotIndex, null);
            } else {
                GenericStackInvStorage.this.inv.setStack(this.slotIndex, snapshot);
            }
        }

        protected void onFinalCommit() {
            GenericStackInvStorage.this.inv.onChange();
        }
    }
}

