/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers.iface;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.MEStorage;
import appeng.me.storage.StorageAdapter;
import appeng.util.IVariantConversion;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;

public interface IInterfaceTarget {
    @Nullable
    public static IInterfaceTarget get(class_1937 l, class_2338 pos, @Nullable class_2586 be, class_2350 side, IActionSource src) {
        if (be == null) {
            return null;
        }
        IStorageMonitorableAccessor accessor = (IStorageMonitorableAccessor)IStorageMonitorableAccessor.SIDED.find(l, pos, null, be, (Object)side);
        if (accessor != null) {
            return IInterfaceTarget.wrapStorageMonitorable(accessor, src);
        }
        Storage itemHandler = (Storage)ItemStorage.SIDED.find(l, pos, null, be, (Object)side);
        Storage fluidHandler = (Storage)FluidStorage.SIDED.find(l, pos, null, be, (Object)side);
        if (itemHandler != null || fluidHandler != null) {
            return IInterfaceTarget.wrapHandlers((Storage<ItemVariant>)Objects.requireNonNullElse(itemHandler, Storage.empty()), (Storage<FluidVariant>)Objects.requireNonNullElse(fluidHandler, Storage.empty()), src);
        }
        return null;
    }

    private static IInterfaceTarget wrapStorageMonitorable(IStorageMonitorableAccessor accessor, final IActionSource src) {
        final MEStorage storage = accessor.getInventory(src);
        if (storage == null) {
            return null;
        }
        return new IInterfaceTarget(){

            @Override
            public long insert(AEKey what, long amount, Actionable type) {
                return storage.insert(what, amount, type, src);
            }

            @Override
            public boolean containsPatternInput(Set<AEKey> patternInputs) {
                for (Object2LongMap.Entry<AEKey> stack : storage.getAvailableStacks()) {
                    if (!patternInputs.contains(((AEKey)stack.getKey()).dropSecondary())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static IInterfaceTarget wrapHandlers(Storage<ItemVariant> itemHandler, Storage<FluidVariant> fluidHandler, final IActionSource src) {
        final StorageAdapter<ItemVariant> itemAdapter = new StorageAdapter<ItemVariant>(IVariantConversion.ITEM, itemHandler);
        final StorageAdapter<FluidVariant> fluidAdapter = new StorageAdapter<FluidVariant>(IVariantConversion.FLUID, fluidHandler);
        return new IInterfaceTarget(){

            @Override
            public long insert(AEKey what, long amount, Actionable type) {
                if (what instanceof AEItemKey) {
                    AEItemKey itemKey = (AEItemKey)what;
                    return itemAdapter.insert(itemKey, amount, type, src);
                }
                if (what instanceof AEFluidKey) {
                    AEFluidKey fluidKey = (AEFluidKey)what;
                    return fluidAdapter.insert(fluidKey, amount, type, src);
                }
                return 0L;
            }

            @Override
            public boolean containsPatternInput(Set<AEKey> patternInputs) {
                return itemAdapter.containsAnyFuzzy(patternInputs) || fluidAdapter.containsAnyFuzzy(patternInputs);
            }
        };
    }

    public long insert(AEKey var1, long var2, Actionable var4);

    public boolean containsPatternInput(Set<AEKey> var1);
}

