/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers.iface;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.util.IVariantConversion;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.InsertionOnlyStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;

public class PatternProviderReturnInventory
extends GenericStackInv {
    public static int NUMBER_OF_SLOTS = 9;
    private boolean injectingIntoNetwork = false;
    private final Participant participant = new Participant();
    private final Storage<ItemVariant> itemStorage = new GenericStorage<ItemVariant>(IVariantConversion.ITEM);
    private final Storage<FluidVariant> fluidStorage = new GenericStorage<FluidVariant>(IVariantConversion.FLUID);

    public PatternProviderReturnInventory(Runnable listener) {
        super(listener, NUMBER_OF_SLOTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean injectIntoNetwork(MEStorage storage, IActionSource src) {
        boolean didSomething = false;
        this.injectingIntoNetwork = true;
        try {
            for (int i = 0; i < this.stacks.length; ++i) {
                GenericStack stack = this.stacks[i];
                if (stack == null) continue;
                long sizeBefore = stack.amount();
                long inserted = storage.insert(stack.what(), stack.amount(), Actionable.MODULATE, src);
                this.stacks[i] = inserted >= stack.amount() ? null : new GenericStack(stack.what(), stack.amount() - inserted);
                if (GenericStack.getStackSizeOrZero(this.stacks[i]) == sizeBefore) continue;
                didSomething = true;
            }
        }
        finally {
            this.injectingIntoNetwork = false;
        }
        return didSomething;
    }

    public void addDrops(List<class_1799> drops) {
        for (GenericStack stack : this.stacks) {
            AEKey aEKey;
            if (stack == null || !((aEKey = stack.what()) instanceof AEItemKey)) continue;
            AEItemKey itemKey = (AEItemKey)aEKey;
            drops.add(itemKey.toStack((int)Math.min(Integer.MAX_VALUE, stack.amount())));
        }
    }

    public Storage<ItemVariant> getItemStorage() {
        return this.itemStorage;
    }

    public Storage<FluidVariant> getFluidStorage() {
        return this.fluidStorage;
    }

    private class Participant
    extends SnapshotParticipant<GenericStack[]> {
        private Participant() {
        }

        protected GenericStack[] createSnapshot() {
            GenericStack[] snapshot = new GenericStack[PatternProviderReturnInventory.this.stacks.length];
            System.arraycopy(PatternProviderReturnInventory.this.stacks, 0, snapshot, 0, PatternProviderReturnInventory.this.stacks.length);
            return snapshot;
        }

        protected void readSnapshot(GenericStack[] snapshot) {
            System.arraycopy(snapshot, 0, PatternProviderReturnInventory.this.stacks, 0, PatternProviderReturnInventory.this.stacks.length);
        }

        protected void onFinalCommit() {
            PatternProviderReturnInventory.this.onChange();
        }
    }

    private class GenericStorage<V extends TransferVariant<?>>
    implements InsertionOnlyStorage<V> {
        private final IVariantConversion<V> conversion;

        protected GenericStorage(IVariantConversion<V> conversion) {
            this.conversion = conversion;
        }

        public long insert(V resource, long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notBlankNotNegative(resource, (long)maxAmount);
            if (PatternProviderReturnInventory.this.injectingIntoNetwork) {
                return 0L;
            }
            long totalInserted = 0L;
            for (int slot = 0; slot < PatternProviderReturnInventory.this.stacks.length; ++slot) {
                if (PatternProviderReturnInventory.this.stacks[slot] == null) {
                    long inserted = Math.min(maxAmount - totalInserted, this.conversion.getBaseSlotSize(resource));
                    if (inserted <= 0L) continue;
                    PatternProviderReturnInventory.this.participant.updateSnapshots(transaction);
                    ((PatternProviderReturnInventory)PatternProviderReturnInventory.this).stacks[slot] = new GenericStack(this.conversion.getKey(resource), inserted);
                    totalInserted += inserted;
                    continue;
                }
                if (!this.conversion.variantMatches(PatternProviderReturnInventory.this.stacks[slot].what(), resource)) continue;
                GenericStack stack = PatternProviderReturnInventory.this.stacks[slot];
                long inserted = Math.min(maxAmount - totalInserted, this.conversion.getBaseSlotSize(resource) - stack.amount());
                if (inserted <= 0L) continue;
                PatternProviderReturnInventory.this.participant.updateSnapshots(transaction);
                ((PatternProviderReturnInventory)PatternProviderReturnInventory.this).stacks[slot] = new GenericStack(stack.what(), stack.amount() + inserted);
                totalInserted += inserted;
            }
            return totalInserted;
        }

        public Iterator<StorageView<V>> iterator(TransactionContext transaction) {
            return Collections.emptyIterator();
        }
    }
}

