/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.core.AELog;
import com.mojang.serialization.Dynamic;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public final class FixupDimensionHook {
    private FixupDimensionHook() {
    }

    public static <T> void removeDimension(Dynamic<T> nbt) {
        Object object = nbt.getValue();
        if (!(object instanceof class_2487)) {
            AELog.warn("Failed to fixup spatial dimension: Not loading from NBT", new Object[0]);
            return;
        }
        class_2487 compoundTag = (class_2487)object;
        if (!compoundTag.method_10573("WorldGenSettings", 10)) {
            AELog.warn("Failed to fixup spatial dimension: Missing WorldGenSettings", new Object[0]);
            return;
        }
        class_2487 worldGenSettings = compoundTag.method_10562("WorldGenSettings");
        if (!worldGenSettings.method_10573("dimensions", 10)) {
            AELog.warn("Failed to fixup spatial dimension: Missing WorldGenSettings.dimensions", new Object[0]);
            return;
        }
        class_2487 dimensions = worldGenSettings.method_10562("dimensions");
        if (dimensions.method_10545("ae2:spatial_storage")) {
            dimensions.method_10551("ae2:spatial_storage");
            AELog.debug("Removed AE2 spatial storage before DFU can 'fix' it", new Object[0]);
        } else {
            AELog.warn("AE2 spatial storage dimension missing. It will be re-added.", new Object[0]);
        }
    }

    public static <T> void addDimension(Dynamic<T> nbt) {
        Object object = nbt.getValue();
        if (!(object instanceof class_2487)) {
            AELog.warn("Failed to re-add spatial dimension: Not loading from NBT", new Object[0]);
            return;
        }
        class_2487 worldGenSettings = (class_2487)object;
        if (!worldGenSettings.method_10573("dimensions", 10)) {
            AELog.warn("Failed to re-add spatial dimension: Missing dimensions key", new Object[0]);
            return;
        }
        class_2487 dimensions = worldGenSettings.method_10562("dimensions");
        if (!dimensions.method_10545("ae2:spatial_storage")) {
            AELog.debug("Re-adding spatial storage NBT to world generation settings", new Object[0]);
            class_2487 spatialStorage = new class_2487();
            spatialStorage.method_10582("type", "ae2:spatial_storage");
            class_2487 generator = new class_2487();
            generator.method_10582("type", "ae2:spatial_storage");
            spatialStorage.method_10566("generator", (class_2520)generator);
            dimensions.method_10566("ae2:spatial_storage", (class_2520)spatialStorage);
        }
    }
}

