/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks.ticking;

import appeng.api.networking.IGridNode;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.crafting.CraftingCalculation;
import appeng.hooks.ticking.ServerBlockEntityRepo;
import appeng.hooks.ticking.ServerGridRepo;
import appeng.me.Grid;
import appeng.me.GridNode;
import appeng.util.ILevelRunnable;
import appeng.util.Platform;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2818;
import net.minecraft.class_3218;

public class TickHandler {
    private static final int TIME_LIMIT_PROCESS_QUEUE_MILLISECONDS = 25;
    private static final TickHandler INSTANCE = new TickHandler();
    private final Queue<ILevelRunnable> serverQueue = new ArrayDeque<ILevelRunnable>();
    private final Multimap<class_1936, CraftingCalculation> craftingJobs = LinkedListMultimap.create();
    private final Map<class_1936, Queue<ILevelRunnable>> callQueue = new HashMap<class_1936, Queue<ILevelRunnable>>();
    private final ServerBlockEntityRepo blockEntities = new ServerBlockEntityRepo();
    private final ServerGridRepo grids = new ServerGridRepo();
    private final Stopwatch stopWatch = Stopwatch.createUnstarted();
    private int processQueueElementsProcessed = 0;
    private int processQueueElementsRemaining = 0;
    private long tickCounter;

    public static TickHandler instance() {
        return INSTANCE;
    }

    private TickHandler() {
    }

    public void init() {
        ServerTickEvents.START_SERVER_TICK.register(server -> this.onServerTickStart());
        ServerTickEvents.END_SERVER_TICK.register(server -> this.onServerTickEnd());
        ServerTickEvents.START_WORLD_TICK.register(this::onServerLevelTickStart);
        ServerTickEvents.END_WORLD_TICK.register(this::onServerLevelTickEnd);
        ServerChunkEvents.CHUNK_UNLOAD.register(this::onUnloadChunk);
        ServerWorldEvents.LOAD.register((server, level) -> this.onLoadLevel(level));
        ServerWorldEvents.UNLOAD.register((server, level) -> this.onUnloadLevel(level));
    }

    public void addCallable(class_1936 level, Runnable c) {
        this.addCallable(level, (class_1937 ignored) -> c.run());
    }

    public void addCallable(class_1936 level, ILevelRunnable c) {
        Preconditions.checkArgument((level == null || !level.method_8608() ? 1 : 0) != 0, (Object)"Can only register serverside callbacks");
        if (level == null) {
            this.serverQueue.add(c);
        } else {
            Queue<ILevelRunnable> queue = this.callQueue.get(level);
            if (queue == null) {
                queue = new ArrayDeque<ILevelRunnable>();
                this.callQueue.put(level, queue);
            }
            queue.add(c);
        }
    }

    public void addInit(AEBaseBlockEntity blockEntity) {
        if (!blockEntity.method_10997().method_8608()) {
            Objects.requireNonNull(blockEntity);
            blockEntity.setQueuedForReady((byte)(blockEntity.getQueuedForReady() + 1));
            this.blockEntities.addBlockEntity(blockEntity);
        }
    }

    public void addNetwork(Grid grid) {
        Platform.assertServerThread();
        this.grids.addNetwork(grid);
    }

    public void removeNetwork(Grid grid) {
        Platform.assertServerThread();
        this.grids.removeNetwork(grid);
    }

    public Iterable<Grid> getGridList() {
        Platform.assertServerThread();
        return this.grids.getNetworks();
    }

    public void shutdown() {
        Platform.assertServerThread();
        this.blockEntities.clear();
        this.grids.clear();
    }

    public void onUnloadChunk(class_3218 level, class_2818 chunk) {
        this.blockEntities.removeChunk((class_1936)level, chunk.method_12004().method_8324());
    }

    public void onLoadLevel(class_3218 level) {
        this.blockEntities.addLevel((class_1936)level);
    }

    public void onUnloadLevel(class_3218 level) {
        if (level.method_8608()) {
            return;
        }
        ArrayList<GridNode> toDestroy = new ArrayList<GridNode>();
        this.grids.updateNetworks();
        for (Grid g : this.grids.getNetworks()) {
            for (IGridNode n : g.getNodes()) {
                if (n.getLevel() != level) continue;
                toDestroy.add((GridNode)n);
            }
        }
        for (GridNode n : toDestroy) {
            n.destroy();
        }
        this.blockEntities.removeLevel((class_1936)level);
        this.callQueue.remove(level);
    }

    private void onServerLevelTickStart(class_3218 level) {
        Queue<ILevelRunnable> queue = this.callQueue.remove(level);
        this.processQueueElementsRemaining += this.processQueue(queue, (class_1937)level);
        Queue<ILevelRunnable> newQueue = this.callQueue.put((class_1936)level, queue);
        if (newQueue != null) {
            queue.addAll(newQueue);
        }
        this.grids.updateNetworks();
        for (Grid g : this.grids.getNetworks()) {
            try {
                g.onLevelStartTick((class_1937)level);
            }
            catch (Throwable t) {
                class_128 crashReport = class_128.method_560((Throwable)t, (String)"Ticking grid on start of level tick");
                g.fillCrashReportCategory(crashReport.method_562("Grid being ticked"));
                level.method_8538(crashReport);
                throw new class_148(crashReport);
            }
        }
    }

    private void onServerLevelTickEnd(class_3218 level) {
        this.simulateCraftingJobs((class_1936)level);
        this.readyBlockEntities(level);
        for (Grid g : this.grids.getNetworks()) {
            try {
                g.onLevelEndTick((class_1937)level);
            }
            catch (Throwable t) {
                class_128 crashReport = class_128.method_560((Throwable)t, (String)"Ticking grid on end of level tick");
                g.fillCrashReportCategory(crashReport.method_562("Grid being ticked"));
                level.method_8538(crashReport);
                throw new class_148(crashReport);
            }
        }
    }

    private void onServerTickStart() {
        this.processQueueElementsProcessed = 0;
        this.processQueueElementsRemaining = 0;
        this.stopWatch.reset();
        for (Grid g : this.grids.getNetworks()) {
            try {
                g.onServerStartTick();
            }
            catch (Throwable t) {
                class_128 crashReport = class_128.method_560((Throwable)t, (String)"Ticking grid on start of server tick");
                g.fillCrashReportCategory(crashReport.method_562("Grid being ticked"));
                throw new class_148(crashReport);
            }
        }
    }

    private void onServerTickEnd() {
        for (Grid g : this.grids.getNetworks()) {
            try {
                g.onServerEndTick();
            }
            catch (Throwable t) {
                class_128 crashReport = class_128.method_560((Throwable)t, (String)"Ticking grid on end of server tick");
                g.fillCrashReportCategory(crashReport.method_562("Grid being ticked"));
                throw new class_148(crashReport);
            }
        }
        this.processQueueElementsRemaining += this.processQueue(this.serverQueue, null);
        if (this.stopWatch.elapsed(TimeUnit.MILLISECONDS) > 25L) {
            AELog.warn("Exceeded time limit of %d ms after processing %d queued tick callbacks (%d remain)", 25, this.processQueueElementsProcessed, this.processQueueElementsRemaining);
        }
        ++this.tickCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCraftingSimulation(class_1937 level, CraftingCalculation craftingCalculation) {
        Preconditions.checkArgument((!level.field_9236 ? 1 : 0) != 0, (Object)"Trying to register a crafting job for a client-level");
        Multimap<class_1936, CraftingCalculation> multimap = this.craftingJobs;
        synchronized (multimap) {
            this.craftingJobs.put((Object)level, (Object)craftingCalculation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void simulateCraftingJobs(class_1936 level) {
        Multimap<class_1936, CraftingCalculation> multimap = this.craftingJobs;
        synchronized (multimap) {
            Collection jobSet = this.craftingJobs.get((Object)level);
            if (!jobSet.isEmpty()) {
                int jobSize = jobSet.size();
                int microSecondsPerTick = AEConfig.instance().getCraftingCalculationTimePerTick() * 1000;
                int simTime = Math.max(1, microSecondsPerTick / jobSize);
                Iterator i = jobSet.iterator();
                while (i.hasNext()) {
                    CraftingCalculation cj = (CraftingCalculation)i.next();
                    if (cj.simulateFor(simTime)) continue;
                    i.remove();
                }
            }
        }
    }

    private void readyBlockEntities(class_3218 level) {
        long[] workSet;
        Long2ObjectMap<List<AEBaseBlockEntity>> levelQueue = this.blockEntities.getBlockEntities((class_1936)level);
        for (long packedChunkPos : workSet = levelQueue.keySet().toLongArray()) {
            if (!level.method_39425(packedChunkPos)) continue;
            List chunkQueue = (List)levelQueue.remove(packedChunkPos);
            if (chunkQueue == null) {
                AELog.warn("Chunk %s was unloaded while we were readying block entities", new class_1923(packedChunkPos));
                continue;
            }
            for (AEBaseBlockEntity bt : chunkQueue) {
                if (bt.method_11015()) continue;
                try {
                    bt.onReady();
                    bt.setReadyInvoked((byte)(bt.getReadyInvoked() + 1));
                }
                catch (Throwable t) {
                    class_128 crashReport = class_128.method_560((Throwable)t, (String)"Readying AE2 block entity");
                    bt.method_11003(crashReport.method_562("Block entity being readied"));
                    throw new class_148(crashReport);
                }
            }
        }
    }

    private int processQueue(Queue<ILevelRunnable> queue, class_1937 level) {
        if (queue == null) {
            return 0;
        }
        this.stopWatch.start();
        while (!queue.isEmpty()) {
            try {
                queue.poll().call(level);
                ++this.processQueueElementsProcessed;
                if (this.stopWatch.elapsed(TimeUnit.MILLISECONDS) <= 25L) continue;
                break;
            }
            catch (Exception e) {
                AELog.warn(e);
            }
        }
        this.stopWatch.stop();
        return queue.size();
    }

    public long getCurrentTick() {
        return this.tickCounter;
    }

    public List<class_2561> getBlockEntityReport() {
        return this.blockEntities.getReport();
    }
}

