/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.api.config.CondenserOutput;
import appeng.api.implementations.items.IStorageComponent;
import appeng.core.definitions.AEItems;
import appeng.integration.modules.jei.CondenserCategory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1799;

public class CondenserOutputDisplay
implements Display {
    private final CondenserOutput type;
    private final List<EntryIngredient> output;
    private final List<EntryStack<class_1799>> viableStorageComponents;

    public CondenserOutputDisplay(CondenserOutput output) {
        this.type = output;
        this.output = Collections.singletonList(EntryIngredients.of((class_1799)CondenserOutputDisplay.getOutput(this.type)));
        this.viableStorageComponents = this.getViableStorageComponents(output);
    }

    public List<EntryIngredient> getInputEntries() {
        return Collections.emptyList();
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.output;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return CondenserCategory.ID;
    }

    public CondenserOutput getType() {
        return this.type;
    }

    private static class_1799 getOutput(CondenserOutput recipe) {
        return switch (recipe) {
            case CondenserOutput.MATTER_BALLS -> AEItems.MATTER_BALL.stack();
            case CondenserOutput.SINGULARITY -> AEItems.SINGULARITY.stack();
            default -> class_1799.field_8037;
        };
    }

    private List<EntryStack<class_1799>> getViableStorageComponents(CondenserOutput condenserOutput) {
        ArrayList<EntryStack<class_1799>> viableComponents = new ArrayList<EntryStack<class_1799>>();
        this.addViableComponent(condenserOutput, viableComponents, AEItems.CELL_COMPONENT_1K.stack());
        this.addViableComponent(condenserOutput, viableComponents, AEItems.CELL_COMPONENT_4K.stack());
        this.addViableComponent(condenserOutput, viableComponents, AEItems.CELL_COMPONENT_16K.stack());
        this.addViableComponent(condenserOutput, viableComponents, AEItems.CELL_COMPONENT_64K.stack());
        return viableComponents;
    }

    private void addViableComponent(CondenserOutput condenserOutput, List<EntryStack<class_1799>> viableComponents, class_1799 itemStack) {
        IStorageComponent comp = (IStorageComponent)itemStack.method_7909();
        int storage = comp.getBytes(itemStack) * 8;
        if (storage >= condenserOutput.requiredPower) {
            viableComponents.add((EntryStack<class_1799>)EntryStacks.of((class_1799)itemStack));
        }
    }

    public List<EntryStack<class_1799>> getViableStorageComponents() {
        return this.viableStorageComponents;
    }
}

