/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei.transfer;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.core.localization.ItemModText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.helpers.InventoryAction;
import appeng.integration.modules.jei.GenericEntryStackHelper;
import appeng.integration.modules.jei.transfer.AbstractTransferHandler;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.menu.slot.FakeSlot;
import appeng.menu.slot.OptionalFakeSlot;
import appeng.parts.encoding.EncodingMode;
import appeng.util.CraftingRecipeUtil;
import com.google.common.math.LongMath;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class EncodePatternTransferHandler<T extends PatternEncodingTermMenu>
extends AbstractTransferHandler<T> {
    private static final Comparator<GridInventoryEntry> ENTRY_COMPARATOR = Comparator.comparing(GridInventoryEntry::isCraftable).thenComparing(EncodePatternTransferHandler::isUndamaged).thenComparing(GridInventoryEntry::getStoredAmount);

    private static Boolean isUndamaged(GridInventoryEntry entry) {
        AEItemKey itemKey;
        AEKey aEKey = entry.getWhat();
        return !(aEKey instanceof AEItemKey) || !(itemKey = (AEItemKey)aEKey).isDamaged();
    }

    public EncodePatternTransferHandler(Class<T> containerClass) {
        super(containerClass);
    }

    @Override
    protected TransferHandler.Result transferRecipe(T menu, class_1860<?> recipe, Display display, boolean doTransfer) {
        boolean craftingRecipe = this.isCraftingRecipe(recipe, display);
        if (craftingRecipe && !this.fitsIn3x3Grid(recipe, display)) {
            return TransferHandler.Result.createFailed((class_2561)ItemModText.RECIPE_TOO_LARGE.text());
        }
        if (doTransfer) {
            if (craftingRecipe) {
                ((PatternEncodingTermMenu)menu).setMode(EncodingMode.CRAFTING);
                this.encodeCraftingRecipe(menu, recipe, this.getGuiIngredientsForCrafting(display));
            } else {
                ((PatternEncodingTermMenu)menu).setMode(EncodingMode.PROCESSING);
                this.encodeProcessingRecipe(menu, GenericEntryStackHelper.ofInputs(display), GenericEntryStackHelper.ofOutputs(display));
            }
        }
        return TransferHandler.Result.createSuccessful().blocksFurtherHandling();
    }

    private List<List<GenericStack>> getGuiIngredientsForCrafting(Display recipeLayout) {
        ArrayList<List<GenericStack>> result = new ArrayList<List<GenericStack>>(9);
        for (int i = 0; i < 9; ++i) {
            ArrayList<GenericStack> stacks = new ArrayList<GenericStack>();
            if (i < recipeLayout.getInputEntries().size()) {
                for (EntryStack entryStack : (EntryIngredient)recipeLayout.getInputEntries().get(i)) {
                    if (entryStack.getType() != VanillaEntryTypes.ITEM) continue;
                    stacks.add(GenericStack.fromItemStack((class_1799)entryStack.castValue()));
                }
            }
            result.add(stacks);
        }
        return result;
    }

    private void encodeProcessingRecipe(T menu, List<List<GenericStack>> genericIngredients, List<GenericStack> genericResults) {
        Map<AEKey, Integer> ingredientPriorities = this.getIngredientPriorities((MEStorageMenu)menu, ENTRY_COMPARATOR);
        this.encodeBestMatchingStacksIntoSlots(genericIngredients, ingredientPriorities, ((PatternEncodingTermMenu)menu).getCraftingGridSlots());
        this.encodeBestMatchingStacksIntoSlots(genericResults.stream().map(List::of).toList(), ingredientPriorities, ((PatternEncodingTermMenu)menu).getProcessingOutputSlots());
    }

    private void encodeBestMatchingStacksIntoSlots(List<List<GenericStack>> possibleInputsBySlot, Map<AEKey, Integer> ingredientPriorities, FakeSlot[] slots) {
        ArrayList<GenericStack> encodedInputs = new ArrayList<GenericStack>();
        for (List<GenericStack> genericIngredient : possibleInputsBySlot) {
            if (genericIngredient.isEmpty()) continue;
            this.addOrMerge(encodedInputs, EncodePatternTransferHandler.findBestIngredient(ingredientPriorities, genericIngredient));
        }
        for (int i = 0; i < slots.length; ++i) {
            FakeSlot slot = slots[i];
            class_1799 stack = i < encodedInputs.size() ? GenericStack.wrapInItemStack(encodedInputs.get(i)) : class_1799.field_8037;
            NetworkHandler.instance().sendToServer(new InventoryActionPacket(InventoryAction.SET_FILTER, slot.field_7874, stack));
        }
    }

    private void encodeCraftingRecipe(T menu, @Nullable class_1860<?> recipe, List<List<GenericStack>> genericIngredients) {
        Map<AEKey, Integer> prioritizedNetworkInv = this.getIngredientPriorities((MEStorageMenu)menu, ENTRY_COMPARATOR);
        class_2371 encodedInputs = class_2371.method_10213((int)((PatternEncodingTermMenu)menu).getCraftingGridSlots().length, (Object)class_1799.field_8037);
        if (recipe != null) {
            class_2371<class_1856> ingredients3x3 = CraftingRecipeUtil.ensure3by3CraftingMatrix(recipe);
            for (int slot = 0; slot < ingredients3x3.size(); ++slot) {
                class_1856 ingredient = (class_1856)ingredients3x3.get(slot);
                if (ingredient.method_8103()) continue;
                Optional<class_1799> bestNetworkIngredient = prioritizedNetworkInv.entrySet().stream().filter(ni -> {
                    AEItemKey itemKey;
                    Object patt7124$temp = ni.getKey();
                    return patt7124$temp instanceof AEItemKey && ingredient.method_8093((itemKey = (AEItemKey)patt7124$temp).toStack());
                }).max(Comparator.comparingInt(Map.Entry::getValue)).map(entry -> {
                    class_1799 class_17992;
                    Object patt7320$temp = entry.getKey();
                    if (patt7320$temp instanceof AEItemKey) {
                        AEItemKey itemKey = (AEItemKey)patt7320$temp;
                        class_17992 = itemKey.toStack();
                    } else {
                        class_17992 = null;
                    }
                    return class_17992;
                });
                class_1799 bestIngredient = bestNetworkIngredient.orElse(ingredient.method_8105()[0]);
                encodedInputs.set(slot, (Object)bestIngredient);
            }
        } else {
            for (int slot = 0; slot < genericIngredients.size(); ++slot) {
                List<GenericStack> genericIngredient = genericIngredients.get(slot);
                if (genericIngredient.isEmpty()) continue;
                AEKey bestIngredient = EncodePatternTransferHandler.findBestIngredient(prioritizedNetworkInv, genericIngredient).what();
                if (bestIngredient instanceof AEItemKey) {
                    AEItemKey itemKey = (AEItemKey)bestIngredient;
                    encodedInputs.set(slot, (Object)itemKey.toStack());
                    continue;
                }
                encodedInputs.set(slot, (Object)GenericStack.wrapInItemStack(bestIngredient, 1L));
            }
        }
        for (int i = 0; i < encodedInputs.size(); ++i) {
            class_1799 encodedInput = (class_1799)encodedInputs.get(i);
            NetworkHandler.instance().sendToServer(new InventoryActionPacket(InventoryAction.SET_FILTER, ((PatternEncodingTermMenu)menu).getCraftingGridSlots()[i].field_7874, encodedInput));
        }
        for (OptionalFakeSlot outputSlot : ((PatternEncodingTermMenu)menu).getProcessingOutputSlots()) {
            NetworkHandler.instance().sendToServer(new InventoryActionPacket(InventoryAction.SET_FILTER, outputSlot.field_7874, class_1799.field_8037));
        }
    }

    private static GenericStack findBestIngredient(Map<AEKey, Integer> ingredientPriorities, List<GenericStack> possibleIngredients) {
        return possibleIngredients.stream().map(gi -> Pair.of((Object)gi, (Object)ingredientPriorities.getOrDefault(gi.what(), Integer.MIN_VALUE))).max(Comparator.comparingInt(Pair::getRight)).map(Pair::getLeft).orElseThrow();
    }

    private void addOrMerge(List<GenericStack> stacks, GenericStack newStack) {
        for (int i = 0; i < stacks.size(); ++i) {
            GenericStack existingStack = stacks.get(i);
            if (!Objects.equals(existingStack.what(), newStack.what())) continue;
            long newAmount = LongMath.saturatedAdd((long)existingStack.amount(), (long)newStack.amount());
            stacks.set(i, new GenericStack(newStack.what(), newAmount));
            long overflow = newStack.amount() - (newAmount - existingStack.amount());
            if (overflow > 0L) {
                stacks.add(new GenericStack(newStack.what(), overflow));
            }
            return;
        }
        stacks.add(newStack);
    }
}

