/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered.powersink;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.core.localization.Tooltips;
import appeng.items.AEBaseItem;
import java.util.List;
import java.util.function.DoubleSupplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3532;

public abstract class AEBasePoweredItem
extends AEBaseItem
implements IAEItemPowerStorage {
    private static final double MIN_POWER = 1.0E-4;
    private static final String CURRENT_POWER_NBT_KEY = "internalCurrentPower";
    private static final String MAX_POWER_NBT_KEY = "internalMaxPower";
    private final DoubleSupplier powerCapacity;

    public AEBasePoweredItem(DoubleSupplier powerCapacity, class_1792.class_1793 props) {
        super(props);
        this.powerCapacity = powerCapacity;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 level, List<class_2561> lines, class_1836 advancedTooltips) {
        class_2487 tag = stack.method_7969();
        double internalCurrentPower = 0.0;
        double internalMaxPower = this.getAEMaxPower(stack);
        if (tag != null) {
            internalCurrentPower = tag.method_10574(CURRENT_POWER_NBT_KEY);
        }
        lines.add(Tooltips.energyStorageComponent(internalCurrentPower, internalMaxPower));
    }

    public void method_7850(class_1761 group, class_2371<class_1799> items) {
        super.method_7850(group, items);
        if (this.method_7877(group)) {
            class_1799 charged = new class_1799((class_1935)this, 1);
            this.injectAEPower(charged, this.getAEMaxPower(charged), Actionable.MODULATE);
            items.add((Object)charged);
        }
    }

    public boolean method_31567(class_1799 stack) {
        return true;
    }

    public int method_31569(class_1799 stack) {
        double filled = this.getAECurrentPower(stack) / this.getAEMaxPower(stack);
        return class_3532.method_15340((int)((int)(filled * 13.0)), (int)0, (int)13);
    }

    public int method_31571(class_1799 stack) {
        return class_3532.method_15369((float)0.33333334f, (float)1.0f, (float)1.0f);
    }

    @Override
    public double injectAEPower(class_1799 stack, double amount, Actionable mode) {
        double maxStorage = this.getAEMaxPower(stack);
        double currentStorage = this.getAECurrentPower(stack);
        double required = maxStorage - currentStorage;
        double overflow = Math.max(0.0, Math.min(amount - required, amount));
        if (mode == Actionable.MODULATE) {
            double toAdd = Math.min(amount, required);
            this.setAECurrentPower(stack, currentStorage + toAdd);
        }
        return overflow;
    }

    @Override
    public double extractAEPower(class_1799 stack, double amount, Actionable mode) {
        double currentStorage = this.getAECurrentPower(stack);
        double fulfillable = Math.min(amount, currentStorage);
        if (mode == Actionable.MODULATE) {
            this.setAECurrentPower(stack, currentStorage - fulfillable);
        }
        return fulfillable;
    }

    @Override
    public double getAEMaxPower(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10573(MAX_POWER_NBT_KEY, 6)) {
            return tag.method_10574(MAX_POWER_NBT_KEY);
        }
        return this.powerCapacity.getAsDouble();
    }

    protected final void setAEMaxPower(class_1799 stack, double maxPower) {
        double defaultCapacity = this.powerCapacity.getAsDouble();
        if (Math.abs(maxPower - defaultCapacity) < 1.0E-4) {
            stack.method_7983(MAX_POWER_NBT_KEY);
            maxPower = defaultCapacity;
        } else {
            stack.method_7948().method_10549(MAX_POWER_NBT_KEY, maxPower);
        }
        double currentPower = this.getAECurrentPower(stack);
        if (currentPower > maxPower) {
            this.setAECurrentPower(stack, maxPower);
        }
    }

    protected final void setAEMaxPowerMultiplier(class_1799 stack, int multiplier) {
        if ((multiplier = class_3532.method_15340((int)multiplier, (int)1, (int)100)) == 1) {
            this.resetAEMaxPower(stack);
        } else {
            this.setAEMaxPower(stack, (double)multiplier * this.powerCapacity.getAsDouble());
        }
    }

    protected final void resetAEMaxPower(class_1799 stack) {
        stack.method_7983(MAX_POWER_NBT_KEY);
    }

    @Override
    public double getAECurrentPower(class_1799 is) {
        class_2487 tag = is.method_7969();
        if (tag != null) {
            return tag.method_10574(CURRENT_POWER_NBT_KEY);
        }
        return 0.0;
    }

    protected final void setAECurrentPower(class_1799 stack, double power) {
        if (power < 1.0E-4) {
            stack.method_7983(CURRENT_POWER_NBT_KEY);
        } else {
            stack.method_7948().method_10549(CURRENT_POWER_NBT_KEY, power);
        }
    }

    @Override
    public AccessRestriction getPowerFlow(class_1799 is) {
        return AccessRestriction.WRITE;
    }
}

