/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster.implementations;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.GridCraftingCpuChange;
import appeng.blockentity.crafting.CraftingBlockEntity;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.MBCalculator;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import java.util.Iterator;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3218;

public class CraftingCPUCalculator
extends MBCalculator<CraftingBlockEntity, CraftingCPUCluster> {
    public CraftingCPUCalculator(CraftingBlockEntity t) {
        super(t);
    }

    @Override
    public boolean checkMultiblockScale(class_2338 min, class_2338 max) {
        if (max.method_10263() - min.method_10263() > 16) {
            return false;
        }
        if (max.method_10264() - min.method_10264() > 16) {
            return false;
        }
        return max.method_10260() - min.method_10260() <= 16;
    }

    @Override
    public CraftingCPUCluster createCluster(class_3218 level, class_2338 min, class_2338 max) {
        return new CraftingCPUCluster(min, max);
    }

    @Override
    public boolean verifyInternalStructure(class_3218 level, class_2338 min, class_2338 max) {
        boolean storage = false;
        for (class_2338 blockPos : class_2338.method_10097((class_2338)min, (class_2338)max)) {
            IAEMultiBlock te = (IAEMultiBlock)level.method_8321(blockPos);
            if (te == null || !te.isValid()) {
                return false;
            }
            if (storage || !(te instanceof CraftingBlockEntity)) continue;
            storage = ((CraftingBlockEntity)te).getStorageBytes() > 0;
        }
        return storage;
    }

    @Override
    public void updateBlockEntities(CraftingCPUCluster c, class_3218 level, class_2338 min, class_2338 max) {
        for (class_2338 blockPos : class_2338.method_10097((class_2338)min, (class_2338)max)) {
            CraftingBlockEntity te = (CraftingBlockEntity)level.method_8321(blockPos);
            te.updateStatus(c);
            c.addBlockEntity(te);
        }
        c.done();
        Iterator<CraftingBlockEntity> i = c.getBlockEntities();
        while (i.hasNext()) {
            CraftingBlockEntity gh = i.next();
            IGridNode n = gh.getGridNode();
            if (n == null) continue;
            IGrid g = n.getGrid();
            g.postEvent(new GridCraftingCpuChange(n));
            return;
        }
    }

    @Override
    public boolean isValidBlockEntity(class_2586 te) {
        return te instanceof CraftingBlockEntity;
    }
}

