/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.service;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridService;
import appeng.api.networking.IGridServiceProvider;
import appeng.api.networking.events.statistics.GridChunkEvent;
import appeng.me.InWorldGridNode;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

public class StatisticsService
implements IGridService,
IGridServiceProvider {
    private final IGrid grid;
    private final Map<class_1936, Multiset<class_1923>> chunks;

    public StatisticsService(IGrid g) {
        this.grid = g;
        this.chunks = new HashMap<class_1936, Multiset<class_1923>>();
    }

    @Override
    public void removeNode(IGridNode node) {
        if (node instanceof InWorldGridNode) {
            InWorldGridNode inWorldNode = (InWorldGridNode)node;
            this.removeChunk((class_1936)inWorldNode.getLevel(), inWorldNode.getLocation());
        }
    }

    @Override
    public void addNode(IGridNode node) {
        if (node instanceof InWorldGridNode) {
            InWorldGridNode inWorldNode = (InWorldGridNode)node;
            this.addChunk((class_1936)inWorldNode.getLevel(), inWorldNode.getLocation());
        }
    }

    public IGrid getGrid() {
        return this.grid;
    }

    public Set<class_1936> getLevels() {
        return this.chunks.keySet();
    }

    public Set<class_1923> chunks(class_1936 level) {
        return this.chunks.get(level).elementSet();
    }

    public Map<class_1936, Multiset<class_1923>> getChunks() {
        return this.chunks;
    }

    private boolean addChunk(class_1936 level, class_2338 pos) {
        class_1923 position = new class_1923(pos);
        if (!this.getChunks(level).contains((Object)position)) {
            this.grid.postEvent(new GridChunkEvent.GridChunkAdded((class_3218)level, position));
        }
        return this.getChunks(level).add((Object)position);
    }

    private boolean removeChunk(class_1936 level, class_2338 pos) {
        class_1923 position = new class_1923(pos);
        boolean ret = this.getChunks(level).remove((Object)position);
        if (ret && !this.getChunks(level).contains((Object)position)) {
            this.grid.postEvent(new GridChunkEvent.GridChunkRemoved((class_3218)level, position));
        }
        this.clearLevel(level);
        return ret;
    }

    private Multiset<class_1923> getChunks(class_1936 level) {
        return this.chunks.computeIfAbsent(level, l -> HashMultiset.create());
    }

    private void clearLevel(class_1936 level) {
        if (this.chunks.get(level).isEmpty()) {
            this.chunks.remove(level);
        }
    }
}

