/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.guisync;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Objects;
import net.minecraft.class_2540;
import net.minecraft.class_2561;

public abstract class SynchronizedField<T> {
    private final Object source;
    protected final MethodHandle getter;
    protected final MethodHandle setter;
    protected T clientVersion = null;

    private SynchronizedField(Object source, Field field) {
        this.source = source;
        field.setAccessible(true);
        try {
            this.getter = MethodHandles.publicLookup().unreflectGetter(field);
            this.setter = MethodHandles.publicLookup().unreflectSetter(field);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to get accessor for field " + field + ". Did you forget to make it public?");
        }
    }

    private T getCurrentValue() {
        try {
            return (T)this.getter.invoke(this.source);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public boolean hasChanges() {
        return !Objects.equals(this.getCurrentValue(), this.clientVersion);
    }

    public final void write(class_2540 data) {
        T currentValue = this.getCurrentValue();
        this.clientVersion = currentValue;
        this.writeValue(data, currentValue);
    }

    public final void read(class_2540 data) {
        T value = this.readValue(data);
        try {
            this.setter.invoke(this.source, value);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    protected abstract void writeValue(class_2540 var1, T var2);

    protected abstract T readValue(class_2540 var1);

    public static SynchronizedField<?> create(Object source, Field field) {
        Class<class_2561> fieldType = field.getType();
        if (fieldType.isAssignableFrom(class_2561.class)) {
            return new TextComponentField(source, field);
        }
        if (fieldType == String.class) {
            return new StringField(source, field);
        }
        if (fieldType == Integer.TYPE || fieldType == Integer.class) {
            return new IntegerField(source, field);
        }
        if (fieldType == Long.TYPE || fieldType == Long.class) {
            return new LongField(source, field);
        }
        if (fieldType == Boolean.TYPE || fieldType == Boolean.class) {
            return new BooleanField(source, field);
        }
        if (fieldType.isEnum()) {
            return SynchronizedField.createEnumField(source, field, fieldType.asSubclass(Enum.class));
        }
        throw new IllegalArgumentException("Cannot synchronize field " + field);
    }

    private static <T extends Enum<T>> EnumField<T> createEnumField(Object source, Field field, Class<T> fieldType) {
        return new EnumField(source, field, (Enum[])fieldType.getEnumConstants());
    }

    private static class TextComponentField
    extends SynchronizedField<class_2561> {
        private TextComponentField(Object source, Field field) {
            super(source, field);
        }

        @Override
        protected void writeValue(class_2540 data, class_2561 value) {
            if (value == null) {
                data.writeBoolean(false);
            } else {
                data.writeBoolean(true);
                data.method_10805(value);
            }
        }

        @Override
        protected class_2561 readValue(class_2540 data) {
            if (data.readBoolean()) {
                return data.method_10808();
            }
            return null;
        }
    }

    private static class StringField
    extends SynchronizedField<String> {
        private StringField(Object source, Field field) {
            super(source, field);
        }

        @Override
        protected void writeValue(class_2540 data, String value) {
            data.method_10814(value);
        }

        @Override
        protected String readValue(class_2540 data) {
            return data.method_19772();
        }
    }

    private static class IntegerField
    extends SynchronizedField<Integer> {
        private IntegerField(Object source, Field field) {
            super(source, field);
        }

        @Override
        protected void writeValue(class_2540 data, Integer value) {
            data.writeInt(value.intValue());
        }

        @Override
        protected Integer readValue(class_2540 data) {
            return data.readInt();
        }
    }

    private static class LongField
    extends SynchronizedField<Long> {
        private LongField(Object source, Field field) {
            super(source, field);
        }

        @Override
        protected void writeValue(class_2540 data, Long value) {
            data.writeLong(value.longValue());
        }

        @Override
        protected Long readValue(class_2540 data) {
            return data.readLong();
        }
    }

    private static class BooleanField
    extends SynchronizedField<Boolean> {
        private BooleanField(Object source, Field field) {
            super(source, field);
        }

        @Override
        protected void writeValue(class_2540 data, Boolean value) {
            data.writeBoolean(value.booleanValue());
        }

        @Override
        protected Boolean readValue(class_2540 data) {
            return data.readBoolean();
        }
    }

    private static class EnumField<T extends Enum<T>>
    extends SynchronizedField<T> {
        private final T[] values;

        private EnumField(Object source, Field field, T[] values) {
            super(source, field);
            this.values = values;
        }

        @Override
        protected void writeValue(class_2540 data, T value) {
            if (value == null) {
                data.writeShort(-1);
            } else {
                data.writeShort((int)((short)((Enum)value).ordinal()));
            }
        }

        @Override
        protected T readValue(class_2540 data) {
            short ordinal = data.readShort();
            if (ordinal == -1) {
                return null;
            }
            return this.values[ordinal];
        }
    }
}

