/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.blockentity.crafting.PatternProviderBlockEntity;
import appeng.core.AELog;
import appeng.core.sync.packets.InterfaceTerminalPacket;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.helpers.InventoryAction;
import appeng.helpers.iface.PatternProviderLogic;
import appeng.helpers.iface.PatternProviderLogicHost;
import appeng.menu.AEBaseMenu;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.parts.crafting.PatternProviderPart;
import appeng.parts.reporting.PatternAccessTerminalPart;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public class InterfaceTerminalMenu
extends AEBaseMenu {
    public static final class_3917<InterfaceTerminalMenu> TYPE = MenuTypeBuilder.create(InterfaceTerminalMenu::new, PatternAccessTerminalPart.class).requirePermission(SecurityPermissions.BUILD).build("interfaceterminal");
    private static long inventorySerial = Long.MIN_VALUE;
    private final Map<PatternProviderLogicHost, InvTracker> diList = new IdentityHashMap<PatternProviderLogicHost, InvTracker>();
    private final Long2ObjectOpenHashMap<InvTracker> byId = new Long2ObjectOpenHashMap();

    public InterfaceTerminalMenu(int id, class_1661 ip, PatternAccessTerminalPart anchor) {
        this(TYPE, id, ip, anchor, true);
    }

    public InterfaceTerminalMenu(class_3917<?> menuType, int id, class_1661 ip, Object host, boolean bindInventory) {
        super(menuType, id, ip, host);
        if (bindInventory) {
            this.createPlayerInventorySlots(ip);
        }
    }

    @Override
    public void method_7623() {
        if (this.isClient()) {
            return;
        }
        super.method_7623();
        IGrid grid = this.getGrid();
        VisitorState state = new VisitorState();
        if (grid != null) {
            this.visitInterfaceHosts(grid, PatternProviderBlockEntity.class, state);
            this.visitInterfaceHosts(grid, PatternProviderPart.class, state);
        }
        if (state.total != this.diList.size() || state.forceFullUpdate) {
            this.sendFullUpdate(grid);
        } else {
            this.sendIncrementalUpdate();
        }
    }

    @Nullable
    private IGrid getGrid() {
        IGridNode agn;
        IActionHost host = this.getActionHost();
        if (host != null && (agn = host.getActionableNode()) != null && agn.isActive()) {
            return agn.getGrid();
        }
        return null;
    }

    private <T extends PatternProviderLogicHost> void visitInterfaceHosts(IGrid grid, Class<T> machineClass, VisitorState state) {
        for (PatternProviderLogicHost ih : grid.getActiveMachines(machineClass)) {
            PatternProviderLogic dual = ih.getLogic();
            if (dual.getConfigManager().getSetting(Settings.PATTERN_ACCESS_TERMINAL) == YesNo.NO) continue;
            InvTracker t = this.diList.get(ih);
            if (t == null || !t.name.equals(dual.getTermName())) {
                state.forceFullUpdate = true;
            }
            ++state.total;
        }
    }

    @Override
    public void doAction(class_3222 player, InventoryAction action, int slot, long id) {
        InvTracker inv = (InvTracker)this.byId.get(id);
        if (inv == null) {
            return;
        }
        if (slot < 0 || slot >= inv.server.size()) {
            AELog.warn("Client refers to invalid slot %d of inventory %s", slot, inv.name.getString());
            return;
        }
        class_1799 is = inv.server.getStackInSlot(slot);
        FilteredInternalInventory interfaceSlot = new FilteredInternalInventory(inv.server.getSlotInv(slot), new PatternSlotFilter());
        class_1799 carried = this.method_34255();
        switch (action) {
            case PICKUP_OR_SET_DOWN: {
                if (!carried.method_7960()) {
                    class_1799 inSlot = interfaceSlot.getStackInSlot(0);
                    if (inSlot.method_7960()) {
                        this.method_34254(interfaceSlot.addItems(carried));
                        break;
                    }
                    inSlot = inSlot.method_7972();
                    class_1799 inHand = carried.method_7972();
                    interfaceSlot.setItemDirect(0, class_1799.field_8037);
                    this.method_34254(class_1799.field_8037);
                    this.method_34254(interfaceSlot.addItems(inHand.method_7972()));
                    if (carried.method_7960()) {
                        this.method_34254(inSlot);
                        break;
                    }
                    this.method_34254(inHand);
                    interfaceSlot.setItemDirect(0, inSlot);
                    break;
                }
                this.method_34254(interfaceSlot.getStackInSlot(0));
                interfaceSlot.setItemDirect(0, class_1799.field_8037);
                break;
            }
            case SPLIT_OR_PLACE_SINGLE: {
                if (!carried.method_7960()) {
                    class_1799 extra = carried.method_7971(1);
                    if (!extra.method_7960()) {
                        extra = interfaceSlot.addItems(extra);
                    }
                    if (extra.method_7960()) break;
                    carried.method_7933(extra.method_7947());
                    break;
                }
                if (is.method_7960()) break;
                this.method_34254(interfaceSlot.extractItem(0, (is.method_7947() + 1) / 2, false));
                break;
            }
            case SHIFT_CLICK: {
                class_1799 stack = interfaceSlot.getStackInSlot(0).method_7972();
                if (!player.method_31548().method_7394(stack)) {
                    interfaceSlot.setItemDirect(0, stack);
                    break;
                }
                interfaceSlot.setItemDirect(0, class_1799.field_8037);
                break;
            }
            case MOVE_REGION: {
                for (int x = 0; x < inv.server.size(); ++x) {
                    class_1799 stack = inv.server.getStackInSlot(x);
                    if (!player.method_31548().method_7394(stack)) {
                        interfaceSlot.setItemDirect(0, stack);
                        continue;
                    }
                    interfaceSlot.setItemDirect(0, class_1799.field_8037);
                }
                break;
            }
            case CREATIVE_DUPLICATE: {
                if (!player.method_31549().field_7477 || !carried.method_7960()) break;
                this.method_34254(is.method_7960() ? class_1799.field_8037 : is.method_7972());
            }
        }
    }

    private void sendFullUpdate(@Nullable IGrid grid) {
        PatternProviderLogic dual;
        this.byId.clear();
        this.diList.clear();
        this.sendPacketToClient(InterfaceTerminalPacket.clearExistingData());
        if (grid == null) {
            return;
        }
        for (PatternProviderBlockEntity patternProviderBlockEntity : grid.getActiveMachines(PatternProviderBlockEntity.class)) {
            dual = patternProviderBlockEntity.getLogic();
            if (dual.getConfigManager().getSetting(Settings.PATTERN_ACCESS_TERMINAL) != YesNo.YES) continue;
            this.diList.put(patternProviderBlockEntity, new InvTracker(dual, dual.getPatternInv(), dual.getTermName()));
        }
        for (PatternProviderPart patternProviderPart : grid.getActiveMachines(PatternProviderPart.class)) {
            dual = patternProviderPart.getLogic();
            if (dual.getConfigManager().getSetting(Settings.PATTERN_ACCESS_TERMINAL) != YesNo.YES) continue;
            this.diList.put(patternProviderPart, new InvTracker(dual, dual.getPatternInv(), dual.getTermName()));
        }
        for (InvTracker invTracker : this.diList.values()) {
            this.byId.put(invTracker.serverId, (Object)invTracker);
            class_2487 data = new class_2487();
            this.addItems(data, invTracker, 0, invTracker.server.size());
            this.sendPacketToClient(InterfaceTerminalPacket.inventory(invTracker.serverId, data));
        }
    }

    private void sendIncrementalUpdate() {
        for (InvTracker inv : this.diList.values()) {
            class_2487 data = null;
            for (int x = 0; x < inv.server.size(); ++x) {
                if (!this.isDifferent(inv.server.getStackInSlot(x), inv.client.getStackInSlot(x))) continue;
                if (data == null) {
                    data = new class_2487();
                }
                this.addItems(data, inv, x, 1);
            }
            if (data == null) continue;
            this.sendPacketToClient(InterfaceTerminalPacket.inventory(inv.serverId, data));
        }
    }

    private boolean isDifferent(class_1799 a, class_1799 b) {
        if (a.method_7960() && b.method_7960()) {
            return false;
        }
        if (a.method_7960() || b.method_7960()) {
            return true;
        }
        return !class_1799.method_7973((class_1799)a, (class_1799)b);
    }

    private void addItems(class_2487 tag, InvTracker inv, int offset, int length) {
        if (tag.method_33133()) {
            tag.method_10544("sortBy", inv.sortBy);
            tag.method_10582("un", class_2561.class_2562.method_10867((class_2561)inv.name));
        }
        for (int x = 0; x < length; ++x) {
            class_2487 itemNBT = new class_2487();
            class_1799 is = inv.server.getStackInSlot(x + offset);
            inv.client.setItemDirect(x + offset, is.method_7960() ? class_1799.field_8037 : is.method_7972());
            if (!is.method_7960()) {
                is.method_7953(itemNBT);
            }
            tag.method_10566(Integer.toString(x + offset), (class_2520)itemNBT);
        }
    }

    private static class VisitorState {
        int total;
        boolean forceFullUpdate;

        private VisitorState() {
        }
    }

    private static class InvTracker {
        private final long sortBy;
        private final long serverId = inventorySerial++;
        private final class_2561 name;
        private final InternalInventory client;
        private final InternalInventory server;

        public InvTracker(PatternProviderLogic dual, InternalInventory patterns, class_2561 name) {
            this.server = patterns;
            this.client = new AppEngInternalInventory(this.server.size());
            this.name = name;
            this.sortBy = dual.getSortValue();
        }
    }

    private static class PatternSlotFilter
    implements IAEItemFilter {
        private PatternSlotFilter() {
        }

        @Override
        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return true;
        }

        @Override
        public boolean allowInsert(InternalInventory inv, int slot, class_1799 stack) {
            return !stack.method_7960() && stack.method_7909() instanceof EncodedPatternItem;
        }
    }
}

