/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.security.IActionHost;
import appeng.core.AppEng;
import appeng.helpers.ICustomNameObject;
import appeng.menu.AEBaseMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.util.Platform;
import com.google.common.base.Preconditions;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.screenhandler.v1.ScreenHandlerRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2596;
import net.minecraft.class_2815;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_634;

public final class MenuTypeBuilder<M extends AEBaseMenu, I> {
    @Nullable
    private class_2960 id;
    private final Class<I> hostInterface;
    private final MenuFactory<M, I> factory;
    private Function<I, class_2561> menuTitleStrategy = this::getDefaultMenuTitle;
    @Nullable
    private SecurityPermissions requiredPermission;
    @Nullable
    private InitialDataSerializer<I> initialDataSerializer;
    @Nullable
    private InitialDataDeserializer<M, I> initialDataDeserializer;
    private class_3917<M> menuType;

    private MenuTypeBuilder(Class<I> hostInterface, TypedMenuFactory<M, I> typedFactory) {
        this.hostInterface = hostInterface;
        this.factory = (containerId, playerInv, accessObj) -> (AEBaseMenu)((Object)((Object)typedFactory.create(this.menuType, containerId, playerInv, accessObj)));
    }

    private MenuTypeBuilder(Class<I> hostInterface, MenuFactory<M, I> factory) {
        this.hostInterface = hostInterface;
        this.factory = factory;
    }

    public static <C extends AEBaseMenu, I> MenuTypeBuilder<C, I> create(MenuFactory<C, I> factory, Class<I> hostInterface) {
        return new MenuTypeBuilder<C, I>(hostInterface, factory);
    }

    public static <C extends AEBaseMenu, I> MenuTypeBuilder<C, I> create(TypedMenuFactory<C, I> factory, Class<I> hostInterface) {
        return new MenuTypeBuilder<C, I>(hostInterface, factory);
    }

    public MenuTypeBuilder<M, I> requirePermission(SecurityPermissions permission) {
        this.requiredPermission = permission;
        return this;
    }

    public MenuTypeBuilder<M, I> withMenuTitle(Function<I, class_2561> menuTitleStrategy) {
        this.menuTitleStrategy = menuTitleStrategy;
        return this;
    }

    public MenuTypeBuilder<M, I> withInitialData(InitialDataSerializer<I> initialDataSerializer, InitialDataDeserializer<M, I> initialDataDeserializer) {
        this.initialDataSerializer = initialDataSerializer;
        this.initialDataDeserializer = initialDataDeserializer;
        return this;
    }

    private M fromNetwork(int containerId, class_1661 inv, class_2540 packetBuf) {
        MenuLocator locator = MenuLocators.readFromPacket(packetBuf);
        I host = locator.locate(inv.field_7546, this.hostInterface);
        if (host == null) {
            class_634 connection = class_310.method_1551().method_1562();
            if (connection != null) {
                connection.method_2883((class_2596)new class_2815(containerId));
            }
            throw new IllegalStateException("Couldn't find menu host at " + locator + " for " + this.id + " on client. Closing menu.");
        }
        AEBaseMenu menu = (AEBaseMenu)((Object)this.factory.create(containerId, inv, host));
        if (this.initialDataDeserializer != null) {
            this.initialDataDeserializer.deserializeInitialData(host, (M)((Object)menu), packetBuf);
        }
        return (M)((Object)menu);
    }

    private boolean open(class_1657 player, MenuLocator locator) {
        if (!(player instanceof class_3222)) {
            return false;
        }
        I accessInterface = locator.locate(player, this.hostInterface);
        if (accessInterface == null) {
            return false;
        }
        if (!this.checkPermission(player, accessInterface)) {
            return false;
        }
        class_2561 title = this.menuTitleStrategy.apply(accessInterface);
        player.method_17355((class_3908)new HandlerFactory(locator, title, accessInterface, this.initialDataSerializer));
        return true;
    }

    public class_3917<M> build(String id) {
        Preconditions.checkState((this.menuType == null ? 1 : 0) != 0, (Object)"build was already called");
        Preconditions.checkState((this.id == null ? 1 : 0) != 0, (Object)"id should not be set");
        this.id = AppEng.makeId(id);
        this.menuType = ScreenHandlerRegistry.registerExtended((class_2960)this.id, this::fromNetwork);
        MenuOpener.addOpener(this.menuType, this::open);
        return this.menuType;
    }

    private boolean checkPermission(class_1657 player, Object accessInterface) {
        if (this.requiredPermission != null && accessInterface instanceof IActionHost) {
            IActionHost actionHost = (IActionHost)accessInterface;
            return Platform.checkPermissions(player, actionHost, this.requiredPermission, false, true);
        }
        return true;
    }

    private class_2561 getDefaultMenuTitle(I accessInterface) {
        ICustomNameObject customNameObject;
        if (accessInterface instanceof ICustomNameObject && (customNameObject = (ICustomNameObject)accessInterface).hasCustomInventoryName()) {
            return customNameObject.getCustomInventoryName();
        }
        return class_2585.field_24366;
    }

    @FunctionalInterface
    public static interface TypedMenuFactory<C extends class_1703, I> {
        public C create(class_3917<C> var1, int var2, class_1661 var3, I var4);
    }

    @FunctionalInterface
    public static interface MenuFactory<C, I> {
        public C create(int var1, class_1661 var2, I var3);
    }

    @FunctionalInterface
    public static interface InitialDataSerializer<I> {
        public void serializeInitialData(I var1, class_2540 var2);
    }

    @FunctionalInterface
    public static interface InitialDataDeserializer<C, I> {
        public void deserializeInitialData(I var1, C var2, class_2540 var3);
    }

    private class HandlerFactory
    implements ExtendedScreenHandlerFactory {
        private final MenuLocator locator;
        private final I accessInterface;
        private final class_2561 title;
        private final InitialDataSerializer<I> initialDataSerializer;

        public HandlerFactory(MenuLocator locator, class_2561 title, I accessInterface, InitialDataSerializer<I> initialDataSerializer) {
            this.locator = locator;
            this.title = title;
            this.accessInterface = accessInterface;
            this.initialDataSerializer = initialDataSerializer;
        }

        public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
            MenuLocators.writeToPacket(buf, this.locator);
            if (this.initialDataSerializer != null) {
                this.initialDataSerializer.serializeInitialData(this.accessInterface, buf);
            }
        }

        public class_2561 method_5476() {
            return this.title;
        }

        @Nullable
        public class_1703 createMenu(int wnd, class_1661 inv, class_1657 p) {
            AEBaseMenu m = (AEBaseMenu)((Object)MenuTypeBuilder.this.factory.create(wnd, inv, this.accessInterface));
            m.setLocator(this.locator);
            return m;
        }
    }
}

