/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.helpers.iface.PatternProviderLogic;
import appeng.helpers.iface.PatternProviderLogicHost;
import appeng.helpers.iface.PatternProviderReturnInventory;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.util.ConfigMenuInventory;
import net.minecraft.class_1661;
import net.minecraft.class_3917;

public class PatternProviderMenu
extends AEBaseMenu {
    public static final class_3917<PatternProviderMenu> TYPE = MenuTypeBuilder.create(PatternProviderMenu::new, PatternProviderLogicHost.class).requirePermission(SecurityPermissions.BUILD).build("pattern_provider");
    private final PatternProviderLogic logic;
    @GuiSync(value=3)
    public YesNo blockingMode = YesNo.NO;
    @GuiSync(value=4)
    public YesNo showInAccessTerminal = YesNo.YES;

    public PatternProviderMenu(int id, class_1661 playerInventory, PatternProviderLogicHost host) {
        super(TYPE, id, playerInventory, host);
        this.createPlayerInventorySlots(playerInventory);
        this.logic = host.getLogic();
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.ENCODED_PATTERN, this.logic.getPatternInv(), x), SlotSemantics.ENCODED_PATTERN);
        }
        ConfigMenuInventory returnInv = this.logic.getReturnInv().createMenuWrapper();
        for (int i = 0; i < PatternProviderReturnInventory.NUMBER_OF_SLOTS; ++i) {
            if (i >= returnInv.size()) continue;
            this.addSlot(new AppEngSlot(returnInv, i), SlotSemantics.STORAGE);
        }
    }

    @Override
    public void method_7623() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (this.isServer()) {
            this.blockingMode = this.logic.getConfigManager().getSetting(Settings.BLOCKING_MODE);
            this.showInAccessTerminal = this.logic.getConfigManager().getSetting(Settings.PATTERN_ACCESS_TERMINAL);
        }
        super.method_7623();
    }

    public GenericStackInv getReturnInv() {
        return this.logic.getReturnInv();
    }

    public YesNo getBlockingMode() {
        return this.blockingMode;
    }

    public YesNo getShowInAccessTerminal() {
        return this.showInAccessTerminal;
    }
}

