/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.features.GridLinkables;
import appeng.api.features.IGridLinkableHandler;
import appeng.api.implementations.items.IBiometricCard;
import appeng.api.inventories.InternalInventory;
import appeng.api.storage.ITerminalHost;
import appeng.blockentity.misc.SecurityStationBlockEntity;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.slot.OutputSlot;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_3917;

public class SecurityStationMenu
extends MEStorageMenu
implements InternalInventoryHost {
    private static final String ACTION_TOGGLE_PERMISSION = "togglePermission";
    public static final class_3917<SecurityStationMenu> TYPE = MenuTypeBuilder.create(SecurityStationMenu::new, ITerminalHost.class).requirePermission(SecurityPermissions.SECURITY).build("securitystation");
    private final RestrictedInputSlot configSlot;
    private final RestrictedInputSlot linkableIn;
    private final OutputSlot linkableOut;
    private final SecurityStationBlockEntity securityBox;
    @GuiSync(value=0)
    public int permissionMode = 0;

    public SecurityStationMenu(int id, class_1661 ip, ITerminalHost monitorable) {
        super(TYPE, id, ip, monitorable, true);
        this.securityBox = (SecurityStationBlockEntity)monitorable;
        this.configSlot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.BIOMETRIC_CARD, this.securityBox.getConfigSlot(), 0);
        this.addSlot(this.configSlot, SlotSemantics.BIOMETRIC_CARD);
        AppEngInternalInventory gridLinkingInv = new AppEngInternalInventory(this, 2);
        this.linkableIn = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.GRID_LINKABLE_ITEM, gridLinkingInv, 0);
        this.addSlot(this.linkableIn, SlotSemantics.MACHINE_INPUT);
        this.linkableOut = new OutputSlot(gridLinkingInv, 1, null);
        this.addSlot(this.linkableOut, SlotSemantics.MACHINE_OUTPUT);
        this.registerClientAction(ACTION_TOGGLE_PERMISSION, SecurityPermissions.class, this::toggleSetting);
    }

    public void toggleSetting(SecurityPermissions permission) {
        class_1792 class_17922;
        if (this.isClient()) {
            this.sendClientAction(ACTION_TOGGLE_PERMISSION, permission);
            return;
        }
        class_1799 a = this.configSlot.method_7677();
        if (!a.method_7960() && (class_17922 = a.method_7909()) instanceof IBiometricCard) {
            IBiometricCard bc = (IBiometricCard)class_17922;
            if (bc.hasPermission(a, permission)) {
                bc.removePermission(a, permission);
            } else {
                bc.addPermission(a, permission);
            }
        }
    }

    @Override
    public void method_7623() {
        Object object;
        this.verifyPermissions(SecurityPermissions.SECURITY, false);
        this.setPermissionMode(0);
        class_1799 a = this.configSlot.method_7677();
        if (!a.method_7960() && (object = a.method_7909()) instanceof IBiometricCard) {
            IBiometricCard bc = (IBiometricCard)object;
            for (SecurityPermissions sp : bc.getPermissions(a)) {
                this.setPermissionMode(this.getPermissionMode() | 1 << sp.ordinal());
            }
        }
        this.updatePowerStatus();
        super.method_7623();
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        if (this.linkableIn.method_7681()) {
            player.method_7328(this.linkableIn.method_7677(), false);
        }
        if (this.linkableOut.method_7681()) {
            player.method_7328(this.linkableOut.method_7677(), false);
        }
    }

    @Override
    public void saveChanges() {
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        class_1799 term;
        IGridLinkableHandler handler;
        if (!this.linkableOut.method_7681() && this.linkableIn.method_7681() && (handler = GridLinkables.get((class_1935)(term = this.linkableIn.method_7677().method_7972()).method_7909())) != null && handler.canLink(term)) {
            handler.link(term, this.securityBox.getSecurityKey());
            this.linkableIn.method_7673(class_1799.field_8037);
            this.linkableOut.method_7673(term);
        }
    }

    public int getPermissionMode() {
        return this.permissionMode;
    }

    private void setPermissionMode(int permissionMode) {
        this.permissionMode = permissionMode;
    }

    @Override
    protected boolean showsCraftables() {
        return false;
    }
}

