/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.crafting;

import appeng.api.config.Actionable;
import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingPlan;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyMap;
import appeng.api.storage.MEStorage;
import appeng.menu.me.crafting.CraftingPlanSummaryEntry;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2540;

public class CraftingPlanSummary {
    private final long usedBytes;
    private final boolean simulation;
    private final List<CraftingPlanSummaryEntry> entries;

    public CraftingPlanSummary(long usedBytes, boolean simulation, List<CraftingPlanSummaryEntry> entries) {
        this.usedBytes = usedBytes;
        this.simulation = simulation;
        this.entries = entries;
    }

    public long getUsedBytes() {
        return this.usedBytes;
    }

    public boolean isSimulation() {
        return this.simulation;
    }

    public List<CraftingPlanSummaryEntry> getEntries() {
        return this.entries;
    }

    public void write(class_2540 buffer) {
        buffer.method_10791(this.usedBytes);
        buffer.writeBoolean(this.simulation);
        buffer.method_10804(this.entries.size());
        for (CraftingPlanSummaryEntry entry : this.entries) {
            entry.write(buffer);
        }
    }

    public static CraftingPlanSummary read(class_2540 buffer) {
        long bytesUsed = buffer.method_10792();
        boolean simulation = buffer.readBoolean();
        int entryCount = buffer.method_10816();
        ImmutableList.Builder entries = ImmutableList.builder();
        for (int i = 0; i < entryCount; ++i) {
            entries.add((Object)CraftingPlanSummaryEntry.read(buffer));
        }
        return new CraftingPlanSummary(bytesUsed, simulation, (List<CraftingPlanSummaryEntry>)entries.build());
    }

    public static CraftingPlanSummary fromJob(IGrid grid, IActionSource actionSource, ICraftingPlan job) {
        KeyMap<AEKey, KeyStats> plan = new KeyMap<AEKey, KeyStats>(null, KeyStats::new);
        for (Object2LongMap.Entry<AEKey> entry : job.usedItems()) {
            plan.mapping((AEKey)entry.getKey()).stored += entry.getLongValue();
        }
        for (Object2LongMap.Entry<AEKey> entry : job.missingItems()) {
            plan.mapping((AEKey)entry.getKey()).stored += entry.getLongValue();
        }
        for (Object2LongMap.Entry<AEKey> entry : job.emittedItems()) {
            GenericStack[] entry2 = plan.mapping((AEKey)entry.getKey());
            entry2.stored += entry.getLongValue();
            entry2.crafting += entry.getLongValue();
        }
        for (Map.Entry entry : job.patternTimes().entrySet()) {
            for (GenericStack out : ((IPatternDetails)entry.getKey()).getOutputs()) {
                plan.mapping(out.what()).crafting += out.amount() * (Long)entry.getValue();
            }
        }
        ImmutableList.Builder entries = ImmutableList.builder();
        MEStorage mEStorage = grid.getStorageService().getInventory();
        ICraftingService crafting = grid.getCraftingService();
        for (Map.Entry entry : plan) {
            long missingAmount;
            long storedAmount;
            if (job.simulation() && !crafting.canEmitFor((AEKey)entry.getKey())) {
                storedAmount = mEStorage.extract((AEKey)entry.getKey(), entry.getValue().stored, Actionable.SIMULATE, actionSource);
                missingAmount = entry.getValue().stored - storedAmount;
            } else {
                storedAmount = entry.getValue().stored;
                missingAmount = 0L;
            }
            long craftAmount = entry.getValue().crafting;
            entries.add((Object)new CraftingPlanSummaryEntry((AEKey)entry.getKey(), missingAmount, storedAmount, craftAmount));
        }
        return new CraftingPlanSummary(job.bytes(), job.simulation(), (List<CraftingPlanSummaryEntry>)entries.build());
    }

    private static class KeyStats {
        public long stored;
        public long crafting;

        private KeyStats() {
        }
    }
}

