/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.crafting;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.storage.ITerminalHost;
import appeng.menu.ISubMenu;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.me.crafting.CraftingCPUCycler;
import appeng.menu.me.crafting.CraftingCPUMenu;
import appeng.menu.me.crafting.CraftingCPURecord;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_3917;

public class CraftingStatusMenu
extends CraftingCPUMenu
implements ISubMenu {
    private static final String ACTION_CYCLE_CPU = "cycleCpu";
    public static final class_3917<CraftingStatusMenu> TYPE = MenuTypeBuilder.create(CraftingStatusMenu::new, ITerminalHost.class).requirePermission(SecurityPermissions.CRAFT).build("craftingstatus");
    private final CraftingCPUCycler cpuCycler = new CraftingCPUCycler(this::cpuMatches, this::onCPUSelectionChanged);
    @GuiSync(value=6)
    public boolean noCPU = true;
    @GuiSync(value=7)
    public class_2561 cpuName;
    private final ITerminalHost host;

    public CraftingStatusMenu(int id, class_1661 ip, ITerminalHost host) {
        super(TYPE, id, ip, host);
        this.host = host;
        this.registerClientAction(ACTION_CYCLE_CPU, Boolean.class, this::cycleSelectedCPU);
    }

    @Override
    public ITerminalHost getHost() {
        return this.host;
    }

    @Override
    public void method_7623() {
        IGrid network = this.getGrid();
        if (this.isServer() && network != null) {
            this.cpuCycler.detectAndSendChanges(network);
        }
        super.method_7623();
    }

    @Override
    public boolean allowConfiguration() {
        return false;
    }

    private boolean cpuMatches(ICraftingCPU c) {
        return c.isBusy();
    }

    private void onCPUSelectionChanged(CraftingCPURecord cpuRecord, boolean cpusAvailable) {
        boolean bl = this.noCPU = !cpusAvailable;
        if (cpuRecord == null) {
            this.cpuName = null;
            this.setCPU(null);
        } else {
            this.cpuName = cpuRecord.getName();
            this.setCPU(cpuRecord.getCpu());
        }
    }

    public void cycleSelectedCPU(boolean forward) {
        if (this.isClient()) {
            this.sendClientAction(ACTION_CYCLE_CPU, forward);
        } else {
            this.cpuCycler.cycleCpu(forward);
        }
    }
}

