/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.items;

import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.StorageHelper;
import appeng.core.definitions.AEItems;
import appeng.core.sync.packets.PatternSlotPacket;
import appeng.crafting.pattern.AECraftingPattern;
import appeng.helpers.IMenuCraftingPacket;
import appeng.helpers.IPatternTerminalHost;
import appeng.items.storage.ViewCellItem;
import appeng.me.helpers.MachineSource;
import appeng.menu.NullMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.me.items.SetProcessingPatternAmountMenu;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.FakeCraftingMatrixSlot;
import appeng.menu.slot.FakeSlot;
import appeng.menu.slot.IOptionalSlotHost;
import appeng.menu.slot.OptionalFakeSlot;
import appeng.menu.slot.PatternOutputsSlot;
import appeng.menu.slot.PatternTermSlot;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.parts.encoding.EncodingMode;
import appeng.util.Platform;
import appeng.util.inv.CarriedItemInventory;
import appeng.util.inv.PlayerInternalInventory;
import appeng.util.prioritylist.IPartitionList;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1731;
import net.minecraft.class_1734;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class PatternEncodingTermMenu
extends MEStorageMenu
implements IOptionalSlotHost,
IMenuCraftingPacket {
    private static final String ACTION_SET_MODE = "setMode";
    private static final String ACTION_ENCODE = "encode";
    private static final String ACTION_CLEAR = "clear";
    private static final String ACTION_SET_SUBSTITUTION = "setSubstitution";
    private static final String ACTION_SET_FLUID_SUBSTITUTION = "setFluidSubstitution";
    private static final String ACTION_SHOW_MODIFY_AMOUNT_MENU = "showModifyAmountMenu";
    private static final String ACTION_CYCLE_PROCESSING_OUTPUT = "cycleProcessingOutput";
    private static final int GROUP_SECONDARY_OUTPUT = 1;
    private static final int GROUP_CRAFTING_RESULT = 2;
    public static class_3917<PatternEncodingTermMenu> TYPE = MenuTypeBuilder.create(PatternEncodingTermMenu::new, ITerminalHost.class).requirePermission(SecurityPermissions.CRAFT).build("patternterm");
    private final IPatternTerminalHost patternTerminal;
    private final InternalInventory craftingGridInv;
    private final FakeCraftingMatrixSlot[] craftingGridSlots = new FakeCraftingMatrixSlot[9];
    private final OptionalFakeSlot[] processingOutputSlots = new OptionalFakeSlot[3];
    private final PatternTermSlot craftOutputSlot;
    private final RestrictedInputSlot blankPatternSlot;
    private final RestrictedInputSlot encodedPatternSlot;
    private class_3955 currentRecipe;
    private EncodingMode currentMode;
    @GuiSync(value=97)
    public EncodingMode mode = EncodingMode.CRAFTING;
    @GuiSync(value=96)
    public boolean substitute = false;
    @GuiSync(value=95)
    public boolean substituteFluids = true;
    public IntSet slotsSupportingFluidSubstitution = new IntArraySet();

    public PatternEncodingTermMenu(int id, class_1661 ip, ITerminalHost host) {
        this(TYPE, id, ip, host, true);
    }

    public PatternEncodingTermMenu(class_3917<?> menuType, int id, class_1661 ip, ITerminalHost host, boolean bindInventory) {
        super(menuType, id, ip, host, bindInventory);
        int i;
        this.patternTerminal = (IPatternTerminalHost)host;
        InternalInventory patternInv = this.getPatternTerminal().getSubInventory(ISegmentedInventory.PATTERNS);
        InternalInventory output = this.getPatternTerminal().getSubInventory(IPatternTerminalHost.INV_OUTPUT);
        this.craftingGridInv = this.getPatternTerminal().getSubInventory(IPatternTerminalHost.INV_CRAFTING);
        for (i = 0; i < 9; ++i) {
            this.craftingGridSlots[i] = new FakeCraftingMatrixSlot(this.craftingGridInv, i);
            this.addSlot(this.craftingGridSlots[i], SlotSemantics.CRAFTING_GRID);
        }
        this.craftOutputSlot = new PatternTermSlot(ip.field_7546, this.getActionSource(), this.powerSource, host.getInventory(), this.craftingGridInv, patternInv, this, 2, this);
        this.addSlot(this.craftOutputSlot, SlotSemantics.CRAFTING_RESULT);
        this.craftOutputSlot.setIcon(null);
        this.processingOutputSlots[0] = new PatternOutputsSlot(output, this, 0, 1);
        this.addSlot(this.processingOutputSlots[0], SlotSemantics.PROCESSING_PRIMARY_RESULT);
        this.processingOutputSlots[1] = new PatternOutputsSlot(output, this, 1, 1);
        this.addSlot(this.processingOutputSlots[1], SlotSemantics.PROCESSING_FIRST_OPTIONAL_RESULT);
        this.processingOutputSlots[2] = new PatternOutputsSlot(output, this, 2, 1);
        this.addSlot(this.processingOutputSlots[2], SlotSemantics.PROCESSING_SECOND_OPTIONAL_RESULT);
        for (i = 0; i < 3; ++i) {
            this.processingOutputSlots[i].setRenderDisabled(false);
            this.processingOutputSlots[i].setIcon(null);
        }
        this.blankPatternSlot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.BLANK_PATTERN, patternInv, 0);
        this.addSlot(this.blankPatternSlot, SlotSemantics.BLANK_PATTERN);
        this.encodedPatternSlot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.ENCODED_PATTERN, patternInv, 1);
        this.addSlot(this.encodedPatternSlot, SlotSemantics.ENCODED_PATTERN);
        this.encodedPatternSlot.setStackLimit(1);
        this.registerClientAction(ACTION_ENCODE, this::encode);
        this.registerClientAction(ACTION_CLEAR, this::clear);
        this.registerClientAction(ACTION_SET_MODE, EncodingMode.class, this.getPatternTerminal()::setMode);
        this.registerClientAction(ACTION_SET_SUBSTITUTION, Boolean.class, this.getPatternTerminal()::setSubstitution);
        this.registerClientAction(ACTION_SET_FLUID_SUBSTITUTION, Boolean.class, this.getPatternTerminal()::setFluidSubstitution);
        this.registerClientAction(ACTION_SHOW_MODIFY_AMOUNT_MENU, Integer.class, this::showModifyAmountMenu);
        this.registerClientAction(ACTION_CYCLE_PROCESSING_OUTPUT, this::cycleProcessingOutput);
    }

    public void method_7619(int slotID, int stateId, class_1799 stack) {
        super.method_7619(slotID, stateId, stack);
        this.getAndUpdateOutput();
    }

    private class_1799 getAndUpdateOutput() {
        class_1937 level = this.getPlayerInventory().field_7546.field_6002;
        class_1715 ic = new class_1715((class_1703)this, 3, 3);
        boolean invalidIngredients = false;
        for (int x = 0; x < ic.method_5439(); ++x) {
            class_1799 stack = this.unwrapCraftingIngredient(this.craftingGridInv.getStackInSlot(x));
            if (stack != null) {
                ic.method_5447(x, stack);
                continue;
            }
            invalidIngredients = true;
        }
        if (this.currentRecipe == null || !this.currentRecipe.method_8115((class_1263)ic, level)) {
            this.currentRecipe = invalidIngredients ? null : (class_3955)level.method_8433().method_8132(class_3956.field_17545, (class_1263)ic, level).orElse(null);
            this.currentMode = this.mode;
            this.checkFluidSubstitutionSupport();
        }
        class_1799 is = this.currentRecipe == null ? class_1799.field_8037 : this.currentRecipe.method_8116((class_1263)ic);
        this.craftOutputSlot.setDisplayedCraftingOutput(is);
        return is;
    }

    private void checkFluidSubstitutionSupport() {
        IPatternDetails decodedPattern;
        this.slotsSupportingFluidSubstitution.clear();
        if (this.currentRecipe == null) {
            return;
        }
        class_1799 encodedPattern = this.encodePattern();
        if (encodedPattern != null && (decodedPattern = PatternDetailsHelper.decodePattern(encodedPattern, this.getPlayerInventory().field_7546.field_6002)) instanceof AECraftingPattern) {
            AECraftingPattern craftingPattern = (AECraftingPattern)decodedPattern;
            for (int i = 0; i < craftingPattern.getSparseInputs().length; ++i) {
                if (craftingPattern.getValidFluid(i) == null) continue;
                this.slotsSupportingFluidSubstitution.add(i);
            }
        }
    }

    public void encode() {
        if (this.isClient()) {
            this.sendClientAction(ACTION_ENCODE);
            return;
        }
        class_1799 encodedPattern = this.encodePattern();
        if (encodedPattern != null) {
            class_1799 encodeOutput = this.encodedPatternSlot.method_7677();
            if (!(encodeOutput.method_7960() || PatternDetailsHelper.isEncodedPattern(encodeOutput) || AEItems.BLANK_PATTERN.isSameAs(encodeOutput))) {
                return;
            }
            if (encodeOutput.method_7960()) {
                class_1799 blankPattern = this.blankPatternSlot.method_7677();
                if (!this.isPattern(blankPattern)) {
                    return;
                }
                blankPattern.method_7934(1);
                if (blankPattern.method_7947() <= 0) {
                    this.blankPatternSlot.method_7673(class_1799.field_8037);
                }
            }
            this.encodedPatternSlot.method_7673(encodedPattern);
        } else {
            this.clearPattern();
        }
    }

    private void clearPattern() {
        class_1799 encodedPattern = this.encodedPatternSlot.method_7677();
        if (PatternDetailsHelper.isEncodedPattern(encodedPattern)) {
            this.encodedPatternSlot.method_7673(AEItems.BLANK_PATTERN.stack(encodedPattern.method_7947()));
        }
    }

    @Nullable
    private class_1799 encodePattern() {
        if (this.mode == EncodingMode.CRAFTING) {
            return this.encodeCraftingPattern();
        }
        return this.encodeProcessingPattern();
    }

    @Nullable
    private class_1799 encodeCraftingPattern() {
        class_1799[] ingredients = new class_1799[this.craftingGridSlots.length];
        boolean valid = false;
        for (int x = 0; x < this.craftingGridSlots.length; ++x) {
            ingredients[x] = this.unwrapCraftingIngredient(this.craftingGridSlots[x].method_7677());
            if (ingredients[x] == null) {
                return null;
            }
            if (ingredients[x].method_7960()) continue;
            valid = true;
        }
        if (!valid) {
            return null;
        }
        class_1799 result = this.getAndUpdateOutput();
        if (result.method_7960() || this.currentRecipe == null) {
            return null;
        }
        return PatternDetailsHelper.encodeCraftingPattern(this.currentRecipe, ingredients, result, this.isSubstitute(), this.isSubstituteFluids());
    }

    @Nullable
    private class_1799 encodeProcessingPattern() {
        GenericStack[] inputs = new GenericStack[this.craftingGridSlots.length];
        boolean valid = false;
        for (int x = 0; x < this.craftingGridSlots.length; ++x) {
            inputs[x] = GenericStack.fromItemStack(this.craftingGridSlots[x].method_7677());
            if (inputs[x] == null) continue;
            valid = true;
        }
        if (!valid) {
            return null;
        }
        GenericStack[] outputs = new GenericStack[3];
        for (int i = 0; i < this.processingOutputSlots.length; ++i) {
            outputs[i] = GenericStack.fromItemStack(this.processingOutputSlots[i].method_7677());
        }
        if (outputs[0] == null) {
            return null;
        }
        return PatternDetailsHelper.encodeProcessingPattern(inputs, outputs);
    }

    @Nullable
    private class_1799 unwrapCraftingIngredient(class_1799 ingredient) {
        GenericStack unwrapped = GenericStack.unwrapItemStack(ingredient);
        if (unwrapped != null) {
            AEKey aEKey = unwrapped.what();
            if (aEKey instanceof AEItemKey) {
                AEItemKey itemKey = (AEItemKey)aEKey;
                return itemKey.toStack(1);
            }
            return null;
        }
        return ingredient;
    }

    private boolean isPattern(class_1799 output) {
        if (output.method_7960()) {
            return false;
        }
        return AEItems.BLANK_PATTERN.isSameAs(output);
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        EncodingMode effectiveMode;
        EncodingMode encodingMode = effectiveMode = this.isServer() ? this.getPatternTerminal().getMode() : this.mode;
        if (idx == 1) {
            return this.mode == EncodingMode.PROCESSING;
        }
        if (idx == 2) {
            return this.mode == EncodingMode.CRAFTING;
        }
        return false;
    }

    public void craftOrGetItem(PatternSlotPacket packetPatternSlot) {
        class_1799 what = packetPatternSlot.what;
        if (what.method_7960() || this.storage == null || !this.isPowered()) {
            return;
        }
        InternalInventory inv = new CarriedItemInventory(this);
        PlayerInternalInventory playerInv = new PlayerInternalInventory(this.getPlayerInventory());
        if (packetPatternSlot.intoPlayerInv) {
            inv = playerInv;
        }
        if (!inv.simulateAdd(what).method_7960()) {
            return;
        }
        AEItemKey itemKey = AEItemKey.of(what);
        int amount = class_3532.method_15340((int)what.method_7947(), (int)1, (int)what.method_7909().method_7882());
        long extracted = StorageHelper.poweredExtraction(this.powerSource, this.storage, itemKey, amount, this.getActionSource());
        class_1657 p = this.getPlayerInventory().field_7546;
        if (extracted > 0L) {
            what.method_7939(amount);
            inv.addItems(what);
            this.method_7623();
            return;
        }
        class_1715 ic = new class_1715((class_1703)new NullMenu(), 3, 3);
        class_1715 real = new class_1715((class_1703)new NullMenu(), 3, 3);
        for (int x = 0; x < 9; ++x) {
            ic.method_5447(x, packetPatternSlot.pattern[x]);
        }
        class_3955 r = p.field_6002.method_8433().method_8132(class_3956.field_17545, (class_1263)ic, p.field_6002).orElse(null);
        if (r == null) {
            return;
        }
        KeyCounter all = this.getPreviousAvailableStacks();
        class_1799 is = r.method_8116((class_1263)ic);
        IPartitionList partitionFilter = ViewCellItem.createItemFilter(this.getViewCells());
        for (int x = 0; x < ic.method_5439(); ++x) {
            if (ic.method_5438(x).method_7960()) continue;
            class_1799 pulled = Platform.extractItemsByRecipe(this.powerSource, this.getActionSource(), this.storage, p.field_6002, (class_1860<class_1715>)r, is, ic, ic.method_5438(x), x, all, Actionable.MODULATE, partitionFilter);
            real.method_5447(x, pulled);
        }
        class_3955 rr = p.field_6002.method_8433().method_8132(class_3956.field_17545, (class_1263)real, p.field_6002).orElse(null);
        if (rr == r && class_1799.method_31577((class_1799)rr.method_8116((class_1263)real), (class_1799)is)) {
            class_1731 craftingResult = new class_1731();
            craftingResult.method_7662((class_1860)rr);
            class_1734 sc = new class_1734(p, real, (class_1263)craftingResult, 0, 0, 0);
            sc.method_7667(p, is);
            for (int x = 0; x < real.method_5439(); ++x) {
                class_1799 failed = playerInv.addItems(real.method_5438(x));
                if (failed.method_7960()) continue;
                p.method_7328(failed, false);
            }
            inv.addItems(is);
            this.method_7623();
        } else {
            for (int x = 0; x < real.method_5439(); ++x) {
                class_1799 failed = real.method_5438(x);
                if (failed.method_7960()) continue;
                this.storage.insert(AEItemKey.of(failed), failed.method_7947(), Actionable.MODULATE, new MachineSource(this.getPatternTerminal()));
            }
        }
    }

    @Override
    public void method_7623() {
        super.method_7623();
        if (this.isServer()) {
            if (this.mode != this.getPatternTerminal().getMode()) {
                this.setMode(this.getPatternTerminal().getMode());
            }
            this.substitute = this.patternTerminal.isSubstitution();
            this.substituteFluids = this.patternTerminal.isFluidSubstitution();
        }
    }

    @Override
    public void onServerDataSync() {
        super.onServerDataSync();
        for (FakeCraftingMatrixSlot slot : this.craftingGridSlots) {
            slot.setHideAmount(this.mode == EncodingMode.CRAFTING);
        }
        if (this.currentMode != this.mode) {
            this.getAndUpdateOutput();
        }
    }

    @Override
    public void onSlotChange(class_1735 s) {
        if (s == this.encodedPatternSlot && this.isServer()) {
            this.method_7623();
        }
        if (s == this.craftOutputSlot && this.isClient()) {
            this.getAndUpdateOutput();
        }
    }

    public void clear() {
        if (this.isClient()) {
            this.sendClientAction(ACTION_CLEAR);
            return;
        }
        for (FakeCraftingMatrixSlot fakeCraftingMatrixSlot : this.craftingGridSlots) {
            fakeCraftingMatrixSlot.method_7673(class_1799.field_8037);
        }
        for (FakeSlot fakeSlot : this.processingOutputSlots) {
            fakeSlot.method_7673(class_1799.field_8037);
        }
        this.method_7623();
        this.getAndUpdateOutput();
    }

    @Override
    public InternalInventory getCraftingMatrix() {
        return this.craftingGridInv;
    }

    @Override
    public boolean useRealItems() {
        return false;
    }

    public EncodingMode getMode() {
        return this.mode;
    }

    public void setMode(EncodingMode mode) {
        if (this.isClient()) {
            this.sendClientAction(ACTION_SET_MODE, mode);
        } else {
            this.mode = mode;
        }
    }

    public IPatternTerminalHost getPatternTerminal() {
        return this.patternTerminal;
    }

    public boolean isSubstitute() {
        return this.substitute;
    }

    public void setSubstitute(boolean substitute) {
        if (this.isClient()) {
            this.sendClientAction(ACTION_SET_SUBSTITUTION, substitute);
        } else {
            this.substitute = substitute;
        }
    }

    public boolean isSubstituteFluids() {
        return this.substituteFluids;
    }

    public void setSubstituteFluids(boolean substituteFluids) {
        if (this.isClient()) {
            this.sendClientAction(ACTION_SET_FLUID_SUBSTITUTION, substituteFluids);
        } else {
            this.substituteFluids = substituteFluids;
        }
    }

    @Override
    protected class_1799 transferStackToMenu(class_1799 input) {
        if (this.blankPatternSlot.method_7680(input) && (input = this.blankPatternSlot.method_32756(input)).method_7960()) {
            return class_1799.field_8037;
        }
        if (this.encodedPatternSlot.method_7680(input) && (input = this.encodedPatternSlot.method_32756(input)).method_7960()) {
            return class_1799.field_8037;
        }
        return super.transferStackToMenu(input);
    }

    @Contract(value="null -> false")
    public boolean canModifyAmountForSlot(@Nullable class_1735 slot) {
        return this.isProcessingPatternSlot(slot) && slot.method_7681();
    }

    @Contract(value="null -> false")
    public boolean isProcessingPatternSlot(@Nullable class_1735 slot) {
        if (slot == null || this.mode != EncodingMode.PROCESSING) {
            return false;
        }
        for (OptionalFakeSlot optionalFakeSlot : this.processingOutputSlots) {
            if (optionalFakeSlot != slot) continue;
            return true;
        }
        for (FakeSlot fakeSlot : this.craftingGridSlots) {
            if (fakeSlot != slot) continue;
            return true;
        }
        return false;
    }

    public FakeCraftingMatrixSlot[] getCraftingGridSlots() {
        return this.craftingGridSlots;
    }

    public OptionalFakeSlot[] getProcessingOutputSlots() {
        return this.processingOutputSlots;
    }

    public void showModifyAmountMenu(int slotIdx) {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_SHOW_MODIFY_AMOUNT_MENU, slotIdx);
        } else {
            class_1735 slot = (class_1735)this.field_7761.get(slotIdx);
            if (!this.canModifyAmountForSlot(slot) || !(slot instanceof AppEngSlot)) {
                return;
            }
            AppEngSlot aeSlot = (AppEngSlot)slot;
            SetProcessingPatternAmountMenu.open((class_3222)this.getPlayer(), this.getLocator(), aeSlot.getSlotInv());
        }
    }

    public void cycleProcessingOutput() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_CYCLE_PROCESSING_OUTPUT);
        } else {
            int i;
            if (this.mode != EncodingMode.PROCESSING) {
                return;
            }
            class_1799[] newOutputs = new class_1799[this.getProcessingOutputSlots().length];
            block0: for (i = 0; i < this.processingOutputSlots.length; ++i) {
                newOutputs[i] = class_1799.field_8037;
                if (this.processingOutputSlots[i].method_7677().method_7960()) continue;
                for (int j = 1; j < this.processingOutputSlots.length; ++j) {
                    class_1799 nextItem = this.processingOutputSlots[(i + j) % this.processingOutputSlots.length].method_7677();
                    if (nextItem.method_7960()) continue;
                    newOutputs[i] = nextItem;
                    continue block0;
                }
            }
            for (i = 0; i < newOutputs.length; ++i) {
                this.processingOutputSlots[i].method_7673(newOutputs[i]);
            }
        }
    }

    public boolean canCycleProcessingOutputs() {
        return this.mode == EncodingMode.PROCESSING && Arrays.stream(this.processingOutputSlots).filter(s -> !s.method_7677().method_7960()).count() > 1L;
    }
}

