/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.items;

import appeng.api.config.SecurityPermissions;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.helpers.IPatternTerminalHost;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.locator.MenuLocator;
import appeng.menu.slot.InaccessibleSlot;
import appeng.parts.encoding.EncodingMode;
import appeng.util.inv.AppEngInternalInventory;
import com.google.common.primitives.Ints;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3917;

public class SetProcessingPatternAmountMenu
extends AEBaseMenu
implements ISubMenu {
    public static final class_3917<SetProcessingPatternAmountMenu> TYPE = MenuTypeBuilder.create(SetProcessingPatternAmountMenu::new, IPatternTerminalHost.class).requirePermission(SecurityPermissions.BUILD).build("set_processing_pattern_amount");
    public static final String ACTION_SET_AMOUNT = "setAmount";
    private final class_1735 visualSlot;
    @GuiSync(value=1)
    private int initialAmount = -1;
    @GuiSync(value=2)
    private int maxAmount = -1;
    private InternalInventory slotInv;
    private final IPatternTerminalHost host;

    public SetProcessingPatternAmountMenu(int id, class_1661 ip, IPatternTerminalHost host) {
        super(TYPE, id, ip, host);
        this.registerClientAction(ACTION_SET_AMOUNT, Integer.class, this::confirm);
        this.host = host;
        this.visualSlot = new InaccessibleSlot(new AppEngInternalInventory(1), 0);
        this.addSlot(this.visualSlot, SlotSemantics.MACHINE_OUTPUT);
    }

    @Override
    public IPatternTerminalHost getHost() {
        return this.host;
    }

    public static void open(class_3222 player, MenuLocator locator, InternalInventory slotInv) {
        MenuOpener.open(TYPE, (class_1657)player, locator);
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof SetProcessingPatternAmountMenu) {
            SetProcessingPatternAmountMenu menu = (SetProcessingPatternAmountMenu)class_17032;
            menu.setPatternSlot(slotInv);
            menu.method_7623();
        }
    }

    @Override
    public void method_7623() {
        if (this.host.getMode() != EncodingMode.PROCESSING) {
            this.host.returnToMainMenu(this.getPlayer(), this);
            return;
        }
        super.method_7623();
        this.verifyPermissions(SecurityPermissions.BUILD, false);
    }

    public class_1937 getLevel() {
        return this.getPlayerInventory().field_7546.field_6002;
    }

    private void setPatternSlot(InternalInventory slotInv) {
        this.slotInv = slotInv;
        class_1799 stack = slotInv.getStackInSlot(0);
        GenericStack wrappedStack = GenericStack.unwrapItemStack(stack);
        this.initialAmount = wrappedStack != null ? Ints.saturatedCast((long)wrappedStack.amount()) : stack.method_7947();
        this.maxAmount = Integer.MAX_VALUE;
        this.visualSlot.method_7673(stack);
    }

    public int getMaxAmount() {
        return this.maxAmount;
    }

    public void confirm(int amount) {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_SET_AMOUNT, amount);
            return;
        }
        class_1799 currentStack = this.slotInv.getStackInSlot(0);
        if (!Objects.equals(currentStack, this.visualSlot.method_7677())) {
            this.host.returnToMainMenu(this.getPlayer(), this);
            return;
        }
        if ((amount = class_3532.method_15340((int)amount, (int)0, (int)Integer.MAX_VALUE)) <= 0) {
            this.slotInv.setItemDirect(0, class_1799.field_8037);
        } else {
            GenericStack unwrapped = GenericStack.fromItemStack(currentStack);
            if (unwrapped != null) {
                this.slotInv.setItemDirect(0, GenericStack.wrapInItemStack(unwrapped.what(), amount));
            }
        }
        this.host.returnToMainMenu(this.getPlayer(), this);
    }

    public int getInitialAmount() {
        return this.initialAmount;
    }

    @Nullable
    public AEKey getWhatToStock() {
        GenericStack stack = GenericStack.fromItemStack(this.visualSlot.method_7677());
        return stack != null ? stack.what() : null;
    }
}

