/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.slot;

import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.Icon;
import appeng.core.AELog;
import appeng.menu.AEBaseMenu;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public class AppEngSlot
extends class_1735 {
    private static final class_1263 EMPTY_INVENTORY = new class_1277(0);
    private final InternalInventory inventory;
    private final int invSlot;
    private boolean hideAmount;
    @Nullable
    private List<class_2561> emptyTooltip;
    private boolean isDraggable = true;
    private AEBaseMenu menu = null;
    @Nullable
    private Icon icon;
    private Boolean validState = null;
    private boolean rendering = false;

    public AppEngSlot(InternalInventory inv, int invSlot) {
        super(EMPTY_INVENTORY, invSlot, 0, 0);
        this.inventory = inv;
        this.invSlot = invSlot;
    }

    public class_1735 setNotDraggable() {
        this.setDraggable(false);
        return this;
    }

    public void clearStack() {
        this.inventory.setItemDirect(this.invSlot, class_1799.field_8037);
    }

    @Nullable
    public List<class_2561> getCustomTooltip(Function<class_1799, List<class_2561>> getItemTooltip, class_1799 carriedItem) {
        if (this.getDisplayStack().method_7960() && this.emptyTooltip != null) {
            return this.emptyTooltip;
        }
        return null;
    }

    public boolean method_7680(class_1799 stack) {
        if (this.containsWrapperItem()) {
            return false;
        }
        if (this.isSlotEnabled()) {
            return this.inventory.isItemValid(this.invSlot, stack);
        }
        return false;
    }

    public class_1799 method_7677() {
        if (!this.isSlotEnabled()) {
            return class_1799.field_8037;
        }
        if (this.field_7875 >= this.inventory.size()) {
            return class_1799.field_8037;
        }
        if (this.rendering) {
            this.rendering = false;
            return this.getDisplayStack();
        }
        return this.inventory.getStackInSlot(this.invSlot);
    }

    public void method_7673(class_1799 stack) {
        if (this.isSlotEnabled()) {
            this.inventory.setItemDirect(this.invSlot, stack);
            this.method_7668();
        }
    }

    private void notifyContainerSlotChanged() {
        if (this.getMenu() != null) {
            this.getMenu().onSlotChange(this);
        }
    }

    public InternalInventory getInventory() {
        return this.inventory;
    }

    public void method_7668() {
        super.method_7668();
        this.validState = null;
        this.notifyContainerSlotChanged();
    }

    public int method_7675() {
        return this.inventory.getSlotLimit(this.invSlot);
    }

    public int method_7676(class_1799 stack) {
        return Math.min(this.method_7675(), stack.method_7914());
    }

    public boolean method_7674(class_1657 player) {
        if (this.containsWrapperItem()) {
            return false;
        }
        if (this.isSlotEnabled()) {
            return !this.inventory.extractItem(this.invSlot, 1, true).method_7960();
        }
        return false;
    }

    public class_1799 method_7671(int amount) {
        if (this.containsWrapperItem()) {
            return class_1799.field_8037;
        }
        return this.inventory.extractItem(this.invSlot, amount, false);
    }

    private boolean containsWrapperItem() {
        return GenericStack.isWrapped(this.method_7677());
    }

    public boolean isSameInventory(class_1735 other) {
        return other instanceof AppEngSlot && ((AppEngSlot)other).inventory == this.inventory;
    }

    public InternalInventory getSlotInv() {
        return this.inventory.getSlotInv(this.invSlot);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_7682() {
        return this.isSlotEnabled();
    }

    public boolean isSlotEnabled() {
        return true;
    }

    public class_1799 getDisplayStack() {
        class_1799 is = this.inventory.getStackInSlot(this.invSlot);
        if (this.hideAmount) {
            GenericStack unwrapped = GenericStack.unwrapItemStack(is);
            if (unwrapped != null) {
                return GenericStack.wrapInItemStack(unwrapped.what(), 0L);
            }
            is = is.method_7972();
            is.method_7939(1);
        }
        return is;
    }

    public float getOpacityOfIcon() {
        return 0.4f;
    }

    public boolean renderIconWithItem() {
        return false;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public void setRendering(boolean rendering) {
        this.rendering = rendering;
    }

    public boolean isDraggable() {
        return this.isDraggable;
    }

    private void setDraggable(boolean isDraggable) {
        this.isDraggable = isDraggable;
    }

    protected AEBaseMenu getMenu() {
        return this.menu;
    }

    public void setMenu(AEBaseMenu menu) {
        this.menu = menu;
    }

    protected boolean isRemote() {
        return this.menu == null || this.menu.isClientSide();
    }

    public final boolean isValid() {
        if (this.validState == null) {
            try {
                this.validState = this.getCurrentValidationState();
            }
            catch (Exception e) {
                this.validState = false;
                AELog.warn("Failed to update validation state for slot %s: %s", new Object[]{this, e});
            }
        }
        return this.validState;
    }

    protected boolean getCurrentValidationState() {
        return true;
    }

    public void resetCachedValidation() {
        this.validState = null;
    }

    public boolean isHideAmount() {
        return this.hideAmount;
    }

    public void setHideAmount(boolean hideAmount) {
        this.hideAmount = hideAmount;
    }

    @Nullable
    public List<class_2561> getEmptyTooltip() {
        return this.emptyTooltip;
    }

    public void setEmptyTooltip(@Nullable List<class_2561> emptyTooltip) {
        this.emptyTooltip = emptyTooltip;
    }
}

