/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.stacks.AEItemKey;
import appeng.core.AppEng;
import appeng.core.sync.packets.BlockTransitionEffectPacket;
import appeng.core.sync.packets.ItemTransitionEffectPacket;
import appeng.parts.automation.PickupSink;
import appeng.parts.automation.PickupStrategy;
import appeng.util.Platform;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.tag.TagRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3614;

public class ItemPickupStrategy
implements PickupStrategy {
    private static final float SILK_TOUCH_FACTOR = 16.0f;
    public static final class_2960 TAG_BLACKLIST = new class_2960("ae2", "blacklisted/annihilation_plane");
    private static final class_3494<class_2248> BLOCK_BLACKLIST = TagRegistry.block((class_2960)TAG_BLACKLIST);
    private static final class_3494<class_1792> ITEM_BLACKLIST = TagRegistry.item((class_2960)TAG_BLACKLIST);
    private final class_3218 level;
    private final class_2338 pos;
    private final class_2350 side;
    private final class_2586 host;
    private final boolean allowSilkTouch;
    private boolean isAccepting = true;

    public ItemPickupStrategy(class_3218 level, class_2338 pos, class_2350 side, class_2586 host, boolean allowSilkTouch) {
        this.level = level;
        this.pos = pos;
        this.side = side;
        this.host = host;
        this.allowSilkTouch = allowSilkTouch;
    }

    @Override
    public void reset() {
        this.isAccepting = true;
    }

    @Override
    public boolean canPickUpEntity(class_1297 entity) {
        return entity instanceof class_1542;
    }

    @Override
    public boolean pickUpEntity(IEnergySource energySource, PickupSink sink, class_1297 entity) {
        if (!this.isAccepting || !(entity instanceof class_1542)) {
            return false;
        }
        class_1542 itemEntity = (class_1542)entity;
        if (ItemPickupStrategy.isItemBlacklisted(itemEntity.method_6983().method_7909())) {
            return false;
        }
        boolean changed = this.storeEntityItem(sink, itemEntity);
        if (changed) {
            AppEng.instance().sendToAllNearExcept(null, this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260(), 64.0, (class_1937)this.level, new ItemTransitionEffectPacket(entity.method_23317(), entity.method_23318(), entity.method_23321(), this.side));
        }
        return true;
    }

    @Override
    public PickupStrategy.Result tryStartPickup(IEnergySource energySource, PickupSink sink) {
        class_2680 blockState;
        if (this.isAccepting && this.canHandleBlock(this.level, this.pos, blockState = this.level.method_8320(this.pos))) {
            List<class_1799> items = this.obtainBlockDrops(this.level, this.pos);
            float requiredPower = this.calculateEnergyUsage(this.level, this.pos, items);
            boolean hasPower = energySource.extractAEPower(requiredPower, Actionable.SIMULATE, PowerMultiplier.CONFIG) > (double)requiredPower - 0.1;
            boolean canStore = this.canStoreItemStacks(sink, items);
            if (hasPower && canStore) {
                return PickupStrategy.Result.PICKED_UP;
            }
            return PickupStrategy.Result.CANT_STORE;
        }
        return PickupStrategy.Result.CANT_PICKUP;
    }

    @Override
    public void completePickup(IEnergySource energySource, PickupSink sink) {
        class_2680 blockState = this.level.method_8320(this.pos);
        if (!this.canHandleBlock(this.level, this.pos, blockState)) {
            return;
        }
        List<class_1799> items = this.obtainBlockDrops(this.level, this.pos);
        float requiredPower = this.calculateEnergyUsage(this.level, this.pos, items);
        if (!this.breakBlockAndStoreExtraItems(sink, this.level, this.pos)) {
            return;
        }
        for (class_1799 item : items) {
            int inserted = this.storeItemStack(sink, item);
            if (inserted >= item.method_7947()) continue;
            item.method_7934(inserted);
            Platform.spawnDrops((class_1937)this.level, this.pos, Collections.singletonList(item));
        }
        energySource.extractAEPower(requiredPower, Actionable.MODULATE, PowerMultiplier.CONFIG);
        AppEng.instance().sendToAllNearExcept(null, this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260(), 64.0, (class_1937)this.level, new BlockTransitionEffectPacket(this.pos, blockState, this.side, BlockTransitionEffectPacket.SoundMode.NONE));
    }

    private boolean storeEntityItem(PickupSink sink, class_1542 entityItem) {
        if (entityItem.method_5805()) {
            int inserted = this.storeItemStack(sink, entityItem.method_6983());
            return this.handleOverflow(entityItem, inserted);
        }
        return false;
    }

    private int storeItemStack(PickupSink sink, class_1799 item) {
        int amount;
        if (item.method_7960()) {
            return 0;
        }
        AEItemKey what = AEItemKey.of(item);
        int inserted = (int)sink.insert(what, amount = item.method_7947(), Actionable.MODULATE);
        this.isAccepting = inserted >= amount;
        return inserted;
    }

    private boolean handleOverflow(class_1542 entityItem, int inserted) {
        int entityItemCount = entityItem.method_6983().method_7947();
        if (inserted >= entityItemCount) {
            entityItem.method_31472();
            return true;
        }
        int newStackSize = entityItemCount - inserted;
        boolean changed = entityItemCount != newStackSize;
        entityItem.method_6983().method_7939(newStackSize);
        return changed;
    }

    private boolean canHandleBlock(class_3218 level, class_2338 pos, class_2680 state) {
        if (state.method_26215()) {
            return false;
        }
        if (ItemPickupStrategy.isBlockBlacklisted(state.method_26204())) {
            return false;
        }
        class_3614 material = state.method_26207();
        float hardness = state.method_26214((class_1922)level, pos);
        boolean ignoreAirAndFluids = material == class_3614.field_15959 || material.method_15797();
        return !ignoreAirAndFluids && hardness >= 0.0f && level.method_22340(pos) && level.method_8505(Platform.getPlayer(level), pos);
    }

    protected List<class_1799> obtainBlockDrops(class_3218 level, class_2338 pos) {
        class_1657 fakePlayer = Platform.getPlayer(level);
        class_2680 state = level.method_8320(pos);
        class_2586 blockEntity = level.method_8321(pos);
        HarvestTool harvestTool = this.createHarvestTool(state);
        class_1799 harvestToolItem = harvestTool.item();
        if (!state.method_29291() && harvestTool.fallback()) {
            harvestToolItem = class_1799.field_8037;
        }
        return class_2248.method_9609((class_2680)state, (class_3218)level, (class_2338)pos, (class_2586)blockEntity, (class_1297)fakePlayer, (class_1799)harvestToolItem);
    }

    protected float calculateEnergyUsage(class_3218 level, class_2338 pos, List<class_1799> items) {
        class_2680 state = level.method_8320(pos);
        float hardness = state.method_26214((class_1922)level, pos);
        float requiredEnergy = 1.0f + hardness;
        for (class_1799 is : items) {
            requiredEnergy += (float)is.method_7947();
        }
        if (this.allowSilkTouch) {
            requiredEnergy *= 16.0f;
        }
        return requiredEnergy;
    }

    private boolean canStoreItemStacks(PickupSink sink, List<class_1799> itemStacks) {
        boolean canStore = itemStacks.isEmpty();
        for (class_1799 itemStack : itemStacks) {
            AEItemKey itemToTest = AEItemKey.of(itemStack);
            long inserted = sink.insert(itemToTest, itemStack.method_7947(), Actionable.SIMULATE);
            if (inserted <= 0L) continue;
            canStore = true;
        }
        this.isAccepting = canStore;
        return canStore;
    }

    private boolean breakBlockAndStoreExtraItems(PickupSink sink, class_3218 level, class_2338 pos) {
        if (!level.method_22352(pos, false)) {
            return false;
        }
        class_238 box = new class_238(pos).method_1014(0.2);
        for (class_1542 itemEntity : level.method_18467(class_1542.class, box)) {
            this.storeEntityItem(sink, itemEntity);
        }
        return true;
    }

    private HarvestTool createHarvestTool(class_2680 state) {
        HarvestTool tool = state.method_26164((class_3494)class_3481.field_33715) ? new HarvestTool(new class_1799((class_1935)class_1802.field_8377, 1), false) : (state.method_26164((class_3494)class_3481.field_33713) ? new HarvestTool(new class_1799((class_1935)class_1802.field_8556, 1), false) : (state.method_26164((class_3494)class_3481.field_33716) ? new HarvestTool(new class_1799((class_1935)class_1802.field_8250, 1), false) : (state.method_26164((class_3494)class_3481.field_33714) ? new HarvestTool(new class_1799((class_1935)class_1802.field_8527, 1), false) : new HarvestTool(new class_1799((class_1935)class_1802.field_8377, 1), true))));
        if (this.allowSilkTouch) {
            class_1799 item = tool.item().method_7972();
            class_1890.method_8214((Map)ImmutableMap.of((Object)class_1893.field_9099, (Object)1), (class_1799)item);
            tool = new HarvestTool(item, false);
        }
        return tool;
    }

    public static boolean isBlockBlacklisted(class_2248 b) {
        return BLOCK_BLACKLIST.method_15141((Object)b);
    }

    public static boolean isItemBlacklisted(class_1792 i) {
        return ITEM_BLACKLIST.method_15141((Object)i);
    }

    record HarvestTool(class_1799 item, boolean fallback) {
    }
}

